/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.MessageAggregator;
import reactor.core.publisher.Flux;

public class ChatClientMessageAggregator {
    private static final Logger logger = LoggerFactory.getLogger(ChatClientMessageAggregator.class);

    public Flux<ChatClientResponse> aggregateChatClientResponse(Flux<ChatClientResponse> chatClientResponses, Consumer<ChatClientResponse> aggregationHandler) {
        AtomicReference context = new AtomicReference(new HashMap());
        return new MessageAggregator().aggregate(chatClientResponses.mapNotNull(chatClientResponse -> {
            ((Map)context.get()).putAll(chatClientResponse.context());
            return chatClientResponse.chatResponse();
        }), aggregatedChatResponse -> {
            ChatClientResponse aggregatedChatClientResponse = ChatClientResponse.builder().chatResponse((ChatResponse)aggregatedChatResponse).context((Map)context.get()).build();
            aggregationHandler.accept(aggregatedChatClientResponse);
        }).map(chatResponse -> ChatClientResponse.builder().chatResponse((ChatResponse)chatResponse).context((Map)context.get()).build());
    }
}

