/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.google.genai.autoconfigure.embedding;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.genai.Client;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.ai.google.genai.GoogleGenAiEmbeddingConnectionDetails;
import org.springframework.ai.model.google.genai.autoconfigure.embedding.GoogleGenAiEmbeddingConnectionProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={Client.class, GoogleGenAiEmbeddingConnectionDetails.class})
@EnableConfigurationProperties(value={GoogleGenAiEmbeddingConnectionProperties.class})
public class GoogleGenAiEmbeddingConnectionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GoogleGenAiEmbeddingConnectionDetails googleGenAiEmbeddingConnectionDetails(GoogleGenAiEmbeddingConnectionProperties connectionProperties) throws IOException {
        GoogleGenAiEmbeddingConnectionDetails.Builder connectionBuilder = GoogleGenAiEmbeddingConnectionDetails.builder();
        if (StringUtils.hasText((String)connectionProperties.getApiKey())) {
            connectionBuilder.apiKey(connectionProperties.getApiKey());
        } else {
            Assert.hasText((String)connectionProperties.getProjectId(), (String)"Google GenAI project-id must be set!");
            Assert.hasText((String)connectionProperties.getLocation(), (String)"Google GenAI location must be set!");
            connectionBuilder.projectId(connectionProperties.getProjectId()).location(connectionProperties.getLocation());
            if (connectionProperties.getCredentialsUri() != null) {
                GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)connectionProperties.getCredentialsUri().getInputStream());
            }
        }
        return connectionBuilder.build();
    }
}

