/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.google.genai.autoconfigure.chat;

import org.springframework.ai.google.genai.GoogleGenAiChatModel;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class CachedContentServiceCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        try {
            if (!context.getBeanFactory().containsBean("googleGenAiChatModel")) {
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition((String)"CachedContentService", (Object[])new Object[0]).didNotFind("GoogleGenAiChatModel bean").atAll());
            }
            GoogleGenAiChatModel chatModel = (GoogleGenAiChatModel)context.getBeanFactory().getBean(GoogleGenAiChatModel.class);
            if (chatModel.getCachedContentService() == null) {
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition((String)"CachedContentService", (Object[])new Object[0]).because("chat model's cached content service is null"));
            }
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition((String)"CachedContentService", (Object[])new Object[0]).found("cached content service").atAll());
        }
        catch (Exception e) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition((String)"CachedContentService", (Object[])new Object[0]).because("error checking condition: " + e.getMessage()));
        }
    }
}

