/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.core.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springdoc.core.fn.AbstractRouterFunctionVisitor;
import org.springdoc.core.providers.RouterFunctionProvider;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RequestPredicates;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;

public class RouterFunctionWebMvcProvider
implements RouterFunctionProvider,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public Optional<Map<String, AbstractRouterFunctionVisitor>> getRouterFunctionPaths() {
        Map routerBeans = this.applicationContext.getBeansOfType(RouterFunction.class);
        if (CollectionUtils.isEmpty((Map)routerBeans)) {
            return Optional.empty();
        }
        HashMap<String, RouterFunctionVisitor> routerFunctionVisitorMap = new HashMap<String, RouterFunctionVisitor>();
        for (Map.Entry entry : routerBeans.entrySet()) {
            RouterFunction routerFunction = (RouterFunction)entry.getValue();
            RouterFunctionVisitor routerFunctionVisitor = new RouterFunctionVisitor();
            routerFunction.accept((RouterFunctions.Visitor)routerFunctionVisitor);
            routerFunctionVisitorMap.put((String)entry.getKey(), routerFunctionVisitor);
        }
        return Optional.of(routerFunctionVisitorMap);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private class RouterFunctionVisitor
    extends AbstractRouterFunctionVisitor
    implements RouterFunctions.Visitor,
    RequestPredicates.Visitor {
        private RouterFunctionVisitor() {
        }

        public void route(RequestPredicate predicate, HandlerFunction<?> handlerFunction) {
            this.currentRouterFunctionDatas = new ArrayList();
            predicate.accept((RequestPredicates.Visitor)this);
            this.commonRoute();
        }

        public void resources(Function<ServerRequest, Optional<Resource>> lookupFunction) {
        }

        public void unknown(RouterFunction<?> routerFunction) {
        }

        public void unknown(RequestPredicate predicate) {
        }

        public void startNested(RequestPredicate predicate) {
            this.commonStartNested();
            predicate.accept((RequestPredicates.Visitor)this);
        }

        public void endNested(RequestPredicate predicate) {
            this.commonEndNested();
        }
    }
}

