/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import java.util.Optional;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.webflux.ui.SwaggerIndexTransformer;
import org.springdoc.webflux.ui.SwaggerResourceResolver;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceTransformer;

public class SwaggerWebFluxConfigurer
implements WebFluxConfigurer {
    private final SwaggerIndexTransformer swaggerIndexTransformer;
    private final Optional<ActuatorProvider> actuatorProvider;
    private final SwaggerResourceResolver swaggerResourceResolver;
    private final SwaggerUiConfigProperties swaggerUiConfigProperties;
    private final SpringDocConfigProperties springDocConfigProperties;

    public SwaggerWebFluxConfigurer(SwaggerUiConfigProperties swaggerUiConfigProperties, SpringDocConfigProperties springDocConfigProperties, SwaggerIndexTransformer swaggerIndexTransformer, Optional<ActuatorProvider> actuatorProvider, SwaggerResourceResolver swaggerResourceResolver) {
        this.swaggerIndexTransformer = swaggerIndexTransformer;
        this.actuatorProvider = actuatorProvider;
        this.swaggerResourceResolver = swaggerResourceResolver;
        this.swaggerUiConfigProperties = swaggerUiConfigProperties;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        StringBuilder uiRootPath = new StringBuilder();
        String swaggerPath = this.swaggerUiConfigProperties.getPath();
        if (swaggerPath.contains("/")) {
            uiRootPath.append(swaggerPath, 0, swaggerPath.lastIndexOf("/"));
        }
        if (this.actuatorProvider.isPresent() && this.actuatorProvider.get().isUseManagementPort()) {
            uiRootPath.append(this.actuatorProvider.get().getBasePath());
        }
        registry.addResourceHandler(new String[]{uiRootPath + this.springDocConfigProperties.getWebjars().getPrefix() + "/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).resourceChain(false).addResolver((ResourceResolver)this.swaggerResourceResolver).addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }
}

