/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.core.providers;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.core.versions.HeaderVersionStrategy;
import org.springdoc.core.versions.MediaTypeVersionStrategy;
import org.springdoc.core.versions.PathVersionStrategy;
import org.springdoc.core.versions.QueryParamVersionStrategy;
import org.springdoc.core.versions.SpringDocApiVersionType;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.accept.ApiVersionResolver;
import org.springframework.web.reactive.accept.ApiVersionStrategy;
import org.springframework.web.reactive.accept.DefaultApiVersionStrategy;
import org.springframework.web.reactive.accept.HeaderApiVersionResolver;
import org.springframework.web.reactive.accept.MediaTypeParamApiVersionResolver;
import org.springframework.web.reactive.accept.PathApiVersionResolver;
import org.springframework.web.reactive.accept.QueryApiVersionResolver;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.method.AbstractHandlerMethodMapping;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;

public class SpringWebFluxProvider
extends SpringWebProvider {
    public SpringWebFluxProvider(Optional<ApiVersionStrategy> apiVersionStrategyOptional) {
        apiVersionStrategyOptional.ifPresent(apiVersionStrategy -> {
            try {
                DefaultApiVersionStrategy defaultApiVersionStrategy = (DefaultApiVersionStrategy)apiVersionStrategy;
                String defaultVersion = null;
                if (defaultApiVersionStrategy.getDefaultVersion() != null) {
                    defaultVersion = defaultApiVersionStrategy.getDefaultVersion().toString();
                }
                Field field = FieldUtils.getDeclaredField(DefaultApiVersionStrategy.class, (String)"versionResolvers", (boolean)true);
                List versionResolvers = (List)field.get(defaultApiVersionStrategy);
                for (ApiVersionResolver apiVersionResolver : versionResolvers) {
                    if (apiVersionResolver instanceof MediaTypeParamApiVersionResolver) {
                        MediaTypeParamApiVersionResolver mediaTypeParamApiVersionResolver = (MediaTypeParamApiVersionResolver)apiVersionResolver;
                        field = FieldUtils.getDeclaredField(MediaTypeParamApiVersionResolver.class, (String)"compatibleMediaType", (boolean)true);
                        MediaType mediaType = (MediaType)field.get(mediaTypeParamApiVersionResolver);
                        field = FieldUtils.getDeclaredField(MediaTypeParamApiVersionResolver.class, (String)"parameterName", (boolean)true);
                        String parameterName = (String)field.get(mediaTypeParamApiVersionResolver);
                        MediaTypeVersionStrategy mediaTypeStrategy = new MediaTypeVersionStrategy(mediaType, parameterName, defaultVersion);
                        this.springDocVersionStrategyMap.put(SpringDocApiVersionType.MEDIA_TYPE, mediaTypeStrategy);
                        continue;
                    }
                    if (apiVersionResolver instanceof PathApiVersionResolver) {
                        PathApiVersionResolver pathApiVersionResolver = (PathApiVersionResolver)apiVersionResolver;
                        field = FieldUtils.getDeclaredField(PathApiVersionResolver.class, (String)"pathSegmentIndex", (boolean)true);
                        Integer pathSegmentIndex = (Integer)field.get(pathApiVersionResolver);
                        PathVersionStrategy pathVersionStrategy = new PathVersionStrategy(pathSegmentIndex.intValue(), defaultVersion);
                        this.springDocVersionStrategyMap.put(SpringDocApiVersionType.PATH, pathVersionStrategy);
                        continue;
                    }
                    if (apiVersionResolver instanceof HeaderApiVersionResolver) {
                        HeaderApiVersionResolver headerApiVersionResolver = (HeaderApiVersionResolver)apiVersionResolver;
                        field = FieldUtils.getDeclaredField(HeaderApiVersionResolver.class, (String)"headerName", (boolean)true);
                        String headerName = (String)field.get(headerApiVersionResolver);
                        HeaderVersionStrategy headerVersionStrategy = new HeaderVersionStrategy(headerName, defaultVersion);
                        this.springDocVersionStrategyMap.put(SpringDocApiVersionType.HEADER, headerVersionStrategy);
                        continue;
                    }
                    if (!(apiVersionResolver instanceof QueryApiVersionResolver)) continue;
                    QueryApiVersionResolver queryApiVersionResolver = (QueryApiVersionResolver)apiVersionResolver;
                    field = FieldUtils.getDeclaredField(QueryApiVersionResolver.class, (String)"queryParamName", (boolean)true);
                    String queryParamName = (String)field.get(queryApiVersionResolver);
                    QueryParamVersionStrategy queryParamVersionStrategy = new QueryParamVersionStrategy(queryParamName, defaultVersion);
                    this.springDocVersionStrategyMap.put(SpringDocApiVersionType.QUERY_PARAM, queryParamVersionStrategy);
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
            }
        });
    }

    public String findPathPrefix(SpringDocConfigProperties springDocConfigProperties) {
        Map map = this.getHandlerMethods();
        for (Map.Entry entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            Set<String> patterns = this.getActivePatterns(requestMappingInfo);
            if (CollectionUtils.isEmpty(patterns)) continue;
            for (String operationPath : patterns) {
                if (!operationPath.endsWith(springDocConfigProperties.getApiDocs().getPath())) continue;
                return operationPath.replace(springDocConfigProperties.getApiDocs().getPath(), "");
            }
        }
        return "";
    }

    public Set<String> getActivePatterns(Object requestMapping) {
        RequestMappingInfo requestMappingInfo = (RequestMappingInfo)requestMapping;
        PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
        return patternsRequestCondition.getPatterns().stream().map(PathPattern::getPatternString).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Map getHandlerMethods() {
        if (this.handlerMethods == null) {
            Map beansOfTypeRequestMappingHandlerMapping = this.applicationContext.getBeansOfType(RequestMappingHandlerMapping.class);
            this.handlerMethods = beansOfTypeRequestMappingHandlerMapping.values().stream().map(AbstractHandlerMethodMapping::getHandlerMethods).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1, LinkedHashMap::new));
        }
        return this.handlerMethods;
    }
}

