/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import java.util.Arrays;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public abstract class AbstractSwaggerConfigurer {
    private final SwaggerUiConfigProperties swaggerUiConfigProperties;
    private final WebProperties springWebProperties;
    private final PathPatternParser parser = new PathPatternParser();

    protected AbstractSwaggerConfigurer(SwaggerUiConfigProperties swaggerUiConfigProperties, WebProperties springWebProperties) {
        this.swaggerUiConfigProperties = swaggerUiConfigProperties;
        this.springWebProperties = springWebProperties;
    }

    protected SwaggerResourceHandlerConfig[] getSwaggerHandlerConfigs() {
        String swaggerUiPattern = this.getUiRootPath() + "/swagger-ui/**";
        String swaggerUiInitializerPattern = this.combinePatterns(swaggerUiPattern, "/*swagger-initializer.js");
        String swaggerUiResourceLocation = "classpath:META-INF/resources/webjars/swagger-ui/" + this.swaggerUiConfigProperties.getVersion() + "/";
        return new SwaggerResourceHandlerConfig[]{SwaggerResourceHandlerConfig.createCached().setPatterns(swaggerUiPattern).setLocations(swaggerUiResourceLocation), SwaggerResourceHandlerConfig.createUncached().setPatterns(swaggerUiInitializerPattern).setLocations(swaggerUiResourceLocation)};
    }

    protected SwaggerResourceHandlerConfig[] getSwaggerWebjarHandlerConfigs() {
        if (!this.springWebProperties.getResources().isAddMappings()) {
            return new SwaggerResourceHandlerConfig[0];
        }
        String swaggerUiWebjarPattern = this.combinePatterns(this.getWebjarsPathPattern(), "/*swagger-ui") + "/**";
        String swaggerUiWebjarInitializerPattern = this.combinePatterns(swaggerUiWebjarPattern, "/*swagger-initializer.js");
        String swaggerUiWebjarVersionInitializerPattern = this.combinePatterns(swaggerUiWebjarPattern, this.swaggerUiConfigProperties.getVersion() + "/*swagger-initializer.js");
        String swaggerUiWebjarResourceLocation = "classpath:META-INF/resources/webjars/";
        return new SwaggerResourceHandlerConfig[]{SwaggerResourceHandlerConfig.createCached().setPatterns(swaggerUiWebjarPattern).setLocations(swaggerUiWebjarResourceLocation), SwaggerResourceHandlerConfig.createUncached().setPatterns(swaggerUiWebjarInitializerPattern, swaggerUiWebjarVersionInitializerPattern).setLocations(swaggerUiWebjarResourceLocation)};
    }

    protected abstract String getUiRootPath();

    protected abstract String getWebjarsPathPattern();

    protected String combinePatterns(String ... patterns) {
        return Arrays.stream(patterns).map(this::parsePattern).reduce(PathPattern::combine).map(PathPattern::getPatternString).orElseThrow(IllegalArgumentException::new);
    }

    private PathPattern parsePattern(String pattern) {
        return this.parser.parse(this.parser.initFullPathPattern(pattern));
    }

    protected record SwaggerResourceHandlerConfig(boolean cacheResources, String[] patterns, String[] locations) {
        private SwaggerResourceHandlerConfig(boolean cacheResources) {
            this(cacheResources, new String[0], new String[0]);
        }

        public SwaggerResourceHandlerConfig setPatterns(String ... patterns) {
            return new SwaggerResourceHandlerConfig(this.cacheResources, patterns, this.locations);
        }

        public SwaggerResourceHandlerConfig setLocations(String ... locations) {
            return new SwaggerResourceHandlerConfig(this.cacheResources, this.patterns, locations);
        }

        public static SwaggerResourceHandlerConfig createCached() {
            return new SwaggerResourceHandlerConfig(true);
        }

        public static SwaggerResourceHandlerConfig createUncached() {
            return new SwaggerResourceHandlerConfig(false);
        }
    }
}

