/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.utils;

import java.lang.reflect.Field;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.core.KotlinDetector;

public class SpringDocKotlinUtils {
    static boolean isKotlinDeclaringClass(Field f) {
        return KotlinDetector.isKotlinPresent() && KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(f.getDeclaringClass());
    }

    private static Boolean kotlinMarkedNullableFallback(Field f) {
        try {
            KClass kClass = JvmClassMappingKt.getKotlinClass(f.getDeclaringClass());
            for (Object pObj : KClasses.getMemberProperties((KClass)kClass)) {
                KProperty1 p = (KProperty1)pObj;
                if (!p.getName().equals(f.getName())) continue;
                return p.getReturnType().isMarkedNullable();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static Boolean kotlinConstructorParamIsOptional(Field f) {
        try {
            KClass kClass = JvmClassMappingKt.getKotlinClass(f.getDeclaringClass());
            KFunction primary = KClasses.getPrimaryConstructor((KClass)kClass);
            if (primary != null) {
                for (KParameter p : primary.getParameters()) {
                    if (!f.getName().equals(p.getName())) continue;
                    return p.isOptional();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static Boolean kotlinNullability(Field field) {
        if (!SpringDocKotlinUtils.isKotlinDeclaringClass(field)) {
            return null;
        }
        KProperty prop = ReflectJvmMapping.getKotlinProperty((Field)field);
        if (prop != null) {
            return prop.getReturnType().isMarkedNullable();
        }
        return SpringDocKotlinUtils.kotlinMarkedNullableFallback(field);
    }
}

