/*
 *
 *  *
 *  *  *
 *  *  *  *
 *  *  *  *  *
 *  *  *  *  *  * Copyright 2019-2025 the original author or authors.
 *  *  *  *  *  *
 *  *  *  *  *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  *  *  *  *  * you may not use this file except in compliance with the License.
 *  *  *  *  *  * You may obtain a copy of the License at
 *  *  *  *  *  *
 *  *  *  *  *  *      https://www.apache.org/licenses/LICENSE-2.0
 *  *  *  *  *  *
 *  *  *  *  *  * Unless required by applicable law or agreed to in writing, software
 *  *  *  *  *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  *  *  *  *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  *  *  *  *  * See the License for the specific language governing permissions and
 *  *  *  *  *  * limitations under the License.
 *  *  *  *  *
 *  *  *  *
 *  *  *
 *  *
 *
 */

package org.springdoc.core.customizers;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;

import org.springframework.web.method.HandlerMethod;

/**
 * Implement and register a bean of type {@link GlobalOperationComponentsCustomizer} to
 * customize an operation based on the components and handler method input on default OpenAPI
 * description and groups
 *
 * @author christophejan
 * @see OperationCustomizer operations on default OpenAPI      description but not groups
 */
public interface GlobalOperationComponentsCustomizer extends GlobalOperationCustomizer {

	/**
	 * Customize operation.
	 *
	 * @param operation     input operation
	 * @param handlerMethod original handler method
	 * @return customized operation
	 */
	Operation customize(Operation operation, Components components, HandlerMethod handlerMethod);
}
