/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.fn;

import io.swagger.v3.oas.models.Operation;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.Constants;
import org.springdoc.core.fn.RouterFunctionData;
import org.springdoc.core.fn.builders.operation.Builder;
import org.springframework.web.bind.annotation.RequestMethod;

public class RouterOperation
implements Comparable<RouterOperation> {
    private String path;
    private RequestMethod[] methods;
    private String[] consumes;
    private String[] produces;
    private String[] headers;
    private Class<?> beanClass;
    private String beanMethod;
    private Class<?>[] parameterTypes;
    private Map<String, String> queryParams;
    private io.swagger.v3.oas.annotations.Operation operation;
    private Operation operationModel;

    public RouterOperation() {
    }

    public RouterOperation(org.springdoc.core.annotations.RouterOperation routerOperationAnnotation) {
        this.path = routerOperationAnnotation.path();
        this.methods = routerOperationAnnotation.method();
        this.consumes = routerOperationAnnotation.consumes();
        this.produces = routerOperationAnnotation.produces();
        this.beanClass = routerOperationAnnotation.beanClass();
        this.beanMethod = routerOperationAnnotation.beanMethod();
        this.parameterTypes = routerOperationAnnotation.parameterTypes();
        this.operation = routerOperationAnnotation.operation();
        this.headers = routerOperationAnnotation.headers();
    }

    public RouterOperation(org.springdoc.core.annotations.RouterOperation routerOperationAnnotation, RouterFunctionData routerFunctionData) {
        this.path = StringUtils.isBlank((CharSequence)routerOperationAnnotation.path()) ? routerFunctionData.getPath() : routerOperationAnnotation.path();
        this.methods = ArrayUtils.isEmpty((Object[])routerOperationAnnotation.method()) ? routerFunctionData.getMethods() : routerOperationAnnotation.method();
        this.consumes = ArrayUtils.isEmpty((Object[])routerOperationAnnotation.consumes()) ? routerFunctionData.getConsumes() : routerOperationAnnotation.consumes();
        this.produces = ArrayUtils.isEmpty((Object[])routerOperationAnnotation.produces()) ? routerFunctionData.getProduces() : routerOperationAnnotation.produces();
        this.beanClass = routerOperationAnnotation.beanClass();
        this.beanMethod = routerOperationAnnotation.beanMethod();
        this.parameterTypes = routerOperationAnnotation.parameterTypes();
        this.operation = routerOperationAnnotation.operation();
        this.headers = ArrayUtils.isEmpty((Object[])routerOperationAnnotation.headers()) ? routerFunctionData.getHeaders() : routerOperationAnnotation.headers();
        this.queryParams = routerFunctionData.getQueryParams();
    }

    public RouterOperation(String path, RequestMethod[] methods) {
        this.path = path;
        this.methods = methods;
    }

    public RouterOperation(RouterFunctionData routerFunctionData) {
        this.path = routerFunctionData.getPath();
        this.methods = routerFunctionData.getMethods();
        this.consumes = routerFunctionData.getConsumes();
        this.produces = routerFunctionData.getProduces();
        this.headers = routerFunctionData.getHeaders();
        this.queryParams = routerFunctionData.getQueryParams();
        Map<String, Object> attributes = routerFunctionData.getAttributes();
        if (attributes.containsKey(Constants.OPERATION_ATTRIBUTE)) {
            Builder routerOperationBuilder = (Builder)attributes.get(Constants.OPERATION_ATTRIBUTE);
            RouterOperation routerOperation = routerOperationBuilder.build();
            this.beanClass = routerOperation.getBeanClass();
            this.beanMethod = routerOperation.getBeanMethod();
            this.parameterTypes = routerOperation.getParameterTypes();
            this.operation = routerOperation.getOperation();
        }
    }

    public RouterOperation(org.springdoc.core.annotations.RouterOperation routerOperation, RequestMethod requestMethod) {
        this(routerOperation);
        this.methods = new RequestMethod[]{requestMethod};
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RequestMethod[] getMethods() {
        return this.methods;
    }

    public void setMethods(RequestMethod[] methods) {
        this.methods = methods;
    }

    public String[] getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String[] consumes) {
        this.consumes = consumes;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public void setProduces(String[] produces) {
        this.produces = produces;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public String getBeanMethod() {
        return this.beanMethod;
    }

    public void setBeanMethod(String beanMethod) {
        this.beanMethod = beanMethod;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public io.swagger.v3.oas.annotations.Operation getOperation() {
        return this.operation;
    }

    public void setOperation(io.swagger.v3.oas.annotations.Operation operation) {
        this.operation = operation;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public Operation getOperationModel() {
        return this.operationModel;
    }

    public void setOperationModel(Operation operationModel) {
        this.operationModel = operationModel;
    }

    @Override
    public int compareTo(RouterOperation routerOperation) {
        int result = this.path.compareTo(routerOperation.getPath());
        if (result == 0 && !ArrayUtils.isEmpty((Object[])this.methods)) {
            result = this.methods[0].compareTo((Enum)routerOperation.getMethods()[0]);
        }
        if (result == 0 && this.operationModel != null && routerOperation.getOperationModel() != null) {
            result = this.operationModel.getOperationId().compareTo(routerOperation.getOperationModel().getOperationId());
        }
        if (result == 0 && this.operation != null) {
            result = this.operation.operationId().compareTo(routerOperation.getOperation().operationId());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouterOperation that = (RouterOperation)o;
        return Objects.equals(this.path, that.path) && Arrays.equals(this.methods, that.methods) && Arrays.equals(this.consumes, that.consumes) && Arrays.equals(this.produces, that.produces) && Arrays.equals(this.headers, that.headers) && Objects.equals(this.beanClass, that.beanClass) && Objects.equals(this.beanMethod, that.beanMethod) && Arrays.equals(this.parameterTypes, that.parameterTypes) && Objects.equals(this.queryParams, that.queryParams) && Objects.equals(this.operation, that.operation) && Objects.equals(this.operationModel, that.operationModel);
    }

    public int hashCode() {
        int result = Objects.hash(this.path, this.beanClass, this.beanMethod, this.queryParams, this.operation, this.operationModel);
        result = 31 * result + Arrays.hashCode(this.methods);
        result = 31 * result + Arrays.hashCode(this.consumes);
        result = 31 * result + Arrays.hashCode(this.produces);
        result = 31 * result + Arrays.hashCode(this.headers);
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }
}

