/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SecuritySchemePair;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;

@Component
class SecurityParser {
    SecurityParser() {
    }

    private static boolean isEmpty(OAuthFlows oAuthFlows) {
        boolean result = oAuthFlows == null ? true : (!SecurityParser.isEmpty(oAuthFlows.implicit()) || !SecurityParser.isEmpty(oAuthFlows.authorizationCode()) || !SecurityParser.isEmpty(oAuthFlows.clientCredentials()) || !SecurityParser.isEmpty(oAuthFlows.password()) ? false : oAuthFlows.extensions().length <= 0);
        return result;
    }

    private static boolean isEmpty(io.swagger.v3.oas.annotations.security.OAuthFlow oAuthFlow) {
        boolean result = oAuthFlow == null ? true : (!StringUtils.isBlank((CharSequence)oAuthFlow.authorizationUrl()) || !StringUtils.isBlank((CharSequence)oAuthFlow.refreshUrl()) || !StringUtils.isBlank((CharSequence)oAuthFlow.tokenUrl()) || !SecurityParser.isEmpty(oAuthFlow.scopes()) ? false : oAuthFlow.extensions().length <= 0);
        return result;
    }

    private static boolean isEmpty(OAuthScope[] scopes) {
        boolean result = false;
        if (scopes == null || scopes.length == 0) {
            result = true;
        }
        return result;
    }

    public Optional<io.swagger.v3.oas.annotations.security.SecurityRequirement[]> getSecurityRequirements(HandlerMethod method) {
        SecurityRequirements classSecurity = (SecurityRequirements)ReflectionUtils.getAnnotation((Class)method.getBeanType(), SecurityRequirements.class);
        SecurityRequirements methodSecurity = (SecurityRequirements)ReflectionUtils.getAnnotation((Method)method.getMethod(), SecurityRequirements.class);
        HashSet<io.swagger.v3.oas.annotations.security.SecurityRequirement> allSecurityTags = new HashSet<io.swagger.v3.oas.annotations.security.SecurityRequirement>();
        if (classSecurity != null) {
            allSecurityTags.addAll(Arrays.asList(classSecurity.value()));
        }
        if (methodSecurity != null) {
            allSecurityTags.addAll(Arrays.asList(methodSecurity.value()));
        }
        if (allSecurityTags.isEmpty()) {
            List securityRequirementsClassList = ReflectionUtils.getRepeatableAnnotations((Class)method.getBeanType(), io.swagger.v3.oas.annotations.security.SecurityRequirement.class);
            List securityRequirementsMethodList = ReflectionUtils.getRepeatableAnnotations((Method)method.getMethod(), io.swagger.v3.oas.annotations.security.SecurityRequirement.class);
            if (!CollectionUtils.isEmpty((Collection)securityRequirementsClassList)) {
                allSecurityTags.addAll(securityRequirementsClassList);
            }
            if (!CollectionUtils.isEmpty((Collection)securityRequirementsMethodList)) {
                allSecurityTags.addAll(securityRequirementsMethodList);
            }
        }
        if (allSecurityTags.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(allSecurityTags.toArray(new io.swagger.v3.oas.annotations.security.SecurityRequirement[0]));
    }

    public Optional<List<SecurityRequirement>> getSecurityRequirements(io.swagger.v3.oas.annotations.security.SecurityRequirement[] securityRequirementsApi) {
        if (securityRequirementsApi == null || securityRequirementsApi.length == 0) {
            return Optional.empty();
        }
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (io.swagger.v3.oas.annotations.security.SecurityRequirement securityRequirementApi : securityRequirementsApi) {
            if (StringUtils.isBlank((CharSequence)securityRequirementApi.name())) continue;
            SecurityRequirement securityRequirement = new SecurityRequirement();
            if (securityRequirementApi.scopes().length > 0) {
                securityRequirement.addList(securityRequirementApi.name(), Arrays.asList(securityRequirementApi.scopes()));
            } else {
                securityRequirement.addList(securityRequirementApi.name());
            }
            securityRequirements.add(securityRequirement);
        }
        if (securityRequirements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(securityRequirements);
    }

    public Optional<SecuritySchemePair> getSecurityScheme(io.swagger.v3.oas.annotations.security.SecurityScheme securityScheme) {
        if (securityScheme == null) {
            return Optional.empty();
        }
        String key = null;
        SecurityScheme securitySchemeObject = new SecurityScheme();
        if (StringUtils.isNotBlank((CharSequence)securityScheme.in().toString())) {
            securitySchemeObject.setIn(this.getIn(securityScheme.in().toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.type().toString())) {
            securitySchemeObject.setType(this.getType(securityScheme.type().toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.openIdConnectUrl())) {
            securitySchemeObject.setOpenIdConnectUrl(securityScheme.openIdConnectUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.scheme())) {
            securitySchemeObject.setScheme(securityScheme.scheme());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.bearerFormat())) {
            securitySchemeObject.setBearerFormat(securityScheme.bearerFormat());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.description())) {
            securitySchemeObject.setDescription(securityScheme.description());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.paramName())) {
            securitySchemeObject.setName(securityScheme.paramName());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.ref())) {
            securitySchemeObject.set$ref(securityScheme.ref());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.name())) {
            key = securityScheme.name();
            if (SecuritySchemeType.APIKEY.toString().equals(securitySchemeObject.getType().toString())) {
                securitySchemeObject.setName(securityScheme.name());
            }
        }
        if (securityScheme.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])securityScheme.extensions());
            extensions.forEach((arg_0, arg_1) -> ((SecurityScheme)securitySchemeObject).addExtension(arg_0, arg_1));
        }
        this.getOAuthFlows(securityScheme.flows()).ifPresent(arg_0 -> ((SecurityScheme)securitySchemeObject).setFlows(arg_0));
        SecuritySchemePair result = new SecuritySchemePair(key, securitySchemeObject);
        return Optional.of(result);
    }

    public void buildSecurityRequirement(io.swagger.v3.oas.annotations.security.SecurityRequirement[] securityRequirements, Operation operation) {
        Optional<List<SecurityRequirement>> requirementsObject = this.getSecurityRequirements(securityRequirements);
        requirementsObject.ifPresent(requirements -> requirements.stream().filter(r -> operation.getSecurity() == null || !operation.getSecurity().contains(r)).forEach(arg_0 -> ((Operation)operation).addSecurityItem(arg_0)));
    }

    private Optional<io.swagger.v3.oas.models.security.OAuthFlows> getOAuthFlows(OAuthFlows oAuthFlows) {
        if (SecurityParser.isEmpty(oAuthFlows)) {
            return Optional.empty();
        }
        io.swagger.v3.oas.models.security.OAuthFlows oAuthFlowsObject = new io.swagger.v3.oas.models.security.OAuthFlows();
        if (oAuthFlows.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])oAuthFlows.extensions());
            extensions.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).addExtension(arg_0, arg_1));
        }
        this.getOAuthFlow(oAuthFlows.authorizationCode()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setAuthorizationCode(arg_0));
        this.getOAuthFlow(oAuthFlows.clientCredentials()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setClientCredentials(arg_0));
        this.getOAuthFlow(oAuthFlows.implicit()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setImplicit(arg_0));
        this.getOAuthFlow(oAuthFlows.password()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setPassword(arg_0));
        return Optional.of(oAuthFlowsObject);
    }

    private Optional<OAuthFlow> getOAuthFlow(io.swagger.v3.oas.annotations.security.OAuthFlow oAuthFlow) {
        if (SecurityParser.isEmpty(oAuthFlow)) {
            return Optional.empty();
        }
        OAuthFlow oAuthFlowObject = new OAuthFlow();
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            oAuthFlowObject.setAuthorizationUrl(oAuthFlow.authorizationUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.refreshUrl())) {
            oAuthFlowObject.setRefreshUrl(oAuthFlow.refreshUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.tokenUrl())) {
            oAuthFlowObject.setTokenUrl(oAuthFlow.tokenUrl());
        }
        if (oAuthFlow.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])oAuthFlow.extensions());
            extensions.forEach((arg_0, arg_1) -> ((OAuthFlow)oAuthFlowObject).addExtension(arg_0, arg_1));
        }
        this.getScopes(oAuthFlow.scopes()).ifPresent(arg_0 -> ((OAuthFlow)oAuthFlowObject).setScopes(arg_0));
        return Optional.of(oAuthFlowObject);
    }

    private Optional<Scopes> getScopes(OAuthScope[] scopes) {
        if (SecurityParser.isEmpty(scopes)) {
            return Optional.empty();
        }
        Scopes scopesObject = new Scopes();
        Arrays.stream(scopes).forEach(scope -> scopesObject.addString(scope.name(), scope.description()));
        return Optional.of(scopesObject);
    }

    private SecurityScheme.In getIn(String value) {
        return Arrays.stream(SecurityScheme.In.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private SecurityScheme.Type getType(String value) {
        return Arrays.stream(SecurityScheme.Type.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }
}

