/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.qianfan.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import org.springaicommunity.qianfan.QianFanImageModel;
import org.springaicommunity.qianfan.api.QianFanApi;
import org.springaicommunity.qianfan.api.QianFanImageApi;
import org.springaicommunity.qianfan.autoconfigure.QianFanConnectionProperties;
import org.springaicommunity.qianfan.autoconfigure.QianFanImageProperties;
import org.springframework.ai.image.observation.ImageModelObservationConvention;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={QianFanApi.class})
@ConditionalOnProperty(name={"spring.ai.model.image"}, havingValue="qianfan", matchIfMissing=true)
@EnableConfigurationProperties(value={QianFanConnectionProperties.class, QianFanImageProperties.class})
public class QianFanImageAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public QianFanImageModel qianFanImageModel(QianFanConnectionProperties commonProperties, QianFanImageProperties imageProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ImageModelObservationConvention> observationConvention) {
        String apiKey = StringUtils.hasText((String)imageProperties.getApiKey()) ? imageProperties.getApiKey() : commonProperties.getApiKey();
        String secretKey = StringUtils.hasText((String)imageProperties.getSecretKey()) ? imageProperties.getSecretKey() : commonProperties.getSecretKey();
        String baseUrl = StringUtils.hasText((String)imageProperties.getBaseUrl()) ? imageProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)"QianFan API key must be set.  Use the property: spring.ai.qianfan.api-key");
        Assert.hasText((String)secretKey, (String)"QianFan secret key must be set.  Use the property: spring.ai.qianfan.secret-key");
        Assert.hasText((String)baseUrl, (String)"QianFan base URL must be set.  Use the property: spring.ai.qianfan.base-url");
        QianFanImageApi qianFanImageApi = new QianFanImageApi(baseUrl, apiKey, secretKey, (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), responseErrorHandler);
        QianFanImageModel imageModel = new QianFanImageModel(qianFanImageApi, imageProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((QianFanImageModel)imageModel).setObservationConvention(arg_0));
        return imageModel;
    }
}

