/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import spire.math.Natural;
import spire.math.NaturalAlgebra;
import spire.math.NaturalInstances;
import spire.math.NumberTag;
import spire.math.UInt;
import spire.math.UInt$;

public final class Natural$
implements NaturalInstances,
Serializable {
    public static Natural$ MODULE$;
    private final int denom;
    private final Natural ten18;
    private final Natural zero;
    private final Natural one;
    private final NaturalAlgebra NaturalAlgebra;
    private final NumberTag.CustomTag<Natural> NaturalTag;

    static {
        new Natural$();
    }

    @Override
    public final NaturalAlgebra NaturalAlgebra() {
        return this.NaturalAlgebra;
    }

    @Override
    public final NumberTag.CustomTag<Natural> NaturalTag() {
        return this.NaturalTag;
    }

    @Override
    public final void spire$math$NaturalInstances$_setter_$NaturalAlgebra_$eq(NaturalAlgebra x$1) {
        this.NaturalAlgebra = x$1;
    }

    @Override
    public final void spire$math$NaturalInstances$_setter_$NaturalTag_$eq(NumberTag.CustomTag<Natural> x$1) {
        this.NaturalTag = x$1;
    }

    public final int denom() {
        return this.denom;
    }

    public BigInt naturalToBigInt(Natural n) {
        return n.toBigInt();
    }

    public Natural apply(Seq<UInt> us) {
        if (us.isEmpty()) {
            throw new IllegalArgumentException("invalid arguments");
        }
        return (Natural)((Object)((TraversableOnce)us.tail()).foldLeft((Object)new Natural.End(((UInt)us.head()).signed()), (Function2 & java.io.Serializable & Serializable)(n, u) -> Natural$.$anonfun$apply$1(n, ((UInt)u).signed())));
    }

    public Natural apply(long n) {
        if ((n & 0xFFFFFFFFL) == n) {
            int n2 = (int)n;
            if (UInt$.MODULE$ == null) {
                throw null;
            }
            return new Natural.End(n2);
        }
        int n3 = (int)n;
        if (UInt$.MODULE$ == null) {
            throw null;
        }
        int n4 = (int)(n >> 32);
        if (UInt$.MODULE$ == null) {
            throw null;
        }
        return new Natural.Digit(n3, new Natural.End(n4));
    }

    /*
     * WARNING - void declaration
     */
    public Natural apply(BigInt n) {
        void apply_n;
        if (n.$less((Object)BigInt$.MODULE$.int2bigInt(0))) {
            String string = "negative numbers not allowed: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new IllegalArgumentException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        if (n.$less((Object)BigInt$.MODULE$.long2bigInt(0xFFFFFFFFL))) {
            void apply_n2;
            long l = n.toLong();
            if (UInt$.MODULE$ == null) {
                throw null;
            }
            return new Natural.End((int)apply_n2);
        }
        long l = n.$amp(BigInt$.MODULE$.long2bigInt(0xFFFFFFFFL)).toLong();
        if (UInt$.MODULE$ == null) {
            throw null;
        }
        return new Natural.Digit((int)apply_n, this.apply(n.$greater$greater(32)));
    }

    private Natural ten18() {
        return this.ten18;
    }

    public Natural apply(String s) {
        return this.parse$1(this.apply(0L), s, this.apply(1L));
    }

    public Natural zero() {
        return this.zero;
    }

    public Natural one() {
        return this.one;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Natural.Digit $anonfun$apply$1(Natural n, int u) {
        return new Natural.Digit(u, n);
    }

    private final Natural parse$1(Natural sofar, String s, Natural m) {
        while (true) {
            if (s.length() <= 18) {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return this.apply(new StringOps(s).toLong()).$times(m).$plus(sofar);
            }
            String p = s.substring(s.length() - 18, s.length());
            String r = s.substring(0, s.length() - 18);
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Natural natural = this.apply(new StringOps(p).toLong()).$times(m).$plus(sofar);
            m = m.$times(this.ten18());
            s = r;
            sofar = natural;
        }
    }

    private Natural$() {
        MODULE$ = this;
        NaturalInstances.$init$(this);
        int n = 1000000000;
        if (UInt$.MODULE$ == null) {
            throw null;
        }
        this.denom = n;
        this.ten18 = this.apply(1000000000000000000L);
        this.zero = this.apply(0L);
        this.one = this.apply(1L);
    }
}

