/*
 * Decompiled with CFR 0.152.
 */
package spire.std;

import spire.math.package$;
import spire.std.FloatIsField;

public abstract class FloatIsField$class {
    public static float minus(FloatIsField $this, float a, float b) {
        return $this.minus$mcF$sp(a, b);
    }

    public static float negate(FloatIsField $this, float a) {
        return $this.negate$mcF$sp(a);
    }

    public static float one(FloatIsField $this) {
        return $this.one$mcF$sp();
    }

    public static float plus(FloatIsField $this, float a, float b) {
        return $this.plus$mcF$sp(a, b);
    }

    public static float pow(FloatIsField $this, float a, int b) {
        return $this.pow$mcF$sp(a, b);
    }

    public static float times(FloatIsField $this, float a, float b) {
        return $this.times$mcF$sp(a, b);
    }

    public static float zero(FloatIsField $this) {
        return $this.zero$mcF$sp();
    }

    public static float fromInt(FloatIsField $this, int n) {
        return $this.fromInt$mcF$sp(n);
    }

    public static float quot(FloatIsField $this, float a, float b) {
        return $this.quot$mcF$sp(a, b);
    }

    public static float mod(FloatIsField $this, float a, float b) {
        return $this.mod$mcF$sp(a, b);
    }

    public static final float gcd(FloatIsField $this, float a, float b) {
        return $this.gcd$mcF$sp(a, b);
    }

    public static float fromDouble(FloatIsField $this, double n) {
        return $this.fromDouble$mcF$sp(n);
    }

    public static float div(FloatIsField $this, float a, float b) {
        return $this.div$mcF$sp(a, b);
    }

    public static float minus$mcF$sp(FloatIsField $this, float a, float b) {
        return a - b;
    }

    public static float negate$mcF$sp(FloatIsField $this, float a) {
        return -a;
    }

    public static float one$mcF$sp(FloatIsField $this) {
        return 1.0f;
    }

    public static float plus$mcF$sp(FloatIsField $this, float a, float b) {
        return a + b;
    }

    public static float pow$mcF$sp(FloatIsField $this, float a, int b) {
        return (float)Math.pow(a, b);
    }

    public static float times$mcF$sp(FloatIsField $this, float a, float b) {
        return a * b;
    }

    public static float zero$mcF$sp(FloatIsField $this) {
        return 0.0f;
    }

    public static float fromInt$mcF$sp(FloatIsField $this, int n) {
        return n;
    }

    public static float quot$mcF$sp(FloatIsField $this, float a, float b) {
        return (a - a % b) / b;
    }

    public static float mod$mcF$sp(FloatIsField $this, float a, float b) {
        return a % b;
    }

    public static float gcd$mcF$sp(FloatIsField $this, float a, float b) {
        float f;
        if (a == 0.0f) {
            f = b;
        } else if (b == 0.0f) {
            f = a;
        } else {
            int aBits = Float.floatToIntBits(a);
            int aVal = FloatIsField$class.value$1($this, aBits);
            int aExp = FloatIsField$class.exp$1($this, aBits);
            int bBits = Float.floatToIntBits(b);
            int bVal = FloatIsField$class.value$1($this, bBits);
            int bExp = FloatIsField$class.exp$1($this, bBits);
            f = aExp < bExp ? FloatIsField$class.gcd0$1($this, aVal, aExp, bVal, bExp) : FloatIsField$class.gcd0$1($this, bVal, bExp, aVal, aExp);
        }
        return f;
    }

    public static float fromDouble$mcF$sp(FloatIsField $this, double n) {
        return (float)n;
    }

    public static float div$mcF$sp(FloatIsField $this, float a, float b) {
        return a / b;
    }

    private static final int value$1(FloatIsField $this, int bits) {
        return bits & 0x7FFFFF | 0x800000;
    }

    private static final int exp$1(FloatIsField $this, int bits) {
        return bits >> 23 & 0xFF;
    }

    private static final float gcd0$1(FloatIsField $this, int val0, int exp0, int val1, int exp1) {
        int tz0 = Integer.numberOfTrailingZeros(val0);
        int tz1 = Integer.numberOfTrailingZeros(val1);
        int tzShared = package$.MODULE$.min(tz0, tz1 + exp1 - exp0);
        int n = (int)package$.MODULE$.gcd(val0 >>> tz0, val1 >>> tz1) << tzShared;
        int shift2 = Integer.numberOfLeadingZeros(n) - 8;
        int exp = exp0 - shift2;
        int shift0 = exp == 0 ? shift2 - 1 : shift2;
        int mantissa = n << shift0 & 0x7FFFFF;
        return exp < 0 ? 0.0f : Float.intBitsToFloat(exp << 23 | mantissa);
    }

    public static void $init$(FloatIsField $this) {
    }
}

