/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.set.hash.THashSet;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.PrintStream;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.spf4j.base.Pair;
import org.spf4j.base.SysExits;
import org.spf4j.base.Throwables;

public final class UncaughtExceptionDisplayer
implements Thread.UncaughtExceptionHandler {
    private static final Lock ERR_LOCK = new ReentrantLock();
    private final Set<Pair<Class<? extends Throwable>, String>> seen = new THashSet();

    @Nullable
    private static Frame findActiveFrame() {
        Frame[] frames;
        for (Frame frame : frames = JFrame.getFrames()) {
            if (!frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void uncaughtException(Thread t, Throwable e) {
        message = e.getMessage();
        if (e instanceof IllegalStateException && message != null && message.contains("Buffers have not been created")) {
            Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
            return;
        }
        exData = Pair.of(e.getClass(), (Object)message);
        if (this.seen.contains(exData)) {
            return;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            frame = UncaughtExceptionDisplayer.findActiveFrame();
            if (frame != null) {
                try {
                    if (UncaughtExceptionDisplayer.ERR_LOCK.tryLock(1L, TimeUnit.MILLISECONDS)) {
                        try {
                            textArea = new JTextArea(Throwables.toString((Throwable)e));
                            scrollPane = new JScrollPane(textArea);
                            textArea.setLineWrap(true);
                            textArea.setWrapStyleWord(true);
                            scrollPane.setPreferredSize(new Dimension(500, 500));
                            reply = JOptionPane.showConfirmDialog(frame, scrollPane, "Exception, ignore?", 0, 0);
                            if (reply != 0) ** GOTO lbl35
                            this.seen.add((Pair<Class<? extends Throwable>, String>)exData);
                        }
                        finally {
                            UncaughtExceptionDisplayer.ERR_LOCK.unlock();
                        }
                    }
                    Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            } else {
                Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
            }
        } else {
            Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
        }
lbl35:
        // 5 sources

        if (Throwables.isNonRecoverable((Throwable)e)) {
            System.exit(SysExits.EX_SOFTWARE.exitCode());
        }
    }

    public String toString() {
        return "UncaughtExceptionDisplayer{seen=" + this.seen + '}';
    }
}

