/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.spf4j.base.avro.LogRecord;
import org.spf4j.base.avro.StackSampleElement;
import org.spf4j.ssdump2.Converter;
import org.spf4j.stackmonitor.SampleNode;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED", "SE_BAD_FIELD"})
public class TextEntryPanel
extends JPanel {
    private transient BiConsumer<String, SampleNode> nodeConsumer;
    private transient Consumer<Exception> errorConsumer;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public TextEntryPanel(BiConsumer<String, SampleNode> nodeConsumer, Consumer<Exception> errorConsumer) {
        this.initComponents();
        this.nodeConsumer = nodeConsumer;
        this.errorConsumer = errorConsumer;
        TextTransferHandler th = new TextTransferHandler();
        this.jTextPane1.setTransferHandler(th);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        JButton display = new JButton();
        this.jTextPane1.setText("Enter stack sample json represetation or url to retrieve Log Records containing stack samples ( https://demo.spf4j.org/logs/cluster?filter=log.stackSamples.length!=0 )");
        this.jTextPane1.setName("textBox");
        this.jTextPane1.setOpaque(false);
        this.jTextPane1.setRequestFocusEnabled(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        display.setText("Display");
        display.setName("display");
        display.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEntryPanel.this.displayActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 409, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(152, 152, 152).addComponent(display).addContainerGap(186, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 256, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(display).addContainerGap()));
    }

    public static Object readAvroBin(InputStream input, Schema writerSchema) throws IOException {
        SpecificDatumReader reader = new SpecificDatumReader(writerSchema);
        DecoderFactory decoderFactory = DecoderFactory.get();
        BinaryDecoder decoder = decoderFactory.binaryDecoder(input, null);
        return reader.read(null, (Decoder)decoder);
    }

    @SuppressFBWarnings(value={"UP_UNUSED_PARAMETER", "URLCONNECTION_SSRF_FD"})
    private void displayActionPerformed(ActionEvent evt) {
        block20: {
            try {
                String text = this.jTextPane1.getText().trim();
                if (text.startsWith("http")) {
                    URL url = new URL(text);
                    URLConnection conn = url.openConnection();
                    conn.setRequestProperty("Accept", "application/avro");
                    conn.connect();
                    String contentType = conn.getContentType();
                    if (!"application/avro".equals(contentType)) {
                        throw new IOException("Unsupported content type " + contentType);
                    }
                    try (BufferedInputStream is = new BufferedInputStream(conn.getInputStream());){
                        List recs = (List)TextEntryPanel.readAvroBin(is, Schema.createArray((Schema)LogRecord.SCHEMA$));
                        for (LogRecord rec : recs) {
                            List stackSamples = rec.getStackSamples();
                            if (stackSamples.isEmpty()) continue;
                            this.nodeConsumer.accept(rec.getMsg() + "; with trId=" + rec.getTrId(), Converter.convert(stackSamples.iterator()));
                        }
                        break block20;
                    }
                }
                if (text.startsWith("[")) {
                    List samples;
                    Schema schema = Schema.createArray((Schema)StackSampleElement.getClassSchema());
                    SpecificDatumReader reader = new SpecificDatumReader(schema);
                    try {
                        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, text);
                        samples = (List)reader.read(null, (Decoder)decoder);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                    this.nodeConsumer.accept("SampleNode Array", Converter.convert(samples.iterator()));
                    break block20;
                }
                this.nodeConsumer.accept("SampleNode Tree", (SampleNode)SampleNode.parse((Reader)new StringReader(text)).getSecond());
            }
            catch (IOException | RuntimeException ex) {
                this.errorConsumer.accept(ex);
            }
        }
    }

    private static final class TextTransferHandler
    extends TransferHandler {
        Position p0 = null;
        Position p1 = null;

        private TextTransferHandler() {
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            String data;
            if (!this.canImport(support)) {
                return false;
            }
            try {
                data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                Logger.getLogger(TextEntryPanel.class.getName()).log(Level.WARNING, "Exception encountered", e);
                return false;
            }
            JTextPane tc = (JTextPane)support.getComponent();
            tc.replaceSelection(data);
            return true;
        }

        @Override
        @Nullable
        protected Transferable createTransferable(JComponent c) {
            JTextPane source = (JTextPane)c;
            int start = source.getSelectionStart();
            int end = source.getSelectionEnd();
            Document doc = source.getDocument();
            if (start == end) {
                return null;
            }
            try {
                this.p0 = doc.createPosition(start);
                this.p1 = doc.createPosition(end);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            String data = source.getSelectedText();
            return new StringSelection(data);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected void exportDone(JComponent c, Transferable data, int action) {
            if (action != 2) {
                return;
            }
            if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    JTextComponent tc = (JTextComponent)c;
                    tc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
    }
}

