/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SpinnerDateModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.spf4j.base.Pair;
import org.spf4j.base.SuppressForbiden;
import org.spf4j.perf.tsdb.TSTable;
import org.spf4j.perf.tsdb.TimeSeriesDatabase;

@Deprecated
@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL", "SE_BAD_FIELD"})
public class TSDBViewJInternalFrame
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private final TimeSeriesDatabase tsDb;
    private JScrollPane chartPannel;
    private JSpinner endDate;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JSplitPane mainSplitPannel;
    private JTree measurementTree;
    private JPanel rightPanel;
    private JSpinner startDate;

    @SuppressForbiden
    public TSDBViewJInternalFrame(File databaseFile) throws IOException {
        super(databaseFile.getAbsolutePath());
        this.setName(databaseFile.getName());
        this.initComponents();
        this.tsDb = new TimeSeriesDatabase(databaseFile, null);
        Collection<TSTable> columnsInfo = this.tsDb.getTSTables();
        HashMap<String, DefaultMutableTreeNode> gNodes = new HashMap<String, DefaultMutableTreeNode>();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(databaseFile);
        long startDateMillis = System.currentTimeMillis();
        for (TSTable info : columnsInfo) {
            Pair pair;
            String groupName = info.getTableName();
            long tableStart = this.tsDb.readStartDate(groupName);
            if (tableStart < startDateMillis) {
                startDateMillis = tableStart;
            }
            if ((pair = Pair.from((String)groupName)) == null) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(groupName);
                for (String colName : info.getColumnNames()) {
                    child.add(new DefaultMutableTreeNode(colName));
                }
                root.add(child);
                continue;
            }
            groupName = (String)pair.getFirst();
            DefaultMutableTreeNode gNode = (DefaultMutableTreeNode)gNodes.get(groupName);
            if (gNode == null) {
                gNode = new DefaultMutableTreeNode(groupName);
                gNodes.put(groupName, gNode);
                root.add(gNode);
            }
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(pair.getSecond());
            for (String colName : info.getColumnNames()) {
                child.add(new DefaultMutableTreeNode(colName));
            }
            gNode.add(child);
        }
        this.measurementTree.setModel(new DefaultTreeModel(root));
        this.measurementTree.setVisible(true);
        this.startDate.setValue(new Date(startDateMillis));
    }

    private void initComponents() {
        this.rightPanel = new JPanel();
        this.mainSplitPannel = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.measurementTree = new JTree();
        this.chartPannel = new JScrollPane();
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.startDate = new JSpinner();
        this.endDate = new JSpinner();
        GroupLayout rightPanelLayout = new GroupLayout((Container)this.rightPanel);
        this.rightPanel.setLayout((LayoutManager)rightPanelLayout);
        rightPanelLayout.setHorizontalGroup((GroupLayout.Group)rightPanelLayout.createParallelGroup(1).add(0, 448, Short.MAX_VALUE));
        rightPanelLayout.setVerticalGroup((GroupLayout.Group)rightPanelLayout.createParallelGroup(1).add(0, 306, Short.MAX_VALUE));
        this.setClosable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.mainSplitPannel.setDividerSize(5);
        this.mainSplitPannel.setPreferredSize(new Dimension(600, 500));
        this.measurementTree.setAutoscrolls(true);
        this.jScrollPane1.setViewportView(this.measurementTree);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 213, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 684, Short.MAX_VALUE));
        this.mainSplitPannel.setLeftComponent(this.jPanel2);
        this.mainSplitPannel.setRightComponent(this.chartPannel);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton1.setText("Plot");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TSDBViewJInternalFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton2.setText("Export");
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TSDBViewJInternalFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.startDate.setModel(new SpinnerDateModel());
        this.startDate.setEditor(new JSpinner.DateEditor(this.startDate, "yyyy-MM-dd HH:mm:ss"));
        this.startDate.setMinimumSize(new Dimension(200, 28));
        this.startDate.setName("");
        this.jToolBar1.add(this.startDate);
        this.endDate.setModel(new SpinnerDateModel());
        this.endDate.setEditor(new JSpinner.DateEditor(this.endDate, "yyyy-MM-dd HH:mm:ss"));
        this.jToolBar1.add(this.endDate);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -1, 465, Short.MAX_VALUE).add(236, 236, 236)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.mainSplitPannel, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, -1, -2).addPreferredGap(0).add((Component)this.mainSplitPannel, -1, 688, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    @SuppressWarnings(value={"UP_UNUSED_PARAMETER"})
    private void jButton1ActionPerformed(ActionEvent evt) {
        TreePath[] selectionPaths = this.measurementTree.getSelectionPaths();
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        this.chartPannel.setViewportView(content);
        try {
            List<String> selectedTables = TSDBViewJInternalFrame.getSelectedTables(selectionPaths);
            for (String tableName : selectedTables) {
                this.addChartToPanel(tableName, content);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.chartPannel.repaint();
    }

    @SuppressWarnings(value={"UP_UNUSED_PARAMETER"})
    private void jButton2ActionPerformed(ActionEvent evt) {
        TreePath[] selectionPaths = this.measurementTree.getSelectionPaths();
        List<String> selectedTables = TSDBViewJInternalFrame.getSelectedTables(selectionPaths);
        if (!selectedTables.isEmpty()) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogType(1);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                try {
                    this.tsDb.writeCsvTables(selectedTables, file);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    @SuppressWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    private static List<String> getSelectedTables(@Nullable TreePath[] selectionPaths) {
        if (selectionPaths == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (TreePath path : selectionPaths) {
            Object[] pathArr = path.getPath();
            if (pathArr.length < 2) continue;
            DefaultMutableTreeNode colNode = (DefaultMutableTreeNode)pathArr[1];
            int depth = colNode.getDepth();
            if (depth == 1) {
                result.add((String)colNode.getUserObject());
                continue;
            }
            Enumeration<TreeNode> childEnum = colNode.children();
            while (childEnum.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)childEnum.nextElement();
                String tableName = Pair.of((Object)((String)colNode.getUserObject()), (Object)((String)child.getUserObject())).toString();
                result.add(tableName);
            }
        }
        return result;
    }

    private void addChartToPanel(String tableName, JPanel content) throws IOException {
        ChartPanel pannel;
        JFreeChart chart;
        TSTable info = this.tsDb.getTSTable(tableName);
        long startTime = ((Date)this.startDate.getValue()).getTime();
        long endTime = ((Date)this.endDate.getValue()).getTime();
        if (TimeSeriesDatabase.canGenerateHeatChart(info)) {
            chart = this.tsDb.createHeatJFreeChart(info.getTableName(), startTime, endTime);
            pannel = new ChartPanel(chart);
            pannel.setPreferredSize(new Dimension(600, 800));
            pannel.setDomainZoomable(false);
            pannel.setMouseZoomable(false);
            pannel.setRangeZoomable(false);
            pannel.setZoomAroundAnchor(false);
            pannel.setZoomInFactor(1.0);
            pannel.setZoomOutFactor(1.0);
            content.add((Component)pannel);
        }
        if (TimeSeriesDatabase.canGenerateMinMaxAvgCount(info)) {
            chart = this.tsDb.createMinMaxAvgJFreeChart(info.getTableName(), startTime, endTime);
            pannel = new ChartPanel(chart);
            pannel.setPreferredSize(new Dimension(600, 600));
            content.add((Component)pannel);
        }
        if (TimeSeriesDatabase.canGenerateCount(info)) {
            chart = this.tsDb.createCountJFreeChart(info.getTableName(), startTime, endTime);
            pannel = new ChartPanel(chart);
            pannel.setPreferredSize(new Dimension(600, 600));
            content.add((Component)pannel);
        } else {
            List<JFreeChart> createJFreeCharts = this.tsDb.createJFreeCharts(info.getTableName(), startTime, endTime);
            for (JFreeChart chart2 : createJFreeCharts) {
                ChartPanel pannel2 = new ChartPanel(chart2);
                pannel2.setPreferredSize(new Dimension(600, 600));
                content.add((Component)pannel2);
            }
        }
    }
}

