/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import com.google.common.primitives.Ints;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.set.hash.THashSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SpinnerDateModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;
import org.jdesktop.layout.GroupLayout;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.spf4j.avro.csv.CsvEncoder;
import org.spf4j.base.Pair;
import org.spf4j.base.SuppressForbiden;
import org.spf4j.base.avro.AvroCloseableIterable;
import org.spf4j.io.Csv;
import org.spf4j.io.csv.CsvWriter;
import org.spf4j.perf.MeasurementStoreQuery;
import org.spf4j.perf.TimeSeriesRecord;
import org.spf4j.perf.impl.ms.tsdb.AvroMeasurementStoreReader;
import org.spf4j.tsdb2.Charts2;
import org.spf4j.tsdb2.avro.Observation;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL", "SE_BAD_FIELD"})
public class MStoreViewJInternalFrame
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private final AvroMeasurementStoreReader reader;
    private JTextField aggregationMillis;
    private JScrollPane chartPannel;
    private JSpinner endDate;
    private JButton exportButton;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JSplitPane mainSplitPannel;
    private JTree measurementTree;
    private JButton plotButton;
    private JPanel rightPanel;
    private JSpinner startDate;

    @SuppressForbiden
    public MStoreViewJInternalFrame(File tsDb) throws IOException {
        super(tsDb.getPath());
        String fileName = tsDb.getName();
        this.setName(fileName);
        this.initComponents();
        if (!fileName.endsWith(".tabledef.avro")) {
            throw new IllegalArgumentException("Not a tabledef.avrro file " + tsDb);
        }
        this.reader = new AvroMeasurementStoreReader(tsDb.toPath());
        Collection measurements = this.reader.getMeasurements(x -> true);
        long startDateMillis = System.currentTimeMillis();
        try (AvroCloseableIterable scan = this.reader.getObservations();){
            for (Observation obs : scan) {
                long ts = obs.getRelTimeStamp();
                if (ts >= startDateMillis) continue;
                startDateMillis = ts;
            }
        }
        HashMap<String, DefaultMutableTreeNode> gNodes = new HashMap<String, DefaultMutableTreeNode>();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(fileName);
        for (Schema info : measurements) {
            String groupName = info.getProp("rawName");
            Pair pair = Pair.from((String)groupName);
            if (pair == null) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(info);
                root.add(child);
                continue;
            }
            groupName = (String)pair.getFirst();
            DefaultMutableTreeNode gNode = (DefaultMutableTreeNode)gNodes.get(groupName);
            if (gNode == null) {
                gNode = new DefaultMutableTreeNode(groupName);
                gNodes.put(groupName, gNode);
                root.add(gNode);
            }
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(info);
            gNode.add(child);
        }
        this.measurementTree.setModel(new DefaultTreeModel(root));
        this.measurementTree.setCellRenderer(new TreeCellRenderer());
        this.measurementTree.setVisible(true);
        this.startDate.setValue(new Date(startDateMillis));
    }

    private void initComponents() {
        this.rightPanel = new JPanel();
        this.mainSplitPannel = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.measurementTree = new JTree();
        this.chartPannel = new JScrollPane();
        this.jToolBar1 = new JToolBar();
        this.plotButton = new JButton();
        this.exportButton = new JButton();
        this.aggregationMillis = new JTextField();
        this.startDate = new JSpinner();
        this.endDate = new JSpinner();
        GroupLayout rightPanelLayout = new GroupLayout((Container)this.rightPanel);
        this.rightPanel.setLayout((LayoutManager)rightPanelLayout);
        rightPanelLayout.setHorizontalGroup((GroupLayout.Group)rightPanelLayout.createParallelGroup(1).add(0, 448, Short.MAX_VALUE));
        rightPanelLayout.setVerticalGroup((GroupLayout.Group)rightPanelLayout.createParallelGroup(1).add(0, 306, Short.MAX_VALUE));
        this.setClosable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.mainSplitPannel.setDividerSize(5);
        this.mainSplitPannel.setPreferredSize(new Dimension(600, 500));
        this.measurementTree.setAutoscrolls(true);
        this.jScrollPane1.setViewportView(this.measurementTree);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 213, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 684, Short.MAX_VALUE));
        this.mainSplitPannel.setLeftComponent(this.jPanel2);
        this.mainSplitPannel.setRightComponent(this.chartPannel);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.plotButton.setText("Plot");
        this.plotButton.setFocusable(false);
        this.plotButton.setHorizontalTextPosition(0);
        this.plotButton.setVerticalTextPosition(3);
        this.plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MStoreViewJInternalFrame.this.plotButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.plotButton);
        this.exportButton.setText("Export");
        this.exportButton.setFocusable(false);
        this.exportButton.setHorizontalTextPosition(0);
        this.exportButton.setVerticalTextPosition(3);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MStoreViewJInternalFrame.this.exportButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.exportButton);
        this.aggregationMillis.setText("0");
        this.aggregationMillis.setMinimumSize(new Dimension(80, 24));
        this.aggregationMillis.setPreferredSize(new Dimension(80, 24));
        this.aggregationMillis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MStoreViewJInternalFrame.this.aggregationMillisActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.aggregationMillis);
        this.startDate.setModel(new SpinnerDateModel());
        this.startDate.setEditor(new JSpinner.DateEditor(this.startDate, "yyyy-MM-dd HH:mm:ss"));
        this.startDate.setMinimumSize(new Dimension(200, 28));
        this.startDate.setName("");
        this.jToolBar1.add(this.startDate);
        this.endDate.setModel(new SpinnerDateModel());
        this.endDate.setEditor(new JSpinner.DateEditor(this.endDate, "yyyy-MM-dd HH:mm:ss"));
        this.jToolBar1.add(this.endDate);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 627, -2).add(0, 0, Short.MAX_VALUE)).add((Component)this.mainSplitPannel, -1, 695, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, -1, -2).addPreferredGap(0).add((Component)this.mainSplitPannel, -1, 688, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    @SuppressFBWarnings(value={"UP_UNUSED_PARAMETER"})
    private void plotButtonActionPerformed(ActionEvent evt) {
        TreePath[] selectionPaths = this.measurementTree.getSelectionPaths();
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        this.chartPannel.setViewportView(content);
        try {
            Set<Schema> selectedTables = MStoreViewJInternalFrame.getSelectedTables(selectionPaths);
            for (Schema tableName : selectedTables) {
                this.addChartToPanel(tableName, content);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.chartPannel.repaint();
    }

    @SuppressFBWarnings(value={"UP_UNUSED_PARAMETER"})
    private void exportButtonActionPerformed(ActionEvent evt) {
        TreePath[] selectionPaths = this.measurementTree.getSelectionPaths();
        Set<Schema> selectedTables = MStoreViewJInternalFrame.getSelectedTables(selectionPaths);
        if (!selectedTables.isEmpty()) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogType(1);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                for (Schema metric : selectedTables) {
                    try {
                        AvroCloseableIterable obs = this.reader.getMeasurementData(metric, Instant.EPOCH, Instant.now());
                        Throwable throwable = null;
                        try {
                            CsvWriter writer = Csv.CSV.writer((Writer)Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
                            CsvEncoder encoder = new CsvEncoder(writer, Schema.createArray((Schema)metric));
                            encoder.writeHeader();
                            GenericDatumWriter dw = new GenericDatumWriter(metric);
                            for (TimeSeriesRecord o : obs) {
                                dw.write((Object)o, (Encoder)encoder);
                            }
                            encoder.flush();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (obs == null) continue;
                            if (throwable != null) {
                                try {
                                    obs.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            obs.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            }
        }
    }

    @SuppressFBWarnings(value={"UP_UNUSED_PARAMETER"})
    private void aggregationMillisActionPerformed(ActionEvent evt) {
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    private static Set<Schema> getSelectedTables(@Nullable TreePath[] selectionPaths) {
        if (selectionPaths == null) {
            return Collections.EMPTY_SET;
        }
        THashSet result = new THashSet();
        for (TreePath path : selectionPaths) {
            Object[] pathArr = path.getPath();
            if (pathArr.length < 2) continue;
            DefaultMutableTreeNode colNode = (DefaultMutableTreeNode)pathArr[pathArr.length - 1];
            int depth = colNode.getDepth();
            if (depth == 0) {
                result.add((Schema)colNode.getUserObject());
                continue;
            }
            Enumeration<TreeNode> childEnum = colNode.children();
            while (childEnum.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)childEnum.nextElement();
                result.add((Schema)child.getUserObject());
            }
        }
        return result;
    }

    private void addChartToPanel(Schema table, JPanel content) throws IOException {
        ChartPanel pannel;
        JFreeChart chart;
        long startTime = ((Date)this.startDate.getValue()).getTime();
        long endTime = ((Date)this.endDate.getValue()).getTime();
        Integer aggMillis = Ints.tryParse((String)this.aggregationMillis.getText());
        if (aggMillis == null) {
            aggMillis = 0;
        }
        if (Charts2.canGenerateHeatChart(table)) {
            chart = Charts2.createHeatJFreeChart((MeasurementStoreQuery)this.reader, table, startTime, endTime, aggMillis);
            pannel = new ChartPanel(chart);
            pannel.setPreferredSize(new Dimension(600, 800));
            pannel.setDomainZoomable(false);
            pannel.setMouseZoomable(false);
            pannel.setRangeZoomable(false);
            pannel.setZoomAroundAnchor(false);
            pannel.setZoomInFactor(1.0);
            pannel.setZoomOutFactor(1.0);
            content.add((Component)pannel);
        }
        if (Charts2.canGenerateMinMaxAvgCount(table)) {
            chart = Charts2.createMinMaxAvgJFreeChart((MeasurementStoreQuery)this.reader, table, startTime, endTime, aggMillis);
            pannel = new ChartPanel(chart);
            pannel.setPreferredSize(new Dimension(600, 600));
            content.add((Component)pannel);
        }
        if (Charts2.canGenerateCount(table)) {
            chart = Charts2.createCountJFreeChart((MeasurementStoreQuery)this.reader, table, startTime, endTime, aggMillis);
            pannel = new ChartPanel(chart);
            pannel.setPreferredSize(new Dimension(600, 600));
            content.add((Component)pannel);
        } else {
            List<JFreeChart> createJFreeCharts = Charts2.createJFreeCharts((MeasurementStoreQuery)this.reader, table, startTime, endTime, aggMillis);
            for (JFreeChart chart2 : createJFreeCharts) {
                ChartPanel pannel2 = new ChartPanel(chart2);
                pannel2.setPreferredSize(new Dimension(600, 600));
                content.add((Component)pannel2);
            }
        }
    }

    private static class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer() {
        }

        @Override
        @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object value = ((DefaultMutableTreeNode)node).getUserObject();
            if (value instanceof String) {
                this.setText((String)value);
            } else if (value instanceof Schema) {
                this.setText(((Schema)value).getName());
            } else {
                throw new IllegalStateException("Unsupported object type " + value.getClass());
            }
            return this;
        }
    }
}

