/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import com.google.common.primitives.Longs;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.list.array.TLongArrayList;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.jfree.chart.JFreeChart;
import org.spf4j.base.Arrays;
import org.spf4j.base.Pair;
import org.spf4j.base.avro.AvroCloseableIterable;
import org.spf4j.perf.MeasurementStoreQuery;
import org.spf4j.perf.TimeSeriesRecord;
import org.spf4j.perf.impl.chart.Charts;
import org.spf4j.tsdb2.TimeSeries;
import org.spf4j.tsdb2.avro.Observation;

public final class Charts2 {
    private Charts2() {
    }

    public static boolean canGenerateMinMaxAvgCount(Schema info) {
        int found = 0;
        for (Schema.Field colDef : info.getFields()) {
            switch (colDef.name()) {
                case "min": 
                case "max": 
                case "total": 
                case "count": {
                    ++found;
                    break;
                }
            }
        }
        return found >= 4;
    }

    public static boolean canGenerateCount(Schema info) {
        int found = 0;
        for (Schema.Field colDef : info.getFields()) {
            switch (colDef.name()) {
                case "count": {
                    ++found;
                    break;
                }
            }
        }
        return found >= 1;
    }

    @SuppressFBWarnings(value={"STT_STRING_PARSING_A_FIELD"})
    public static boolean canGenerateHeatChart(Schema info) {
        for (Schema.Field colDef : info.getFields()) {
            String colName = colDef.name();
            if (!colName.startsWith("Q") || !colName.contains("_")) continue;
            return true;
        }
        return false;
    }

    public static JFreeChart createHeatJFreeChart(MeasurementStoreQuery query, Schema table, long startTime, long endTime, int aggTimeMillis) throws IOException {
        TimeSeries data = Charts2.readToTs(query, table, startTime, endTime, aggTimeMillis);
        return Charts2.createHeatJFreeChart(data, table, aggTimeMillis);
    }

    public static TimeSeries readToTs(MeasurementStoreQuery query, Schema table, long startTime, long endTime, int aggTimeMillis) throws IOException {
        TLongArrayList ts = new TLongArrayList();
        ArrayList<long[]> values = new ArrayList<long[]>();
        try (AvroCloseableIterable data = aggTimeMillis <= 0 ? query.getObservations(table, Instant.ofEpochMilli(startTime), Instant.ofEpochMilli(endTime)) : query.getAggregatedObservations(table, Instant.ofEpochMilli(startTime), Instant.ofEpochMilli(endTime), aggTimeMillis, TimeUnit.MILLISECONDS);){
            for (Observation rec : data) {
                ts.add(rec.getRelTimeStamp());
                values.add(Longs.toArray((Collection)rec.getData()));
            }
        }
        return new TimeSeries(ts.toArray(), (long[][])values.toArray((T[])new long[values.size()][]));
    }

    public static String[] getDataColumnNames(Schema info) {
        List fields = info.getFields();
        int size = fields.size();
        String[] result = new String[size - 1];
        int i = 1;
        int j = 0;
        while (i < size) {
            result[j] = ((Schema.Field)fields.get(i)).name();
            ++i;
            ++j;
        }
        return result;
    }

    public static JFreeChart createHeatJFreeChart(TimeSeries data, Schema info, int aggTime) {
        int sampleTime = TimeSeriesRecord.getFrequencyMillis((Schema)info);
        Pair<long[], double[][]> mData = Charts.fillGaps(data.getTimeStamps(), data.getValues(), Math.max(sampleTime, aggTime), info.getFields().size() - 1);
        return Charts.createHeatJFreeChart(Charts2.getDataColumnNames(info), (double[][])mData.getSecond(), data.getTimeStamps()[0], sampleTime, TimeSeriesRecord.getUnit((Schema)info.getField("total").schema()), "Measurements distribution for " + info.getName() + ", sampleTime " + sampleTime + "ms, generated by spf4j");
    }

    public static JFreeChart createMinMaxAvgJFreeChart(TimeSeries data, Schema info) {
        long[][] vals = data.getValues();
        double[] min = Arrays.getColumnAsDoubles((long[][])vals, (int)(info.getField("min").pos() - 1));
        double[] max = Arrays.getColumnAsDoubles((long[][])vals, (int)(info.getField("max").pos() - 1));
        int totalColumnIndex = info.getField("total").pos() - 1;
        double[] total = Arrays.getColumnAsDoubles((long[][])vals, (int)totalColumnIndex);
        double[] count = Arrays.getColumnAsDoubles((long[][])vals, (int)(info.getField("count").pos() - 1));
        for (int i = 0; i < count.length; ++i) {
            if (count[i] != 0.0) continue;
            min[i] = 0.0;
            max[i] = 0.0;
        }
        int sampleTime = TimeSeriesRecord.getFrequencyMillis((Schema)info);
        long[] timestamps = data.getTimeStamps();
        return Charts.createTimeSeriesJFreeChart("Min,Max,Avg chart for " + info.getName() + ", sampleTime " + sampleTime + "ms, generated by spf4j", timestamps, new String[]{"min", "max", "avg"}, TimeSeriesRecord.getUnit((Schema)info.getField("total").schema()), (double[][])new double[][]{min, max, Arrays.divide((double[])total, (double[])count)});
    }

    public static JFreeChart createMinMaxAvgJFreeChart(MeasurementStoreQuery query, Schema table, long startTime, long endTime, int aggTimeMillis) throws IOException {
        TimeSeries data = Charts2.readToTs(query, table, startTime, endTime, aggTimeMillis);
        return Charts2.createMinMaxAvgJFreeChart(data, table);
    }

    public static JFreeChart createCountJFreeChart(TimeSeries data, Schema info) {
        long[][] vals = data.getValues();
        double[] count = Arrays.getColumnAsDoubles((long[][])vals, (int)(info.getField("count").pos() - 1));
        long[] timestamps = data.getTimeStamps();
        int sampleTime = TimeSeriesRecord.getFrequencyMillis((Schema)info);
        return Charts.createTimeSeriesJFreeChart("count chart for " + info.getName() + ", sampleTime " + sampleTime + " ms, generated by spf4j", timestamps, new String[]{"count"}, "count", (double[][])new double[][]{count});
    }

    public static JFreeChart createCountJFreeChart(MeasurementStoreQuery query, Schema info, long startTime, long endTime, int aggTimeMillis) throws IOException {
        TimeSeries data = Charts2.readToTs(query, info, startTime, endTime, aggTimeMillis);
        return Charts2.createCountJFreeChart(data, info);
    }

    public static List<JFreeChart> createJFreeCharts(TimeSeries data, Schema info) {
        long[][] vals = data.getValues();
        HashMap<String, Pair> measurementsByUom = new HashMap<String, Pair>();
        int i = 0;
        Iterator it = info.getFields().iterator();
        it.next();
        while (it.hasNext()) {
            Schema.Field col = (Schema.Field)it.next();
            String uom = TimeSeriesRecord.getUnit((Schema)col.schema());
            Pair meas = (Pair)measurementsByUom.get(uom);
            if (meas == null) {
                meas = Pair.of(new ArrayList(), new ArrayList());
                measurementsByUom.put(uom, meas);
            }
            ((List)meas.getFirst()).add(col.name());
            ((List)meas.getSecond()).add(Arrays.getColumnAsDoubles((long[][])vals, (int)i));
            ++i;
        }
        long[] timestamps = data.getTimeStamps();
        int sampleTime = TimeSeriesRecord.getFrequencyMillis((Schema)info);
        ArrayList<JFreeChart> result = new ArrayList<JFreeChart>(measurementsByUom.size());
        for (Map.Entry entry : measurementsByUom.entrySet()) {
            Pair p = (Pair)entry.getValue();
            List measurementNames = (List)p.getFirst();
            List measurements = (List)p.getSecond();
            result.add(Charts.createTimeSeriesJFreeChart("chart for " + info.getName() + ", sampleTime " + sampleTime + " ms, generated by spf4j", timestamps, measurementNames.toArray(new String[measurementNames.size()]), (String)entry.getKey(), (double[][])measurements.toArray((T[])new double[measurements.size()][])));
        }
        return result;
    }

    public static List<JFreeChart> createJFreeCharts(MeasurementStoreQuery query, Schema td, long startTime, long endTime, int aggTimeMillis) throws IOException {
        TimeSeries data = Charts2.readToTs(query, td, startTime, endTime, aggTimeMillis);
        return Charts2.createJFreeCharts(data, td);
    }
}

