/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.tsdb;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.imageio.ImageIO;
import org.jfree.chart.JFreeChart;
import org.spf4j.base.Arrays;
import org.spf4j.base.DateTimeFormats;
import org.spf4j.base.Pair;
import org.spf4j.io.Csv;
import org.spf4j.jmx.JmxExport;
import org.spf4j.perf.impl.chart.Charts;
import org.spf4j.perf.tsdb.DataFragment;
import org.spf4j.perf.tsdb.Header;
import org.spf4j.perf.tsdb.TSDataHandler;
import org.spf4j.perf.tsdb.TSTable;
import org.spf4j.perf.tsdb.TableOfContents;
import org.spf4j.tsdb2.TimeSeries;

@Deprecated
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class TimeSeriesDatabase
implements Closeable {
    public static final int VERSION = 1;
    private static final Interner<String> INTERNER = Interners.newStrongInterner();
    private final ConcurrentMap<String, TSTable> tables;
    private final RandomAccessFile file;
    private final Header header;
    private TableOfContents toc;
    private TSTable lastTableInfo;
    private final Map<String, DataFragment> writeDataFragments;
    private final String path;
    private final FileChannel ch;

    public TimeSeriesDatabase(File pathToDatabaseFile) throws IOException {
        this(pathToDatabaseFile, false, new byte[0]);
    }

    public TimeSeriesDatabase(File pathToDatabaseFile, byte ... metaData) throws IOException {
        this(pathToDatabaseFile, true, metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSeriesDatabase(File pathToDatabaseFile, boolean isWrite, byte ... metaData) throws IOException {
        this.file = new RandomAccessFile(pathToDatabaseFile, isWrite ? "rw" : "r");
        this.path = (String)INTERNER.intern((Object)pathToDatabaseFile.getCanonicalPath());
        this.tables = new ConcurrentHashMap<String, TSTable>();
        this.writeDataFragments = new HashMap<String, DataFragment>();
        String string = this.path;
        synchronized (string) {
            this.ch = this.file.getChannel();
            FileLock lock = isWrite ? this.ch.lock() : this.ch.lock(0L, Long.MAX_VALUE, true);
            try {
                if (this.file.length() == 0L) {
                    this.header = new Header(1, metaData);
                    this.header.writeTo(this.file);
                    this.toc = new TableOfContents(this.file.getFilePointer());
                    this.toc.writeTo(this.file);
                } else {
                    this.header = new Header(this.file);
                    this.toc = new TableOfContents(this.file);
                }
            }
            catch (IOException | RuntimeException e) {
                try {
                    lock.release();
                    throw e;
                }
                catch (IOException ex) {
                    ex.addSuppressed(e);
                    throw ex;
                }
            }
            lock.release();
            lock = this.ch.lock(0L, Long.MAX_VALUE, true);
            try {
                this.readTableInfos();
            }
            catch (IOException | RuntimeException e) {
                try {
                    lock.release();
                    throw e;
                }
                catch (IOException ex) {
                    ex.addSuppressed(e);
                    throw ex;
                }
            }
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reReadTableInfos() throws IOException {
        String string = this.path;
        synchronized (string) {
            FileLock lock = this.ch.lock(0L, Long.MAX_VALUE, true);
            try {
                this.toc = new TableOfContents(this.file, this.toc.getLocation());
                this.readTableInfos();
            }
            catch (IOException | RuntimeException e) {
                try {
                    lock.release();
                    throw e;
                }
                catch (IOException ex) {
                    ex.addSuppressed(e);
                    throw ex;
                }
            }
            lock.release();
        }
    }

    private void readTableInfos() throws IOException {
        long firstColumnInfo = this.toc.getFirstTableInfoPtr();
        if (firstColumnInfo > 0L) {
            this.file.seek(firstColumnInfo);
            TSTable colInfo = new TSTable(this.file);
            this.tables.put(colInfo.getTableName(), colInfo);
            this.lastTableInfo = colInfo;
            while (colInfo.getNextTSTable() > 0L) {
                this.file.seek(colInfo.getNextTSTable());
                colInfo = new TSTable(this.file);
                this.tables.put(colInfo.getTableName(), colInfo);
                this.lastTableInfo = colInfo;
            }
        }
    }

    private void readLastTableInfo() throws IOException {
        this.toc = new TableOfContents(this.file, this.toc.getLocation());
        if (this.toc.getLastTableInfoPtr() == 0L) {
            return;
        }
        this.lastTableInfo = new TSTable(this.file, this.toc.getLastTableInfoPtr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        String string = this.path;
        synchronized (string) {
            try (RandomAccessFile vfile = this.file;){
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTSTable(String tableName) {
        String string = this.path;
        synchronized (string) {
            return this.tables.containsKey(tableName);
        }
    }

    public void addTSTable(String tableName, byte[] tableMetaData, int sampleTime, String[] columnNames, String[] columnMetaData) throws IOException {
        byte[][] metadata = new byte[columnMetaData.length][];
        for (int i = 0; i < columnMetaData.length; ++i) {
            metadata[i] = columnMetaData[i].getBytes(StandardCharsets.UTF_8);
        }
        this.addTSTable(tableName, tableMetaData, sampleTime, columnNames, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTSTable(String tableName, byte[] tableMetaData, int sampleTime, String[] columnNames, byte[][] columnMetaData) throws IOException {
        String string = this.path;
        synchronized (string) {
            TSTable colInfo;
            if (this.hasTSTable(tableName)) {
                throw new IllegalArgumentException("group already exists " + tableName);
            }
            this.flush();
            FileLock lock = this.ch.lock();
            try {
                this.readLastTableInfo();
                this.file.seek(this.file.length());
                colInfo = new TSTable(tableName, tableMetaData, columnNames, columnMetaData, sampleTime, this.file.getFilePointer());
                colInfo.writeTo(this.file);
                if (this.lastTableInfo != null) {
                    this.lastTableInfo.setNextColumnInfo(colInfo.getLocation(), this.file);
                } else {
                    this.toc.setFirstTableInfo(colInfo.getLocation(), this.file);
                }
                this.toc.setLastTableInfo(colInfo.getLocation(), this.file);
            }
            catch (IOException | RuntimeException e) {
                try {
                    lock.release();
                    throw e;
                }
                catch (IOException ex) {
                    ex.addSuppressed(e);
                    throw ex;
                }
            }
            lock.release();
            this.lastTableInfo = colInfo;
            this.tables.put(tableName, colInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long time, String tableName, long[] values) {
        if (!this.hasTSTable(tableName)) {
            throw new IllegalArgumentException("Unknown table name" + tableName);
        }
        Map<String, DataFragment> map = this.writeDataFragments;
        synchronized (map) {
            DataFragment writeDataFragment = this.writeDataFragments.get(tableName);
            if (writeDataFragment == null) {
                writeDataFragment = new DataFragment(time);
                this.writeDataFragments.put(tableName, writeDataFragment);
            }
            writeDataFragment.addData(time, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        String string = this.path;
        synchronized (string) {
            ArrayList<Map.Entry<String, DataFragment>> lwriteDataFragments;
            Map<String, DataFragment> map = this.writeDataFragments;
            synchronized (map) {
                if (this.writeDataFragments.isEmpty()) {
                    return;
                }
                lwriteDataFragments = new ArrayList<Map.Entry<String, DataFragment>>(this.writeDataFragments.entrySet());
                this.writeDataFragments.clear();
            }
            FileLock lock = this.ch.lock();
            try {
                for (Map.Entry entry : lwriteDataFragments) {
                    DataFragment writeDataFragment = (DataFragment)entry.getValue();
                    String groupName = (String)entry.getKey();
                    this.file.seek(this.file.length());
                    writeDataFragment.setLocation(this.file.getFilePointer());
                    writeDataFragment.writeTo(this.file);
                    TSTable colInfo = (TSTable)this.tables.get(groupName);
                    colInfo = new TSTable(this.file, colInfo.getLocation());
                    this.tables.put(groupName, colInfo);
                    long lastDataFragment = colInfo.getLastDataFragment();
                    long location = writeDataFragment.getLocation();
                    if (lastDataFragment != 0L) {
                        DataFragment.setNextDataFragment(lastDataFragment, location, this.file);
                    } else {
                        colInfo.setFirstDataFragment(location, this.file);
                    }
                    colInfo.setLastDataFragment(location, this.file);
                }
                this.sync();
            }
            catch (IOException | RuntimeException e) {
                try {
                    lock.release();
                    throw e;
                }
                catch (IOException iOException) {
                    iOException.addSuppressed(e);
                    throw iOException;
                }
            }
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumnNames(String tableName) {
        String string = this.path;
        synchronized (string) {
            return ((TSTable)this.tables.get(tableName)).getColumnNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSTable getTSTable(String tableName) {
        String string = this.path;
        synchronized (string) {
            return new TSTable((TSTable)this.tables.get(tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TSTable> getTSTables() {
        String string = this.path;
        synchronized (string) {
            ArrayList<TSTable> result = new ArrayList<TSTable>(this.tables.size());
            for (TSTable table : this.tables.values()) {
                result.add(new TSTable(table));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TSTable> getTsTables() {
        String string = this.path;
        synchronized (string) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)this.tables.size());
            for (Map.Entry entry : this.tables.entrySet()) {
                result.put(entry.getKey(), new TSTable((TSTable)entry.getValue()));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSeries readAll(String tableName) throws IOException {
        String string = this.path;
        synchronized (string) {
            return this.read(tableName, 0L, Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readStartDate(String tableName) throws IOException {
        String string = this.path;
        synchronized (string) {
            TSTable info = (TSTable)this.tables.get(tableName);
            long nextFragmentLocation = info.getFirstDataFragment();
            if (nextFragmentLocation > 0L) {
                this.file.seek(nextFragmentLocation);
                DataFragment frag = new DataFragment(this.file);
                return frag.getStartTimeMillis();
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSeries read(String tableName, long startTime, long endTime) throws IOException {
        String string = this.path;
        synchronized (string) {
            TSTable info = (TSTable)this.tables.get(tableName);
            long firstDataFragment = info.getFirstDataFragment();
            return this.read(startTime, endTime, firstDataFragment, info.getLastDataFragment(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeSeries read(long startTime, long endTime, long startAtFragment, long endAtFragment, boolean skipFirst) throws IOException {
        String string = this.path;
        synchronized (string) {
            TLongArrayList timeStamps = new TLongArrayList();
            ArrayList<long[]> data = new ArrayList<long[]>();
            if (startAtFragment > 0L) {
                FileLock lock = this.ch.lock(0L, Long.MAX_VALUE, true);
                try {
                    DataFragment frag;
                    long nextFragmentLocation = startAtFragment;
                    boolean last = false;
                    boolean psFirst = skipFirst;
                    do {
                        long ts;
                        int i;
                        if (nextFragmentLocation == endAtFragment) {
                            last = true;
                        }
                        this.file.seek(nextFragmentLocation);
                        frag = new DataFragment(this.file);
                        if (psFirst) {
                            psFirst = false;
                            continue;
                        }
                        long fragStartTime = frag.getStartTimeMillis();
                        if (fragStartTime < startTime) continue;
                        TIntArrayList fragTimestamps = frag.getTimestamps();
                        int nr = 0;
                        for (i = 0; i < fragTimestamps.size() && (ts = fragStartTime + (long)fragTimestamps.get(i)) <= endTime; ++i) {
                            timeStamps.add(ts);
                            ++nr;
                        }
                        i = 0;
                        for (long[] d : frag.getData()) {
                            if (i >= nr) break;
                            data.add(d);
                            ++nr;
                        }
                        if (fragTimestamps.size() > nr) break;
                    } while ((nextFragmentLocation = frag.getNextDataFragment()) > 0L && !last);
                }
                catch (IOException | RuntimeException e) {
                    try {
                        lock.release();
                        throw e;
                    }
                    catch (IOException ex) {
                        ex.addSuppressed(e);
                        throw ex;
                    }
                }
                lock.release();
            }
            return new TimeSeries(timeStamps.toArray(), (long[][])data.toArray((T[])new long[data.size()][]));
        }
    }

    private void sync() throws IOException {
        this.file.getFD().sync();
    }

    public String getDBFilePath() {
        return this.path;
    }

    public JFreeChart createHeatJFreeChart(String tableName) throws IOException {
        return this.createHeatJFreeChart(tableName, 0L, Long.MAX_VALUE);
    }

    public JFreeChart createHeatJFreeChart(String tableName, long startTime, long endTime) throws IOException {
        TSTable info = this.getTSTable(tableName);
        TimeSeries data = this.read(tableName, startTime, endTime);
        return TimeSeriesDatabase.createHeatJFreeChart(data, info);
    }

    public JFreeChart createMinMaxAvgJFreeChart(String tableName) throws IOException {
        return this.createMinMaxAvgJFreeChart(tableName, 0L, Long.MAX_VALUE);
    }

    public JFreeChart createMinMaxAvgJFreeChart(String tableName, long startTime, long endTime) throws IOException {
        TSTable info = this.getTSTable(tableName);
        TimeSeries data = this.read(tableName, startTime, endTime);
        return TimeSeriesDatabase.createMinMaxAvgJFreeChart(data, info);
    }

    public JFreeChart createCountJFreeChart(String tableName) throws IOException {
        return this.createCountJFreeChart(tableName, 0L, Long.MAX_VALUE);
    }

    public JFreeChart createCountJFreeChart(String tableName, long startTime, long endTime) throws IOException {
        TSTable info = this.getTSTable(tableName);
        TimeSeries data = this.read(tableName, startTime, endTime);
        return TimeSeriesDatabase.createCountJFreeChart(data, info);
    }

    public List<JFreeChart> createJFreeCharts(String tableName) throws IOException {
        return this.createJFreeCharts(tableName, 0L, Long.MAX_VALUE);
    }

    public List<JFreeChart> createJFreeCharts(String tableName, long startTime, long endTime) throws IOException {
        TSTable info = this.getTSTable(tableName);
        TimeSeries data = this.read(tableName, startTime, endTime);
        return TimeSeriesDatabase.createJFreeCharts(data, info);
    }

    public static JFreeChart createHeatJFreeChart(TimeSeries data, TSTable info) {
        Pair<long[], double[][]> mData = Charts.fillGaps(data.getTimeStamps(), data.getValues(), info.getSampleTime(), info.getColumnNames().length);
        int totalColumnIndex = info.getColumnIndex("total");
        return Charts.createHeatJFreeChart(info.getColumnNames(), (double[][])mData.getSecond(), data.getTimeStamps()[0], info.getSampleTime(), new String(info.getColumnMetaData()[totalColumnIndex], StandardCharsets.UTF_8), "Measurements distribution for " + info.getTableName() + ", sampleTime " + info.getSampleTime() + "ms, generated by spf4j");
    }

    public static JFreeChart createMinMaxAvgJFreeChart(TimeSeries data, TSTable info) {
        long[][] vals = data.getValues();
        double[] min = Arrays.getColumnAsDoubles((long[][])vals, (int)info.getColumnIndex("min"));
        double[] max = Arrays.getColumnAsDoubles((long[][])vals, (int)info.getColumnIndex("max"));
        int totalColumnIndex = info.getColumnIndex("total");
        double[] total = Arrays.getColumnAsDoubles((long[][])vals, (int)totalColumnIndex);
        double[] count = Arrays.getColumnAsDoubles((long[][])vals, (int)info.getColumnIndex("count"));
        for (int i = 0; i < count.length; ++i) {
            if (count[i] != 0.0) continue;
            min[i] = 0.0;
            max[i] = 0.0;
        }
        long[] timestamps = data.getTimeStamps();
        return Charts.createTimeSeriesJFreeChart("Min,Max,Avg chart for " + info.getTableName() + ", sampleTime " + info.getSampleTime() + "ms, generated by spf4j", timestamps, new String[]{"min", "max", "avg"}, new String(info.getColumnMetaData()[totalColumnIndex], StandardCharsets.UTF_8), (double[][])new double[][]{min, max, Arrays.divide((double[])total, (double[])count)});
    }

    public static JFreeChart createCountJFreeChart(TimeSeries data, TSTable info) {
        long[][] vals = data.getValues();
        double[] count = Arrays.getColumnAsDoubles((long[][])vals, (int)info.getColumnIndex("count"));
        long[] timestamps = data.getTimeStamps();
        return Charts.createTimeSeriesJFreeChart("count chart for " + info.getTableName() + ", sampleTime " + info.getSampleTime() + " ms, generated by spf4j", timestamps, new String[]{"count"}, "count", (double[][])new double[][]{count});
    }

    public static List<JFreeChart> createJFreeCharts(TimeSeries data, TSTable info) {
        long[][] vals = data.getValues();
        HashMap<String, Pair> measurementsByUom = new HashMap<String, Pair>(4);
        String[] columnMetaData = info.getColumnMetaDataAsStrings();
        int columnNumber = info.getColumnNumber();
        for (int i = 0; i < columnNumber; ++i) {
            String uom = columnMetaData[i];
            Pair meas = (Pair)measurementsByUom.get(uom);
            if (meas == null) {
                meas = Pair.of(new ArrayList(columnNumber), new ArrayList(columnNumber));
                measurementsByUom.put(uom, meas);
            }
            ((List)meas.getFirst()).add(info.getColumnName(i));
            ((List)meas.getSecond()).add(Arrays.getColumnAsDoubles((long[][])vals, (int)i));
        }
        long[] timestamps = data.getTimeStamps();
        ArrayList<JFreeChart> result = new ArrayList<JFreeChart>(measurementsByUom.size());
        for (Map.Entry entry : measurementsByUom.entrySet()) {
            Pair p = (Pair)entry.getValue();
            List measurementNames = (List)p.getFirst();
            List measurements = (List)p.getSecond();
            result.add(Charts.createTimeSeriesJFreeChart("chart for " + info.getTableName() + ", sampleTime " + info.getSampleTime() + " ms, generated by spf4j", timestamps, measurementNames.toArray(new String[measurementNames.size()]), (String)entry.getKey(), (double[][])measurements.toArray((T[])new double[measurements.size()][])));
        }
        return result;
    }

    public byte[] getMetaData() {
        return (byte[])this.header.getMetaData().clone();
    }

    public void writeCsvTable(String tableName, File output) throws IOException {
        TSTable table = this.getTSTable(tableName);
        TimeSeries data = this.readAll(tableName);
        DateTimeFormatter formatter = DateTimeFormats.TS_FORMAT;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(output.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            Csv.writeCsvElement((CharSequence)"timestamp", (Appendable)writer);
            for (String colName : table.getColumnNames()) {
                writer.append(',');
                Csv.writeCsvElement((CharSequence)colName, (Appendable)writer);
            }
            ((Writer)writer).write(10);
            long[] timestamps = data.getTimeStamps();
            long[][] values = data.getValues();
            for (int i = 0; i < timestamps.length; ++i) {
                Csv.writeCsvElement((CharSequence)formatter.format(Instant.ofEpochMilli(timestamps[i])), (Appendable)writer);
                for (long val : values[i]) {
                    writer.append(',');
                    Csv.writeCsvElement((CharSequence)Long.toString(val), (Appendable)writer);
                }
                ((Writer)writer).write(10);
            }
        }
    }

    public void writeCsvTables(List<String> tableNames, File output) throws IOException {
        DateTimeFormatter formatter = DateTimeFormats.TS_FORMAT;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(output.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String firstTable = tableNames.get(0);
            TSTable table = this.getTSTable(firstTable);
            Csv.writeCsvElement((CharSequence)"table", (Appendable)writer);
            writer.append(',');
            Csv.writeCsvElement((CharSequence)"timestamp", (Appendable)writer);
            for (String colName : table.getColumnNames()) {
                writer.append(',');
                Csv.writeCsvElement((CharSequence)colName, (Appendable)writer);
            }
            ((Writer)writer).write(10);
            for (String tableName : tableNames) {
                TimeSeries data = this.readAll(tableName);
                long[] timestamps = data.getTimeStamps();
                long[][] values = data.getValues();
                for (int i = 0; i < timestamps.length; ++i) {
                    Csv.writeCsvElement((CharSequence)tableName, (Appendable)writer);
                    writer.append(',');
                    Csv.writeCsvElement((CharSequence)formatter.format(Instant.ofEpochMilli(timestamps[i])), (Appendable)writer);
                    for (long val : values[i]) {
                        writer.append(',');
                        Csv.writeCsvElement((CharSequence)Long.toString(val), (Appendable)writer);
                    }
                    ((Writer)writer).write(10);
                }
            }
        }
    }

    public String toString() {
        return "TimeSeriesDatabase{groups=" + this.tables + ", pathToDatabaseFile=" + this.path + '}';
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    public void tail(long pollMillis, long from, TSDataHandler handler) throws IOException {
        Map<Object, Object> lastState = new HashMap();
        long lastSize = 0L;
        while (!Thread.currentThread().isInterrupted() && !handler.finish()) {
            long currSize = this.file.length();
            if (currSize > lastSize) {
                this.reReadTableInfos();
                Map<String, TSTable> currState = this.getTsTables();
                for (String tableName : Sets.difference(currState.keySet(), lastState.keySet())) {
                    handler.newTable(tableName, currState.get(tableName).getColumnNames());
                }
                for (TSTable table : currState.values()) {
                    TimeSeries data;
                    long lastDataFragment;
                    String tableName = table.getTableName();
                    TSTable prevTableState = (TSTable)lastState.get(tableName);
                    long currLastDataFragment = table.getLastDataFragment();
                    if (prevTableState == null) {
                        lastDataFragment = table.getFirstDataFragment();
                        if (lastDataFragment <= 0L) continue;
                        data = this.read(from, Long.MAX_VALUE, lastDataFragment, currLastDataFragment, false);
                        handler.newData(tableName, data);
                        continue;
                    }
                    lastDataFragment = prevTableState.getLastDataFragment();
                    if (lastDataFragment == 0L) {
                        lastDataFragment = table.getFirstDataFragment();
                        if (lastDataFragment <= 0L) continue;
                        data = this.read(from, Long.MAX_VALUE, lastDataFragment, currLastDataFragment, false);
                        handler.newData(tableName, data);
                        continue;
                    }
                    if (currLastDataFragment <= lastDataFragment) continue;
                    data = this.read(from, Long.MAX_VALUE, lastDataFragment, currLastDataFragment, true);
                    handler.newData(tableName, data);
                }
                lastState = currState;
            }
            lastSize = currSize;
            try {
                Thread.sleep(pollMillis);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public String getFilePath() {
        return this.path;
    }

    @JmxExport(value="generateChartsInterval", description="generate charts for all measurements in specified interval")
    public List<String> generateCharts(long startTimeMillis, long endTimeMillis, int width, int height) throws IOException {
        this.flush();
        Collection<TSTable> columnsInfo = this.getTSTables();
        ArrayList<String> result = new ArrayList<String>(16);
        for (TSTable info : columnsInfo) {
            TimeSeries data = this.read(info.getTableName(), startTimeMillis, endTimeMillis);
            if (data.getTimeStamps().length <= 0) continue;
            if (TimeSeriesDatabase.canGenerateMinMaxAvgCount(info)) {
                result.add(this.generateMinMaxAvgCountChart(info, data, width, height));
            }
            if (!TimeSeriesDatabase.canGenerateHeatChart(info)) continue;
            result.add(this.generateHeatChart(info, data, width, height));
        }
        Multimap<String, TSTable> counters = TimeSeriesDatabase.getCounters(columnsInfo);
        Map asMap = counters.asMap();
        for (Map.Entry entry : asMap.entrySet()) {
            Collection ltables = (Collection)entry.getValue();
            int l = ltables.size();
            long[][] timestamps = new long[l][];
            double[][] cdata = new double[l][];
            double[][] cdata2 = new double[l][];
            int i = 0;
            String[] measurementNames = new String[cdata.length];
            String[] measurementNames2 = new String[cdata2.length];
            String uom1 = "count";
            String uom2 = "";
            for (TSTable colInfo : ltables) {
                TimeSeries data = this.read(colInfo.getTableName(), startTimeMillis, endTimeMillis);
                timestamps[i] = data.getTimeStamps();
                long[][] values = data.getValues();
                cdata[i] = Arrays.getColumnAsDoubles((long[][])values, (int)colInfo.getColumnIndex("count"));
                cdata2[i] = Arrays.getColumnAsDoubles((long[][])values, (int)colInfo.getColumnIndex("total"));
                measurementNames[i] = colInfo.getTableName() + ".count";
                measurementNames2[i] = colInfo.getTableName() + ".total";
                uom2 = new String(colInfo.getTableMetaData(), StandardCharsets.UTF_8);
                ++i;
            }
            result.add(this.generateCountChart((String)entry.getKey(), timestamps, measurementNames, measurementNames2, uom1, uom2, cdata, cdata2, width, height));
        }
        return result;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    private static Multimap<String, TSTable> getCounters(Collection<TSTable> columnInfos) {
        HashMultimap result = HashMultimap.create();
        for (TSTable info : columnInfos) {
            int cidx;
            if (!TimeSeriesDatabase.isCounterOnly(info)) continue;
            String groupName = info.getTableName();
            if (groupName.startsWith("(") && (cidx = groupName.indexOf(44)) > 0) {
                groupName = groupName.substring(1, cidx);
            }
            result.put((Object)groupName, (Object)info);
        }
        return result;
    }

    @SuppressWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public static boolean isCounterOnly(TSTable info) {
        String[] columns = info.getColumnNames();
        return columns.length == 2 && "count".equals(columns[0]) && "total".equals(columns[1]);
    }

    public static boolean canGenerateMinMaxAvgCount(TSTable info) {
        return info.getColumnIndex("min") >= 0 && info.getColumnIndex("max") >= 0 && info.getColumnIndex("total") >= 0 && info.getColumnIndex("count") >= 0;
    }

    public static boolean canGenerateCount(TSTable info) {
        return info.getColumnIndex("count") >= 0;
    }

    public static boolean canGenerateHeatChart(TSTable info) {
        for (String mname : info.getColumnNames()) {
            if (!mname.startsWith("Q") || !mname.contains("_")) continue;
            return true;
        }
        return false;
    }

    private String generateMinMaxAvgCountChart(TSTable info, TimeSeries data, int width, int height) throws IOException {
        long[][] vals = data.getValues();
        double[] min = Arrays.getColumnAsDoubles((long[][])vals, (int)info.getColumnIndex("min"));
        double[] max = Arrays.getColumnAsDoubles((long[][])vals, (int)info.getColumnIndex("max"));
        double[] total = Arrays.getColumnAsDoubles((long[][])vals, (int)info.getColumnIndex("total"));
        double[] count = Arrays.getColumnAsDoubles((long[][])vals, (int)info.getColumnIndex("count"));
        for (int i = 0; i < count.length; ++i) {
            if (count[i] != 0.0) continue;
            min[i] = 0.0;
            max[i] = 0.0;
        }
        long[] timestamps = data.getTimeStamps();
        BufferedImage combined = Charts.createMinMaxAvgCountImg("Measurements for " + info.getTableName() + " generated by spf4j", timestamps, min, max, total, count, new String(info.getTableMetaData(), StandardCharsets.UTF_8), width, height);
        File dbFile = new File(this.getDBFilePath());
        File graphicFile = File.createTempFile(dbFile.getName() + '_' + TimeSeriesDatabase.fixName(info.getTableName()), ".mmac.png", dbFile.getParentFile());
        ImageIO.write((RenderedImage)combined, "png", graphicFile);
        return graphicFile.getPath();
    }

    private String generateCountChart(String groupName, long[][] timestamps, String[] measurementNames, String[] measurementNames2, String uom1, String uom2, double[][] measurements, double[][] measurements2, int width, int height) throws IOException {
        BufferedImage combined = Charts.generateCountTotalChart(groupName, timestamps, measurementNames, uom1, measurements, width, height, measurementNames2, uom2, measurements2);
        File dbFile = new File(this.getDBFilePath());
        File graphicFile = File.createTempFile(dbFile.getName() + '_' + TimeSeriesDatabase.fixName(groupName), ".count.png", dbFile.getParentFile());
        ImageIO.write((RenderedImage)combined, "png", graphicFile);
        return graphicFile.getPath();
    }

    private String generateHeatChart(TSTable info, TimeSeries data, int width, int height) throws IOException {
        JFreeChart chart = TimeSeriesDatabase.createHeatJFreeChart(data, info);
        BufferedImage img = chart.createBufferedImage(width, height);
        File dbFile = new File(this.getDBFilePath());
        File graphicFile = File.createTempFile(dbFile.getName() + '_' + TimeSeriesDatabase.fixName(info.getTableName()), ".dist.png", dbFile.getParentFile());
        ImageIO.write((RenderedImage)img, "png", graphicFile);
        return graphicFile.getAbsolutePath();
    }

    private static String fixName(String name) {
        int length = name.length();
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    @JmxExport(description="generate charts for all measurements")
    public List<String> generateCharts(int width, int height) throws IOException {
        long startTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        long endTime = System.currentTimeMillis();
        return this.generateCharts(startTime, endTime, width, height);
    }
}

