/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.chart;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYZDataset;
import org.spf4j.base.ComparablePair;
import org.spf4j.perf.impl.Quanta;
import org.spf4j.perf.impl.chart.QuantizedNumberTickUnit;
import org.spf4j.perf.impl.chart.TimestampTickUnitImpl;

@Immutable
public final class QuantizedXYZDatasetImpl
implements XYZDataset,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double[] x;
    private final double[] y;
    private final double[] z;
    private final double minValue;
    private final double maxValue;
    private final ArrayList<ComparablePair<Quanta, Integer>> quantas;
    private final double[][] data;
    private final long startTimeMillis;
    private final long stepMillis;

    public QuantizedXYZDatasetImpl(String[] dataSources, double[][] pdata, long startTimeMillis, long step) {
        this.data = (double[][])pdata.clone();
        this.startTimeMillis = startTimeMillis;
        this.stepMillis = step;
        this.quantas = new ArrayList(dataSources.length);
        for (int i = 0; i < dataSources.length; ++i) {
            String ds = dataSources[i];
            if (!ds.startsWith("Q")) continue;
            Quanta quanta = new Quanta(ds);
            this.quantas.add((ComparablePair<Quanta, Integer>)ComparablePair.of((Comparable)quanta, (Comparable)Integer.valueOf(i)));
        }
        Collections.sort(this.quantas);
        int nrQuantas = this.quantas.size();
        int seriesSize = nrQuantas * this.data.length;
        this.x = new double[seriesSize];
        this.y = new double[seriesSize];
        this.z = new double[seriesSize];
        double lMinValue = Double.POSITIVE_INFINITY;
        double lMaxValue = Double.NEGATIVE_INFINITY;
        int k = 0;
        for (int j = 0; j < nrQuantas; ++j) {
            ComparablePair<Quanta, Integer> pair = this.quantas.get(j);
            double[] values = org.spf4j.base.Arrays.getColumn((double[][])this.data, (int)((Integer)pair.getSecond()));
            for (int i = 0; i < values.length; ++i) {
                double zval;
                this.x[k] = i;
                this.y[k] = j;
                this.z[k] = zval = values[i];
                if (zval > lMaxValue) {
                    lMaxValue = zval;
                }
                if (zval < lMinValue) {
                    lMinValue = zval;
                }
                ++k;
            }
        }
        this.minValue = lMinValue;
        this.maxValue = lMaxValue;
    }

    public Number getZ(int series, int item) {
        return this.z[item];
    }

    public double getZValue(int series, int item) {
        return this.z[item];
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    public int getItemCount(int series) {
        return this.x.length;
    }

    public Number getX(int series, int item) {
        return this.x[item];
    }

    public double getXValue(int series, int item) {
        return this.x[item];
    }

    public Number getY(int series, int item) {
        return this.y[item];
    }

    public double getYValue(int series, int item) {
        return this.y[item];
    }

    public int getSeriesCount() {
        return 1;
    }

    public Comparable getSeriesKey(int series) {
        return "RrdXYZDataset";
    }

    public int indexOf(Comparable seriesKey) {
        return 0;
    }

    public void addChangeListener(DatasetChangeListener listener) {
    }

    public void removeChangeListener(DatasetChangeListener listener) {
    }

    @Nullable
    public DatasetGroup getGroup() {
        return null;
    }

    public void setGroup(DatasetGroup group) {
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public List<ComparablePair<Quanta, Integer>> getQuantas() {
        return this.quantas;
    }

    public TickUnits createXTickUnits() {
        TickUnits tux = new TickUnits();
        if (this.data.length == 0) {
            return tux;
        }
        ZoneId systemDefault = ZoneId.systemDefault();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HH:mm:ss").withZone(systemDefault);
        DateTimeFormatter shortFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HH").withZone(systemDefault);
        DateTimeFormatter mediumFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HH:mm").withZone(systemDefault);
        long[] timestamps = new long[this.data[0].length];
        long time = this.startTimeMillis;
        for (int i = 0; i < timestamps.length; ++i) {
            timestamps[i] = time;
            time += this.stepMillis;
        }
        tux.add((TickUnit)new TimestampTickUnitImpl(1.0, timestamps, this.stepMillis, formatter));
        long nr = 5000L / this.stepMillis;
        if (nr > 1L) {
            tux.add((TickUnit)new TimestampTickUnitImpl(nr, timestamps, this.stepMillis, formatter));
        }
        if ((nr = 15000L / this.stepMillis) > 1L) {
            tux.add((TickUnit)new TimestampTickUnitImpl(nr, timestamps, this.stepMillis, formatter));
        }
        if ((nr = 60000L / this.stepMillis) > 1L) {
            tux.add((TickUnit)new TimestampTickUnitImpl(nr, timestamps, this.stepMillis, mediumFormat));
        }
        if ((nr = 900000L / this.stepMillis) > 1L) {
            tux.add((TickUnit)new TimestampTickUnitImpl(nr, timestamps, this.stepMillis, mediumFormat));
        }
        if ((nr = 3600000L / this.stepMillis) > 1L) {
            tux.add((TickUnit)new TimestampTickUnitImpl(nr, timestamps, this.stepMillis, shortFormat));
        }
        if ((nr = 21600000L / this.stepMillis) > 1L) {
            tux.add((TickUnit)new TimestampTickUnitImpl(nr, timestamps, this.stepMillis, shortFormat));
        }
        return tux;
    }

    public TickUnits createYTickUnits() {
        TickUnits tu = new TickUnits();
        List<ComparablePair<Quanta, Integer>> lquantas = this.getQuantas();
        tu.add((TickUnit)new QuantizedNumberTickUnit(1.0, lquantas));
        return tu;
    }

    public String toString() {
        return "QuantizedXYZDatasetImpl{x=" + Arrays.toString(this.x) + ", y=" + Arrays.toString(this.y) + ", z=" + Arrays.toString(this.z) + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", quantas=" + this.quantas + ", data=" + Arrays.toString((Object[])this.data) + ", startTimeMillis=" + this.startTimeMillis + ", stepMillis=" + this.stepMillis + '}';
    }
}

