/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.schema;

import org.apache.avro.Schema;

public interface SchemaDiff {
    public String getPath();

    public Type getDiffType();

    public Schema getLeft();

    public Schema getRight();

    public Schema.Field getLeftField();

    public Schema.Field getRightField();

    public static SchemaDiff of(String path, Schema left, Schema right, Type type) {
        return new SchemaDiffImpl(path, type, left, right);
    }

    public static SchemaDiff of(String path, Schema.Field left, Schema.Field right, Type type) {
        return new SchemaFieldDiffImpl(path, type, left, right);
    }

    public static final class SchemaFieldDiffImpl
    implements SchemaDiff {
        private final String path;
        private final Type type;
        private final Schema.Field left;
        private final Schema.Field right;

        SchemaFieldDiffImpl(String path, Type type, Schema.Field left, Schema.Field right) {
            this.path = path;
            this.type = type;
            this.left = left;
            this.right = right;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Type getDiffType() {
            return this.type;
        }

        @Override
        public Schema getLeft() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Schema getRight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Schema.Field getLeftField() {
            return this.left;
        }

        @Override
        public Schema.Field getRightField() {
            return this.right;
        }

        public String toString() {
            return "SchemaFieldDiff{path=" + this.path + ", type=" + (Object)((Object)this.type) + (this.left != null ? ", left=" + this.left : "") + (this.right != null ? ", right=" + this.right : "") + '}';
        }
    }

    public static final class SchemaDiffImpl
    implements SchemaDiff {
        private final String path;
        private final Type type;
        private final Schema left;
        private final Schema right;

        SchemaDiffImpl(String path, Type type, Schema left, Schema right) {
            this.path = path;
            this.type = type;
            this.left = left;
            this.right = right;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Type getDiffType() {
            return this.type;
        }

        @Override
        public Schema getLeft() {
            return this.left;
        }

        @Override
        public Schema getRight() {
            return this.right;
        }

        @Override
        public Schema.Field getLeftField() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Schema.Field getRightField() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "SchemaDiff{path=" + this.path + ", type=" + (Object)((Object)this.type) + (this.left != null ? ", left=" + this.left.getFullName() : "") + (this.right != null ? ", right=" + this.right.getFullName() : "") + '}';
        }
    }

    public static enum Type {
        DIFFERENT_TYPES,
        DIFFERENT_FIXED_SIZE,
        DIFFERENT_NAMES,
        DIFFERENT_ENUM_VALUES,
        SCHEMA_MISSING_LEFT,
        SCHEMA_MISSING_RIGHT,
        FIELD_MISSING_LEFT,
        FIELD_MISSING_RIGHT,
        DIFFERENT_LOGICAL_TYPES,
        DIFFERENT_SCHEMA_PROPERTIES,
        DIFFERRENT_SCHEMA_DOC,
        DIFFERENT_FIELD_DEFAULTS,
        DIFFERENT_FIELD_PROPERTIES,
        DIFFERRENT_FIELD_DOC;

    }
}

