/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.spf4j.avro.SqlPredicate;
import org.spf4j.avro.calcite.FilterUtils;
import org.spf4j.avro.calcite.SqlConverters;

@SuppressFBWarnings(value={"STT_TOSTRING_STORED_IN_FIELD"})
public final class SqlRowPredicate<T extends IndexedRecord>
implements SqlPredicate<T> {
    private final String sqlExpr;
    private final Predicate<IndexedRecord> pred;

    public SqlRowPredicate(String sqlExpr, Schema rowSchema) throws SqlParseException, ValidationException, RelConversionException {
        this.sqlExpr = sqlExpr.trim();
        this.pred = FilterUtils.toPredicate(this.sqlExpr, rowSchema);
    }

    public SqlRowPredicate(List<RexNode> filter, RelDataType rowType) {
        if (filter.isEmpty()) {
            this.sqlExpr = "";
            this.pred = x -> true;
        } else {
            List<SqlNode> convert = SqlConverters.convert(filter, rowType);
            if (convert.size() == 1) {
                this.sqlExpr = convert.get(0).toString();
            } else {
                StringBuilder sqlB = new StringBuilder();
                Iterator<SqlNode> iterator = convert.iterator();
                sqlB.append('(');
                sqlB.append(iterator.next());
                sqlB.append(')');
                while (iterator.hasNext()) {
                    sqlB.append(" AND (");
                    sqlB.append(iterator.next());
                    sqlB.append(')');
                }
                this.sqlExpr = sqlB.toString();
            }
            this.pred = FilterUtils.toPredicate(filter, rowType);
        }
    }

    @Override
    public boolean test(IndexedRecord t) {
        return this.pred.test(t);
    }

    public String toString() {
        return this.sqlExpr;
    }

    @Override
    public String getSqlString() {
        return this.sqlExpr;
    }
}

