/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.calcite;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.spf4j.avro.schema.Schemas;

@SuppressFBWarnings(value={"UCC_UNRELATED_COLLECTION_CONTENTS", "URV_UNRELATED_RETURN_VALUES"})
public final class IndexedRecords {
    private IndexedRecords() {
    }

    public static void copyRecord(IndexedRecord from, Object[] to) {
        for (Schema.Field field : from.getSchema().getFields()) {
            int pos = field.pos();
            Object val = from.get(pos);
            Schema fs = field.schema();
            to[pos] = IndexedRecords.fromAvroToCalcite(val, fs);
        }
    }

    @Nullable
    public static Object fromAvroToCalcite(@Nullable Object avro, @Nonnull Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType != null) {
            switch (logicalType.getName()) {
                case "date": {
                    return ((LocalDate)avro).toEpochDay();
                }
                case "instant": {
                    return ((Instant)avro).toEpochMilli();
                }
                case "decimal": {
                    return ((Number)avro).doubleValue();
                }
            }
            return avro;
        }
        switch (schema.getType()) {
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case ENUM: 
            case FIXED: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                return avro;
            }
            case ARRAY: {
                Schema elType = schema.getElementType();
                Collection col = (Collection)avro;
                return col.stream().map(x -> IndexedRecords.fromAvroToCalcite(x, elType)).collect(Collectors.toCollection(() -> new ArrayList(col.size())));
            }
            case MAP: {
                Schema valueType = schema.getValueType();
                Map map = (Map)avro;
                return map.entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), x -> IndexedRecords.fromAvroToCalcite(x.getValue(), valueType), (u, v) -> {
                    throw new IllegalStateException(String.format("Duplicate key %s", u));
                }, () -> Maps.newHashMapWithExpectedSize((int)map.size())));
            }
            case RECORD: {
                Object[] res = new Object[schema.getFields().size()];
                IndexedRecords.copyRecord((IndexedRecord)avro, res);
                return res;
            }
            case UNION: {
                Schema nSchema = Schemas.nullableUnionSchema(schema);
                if (nSchema == null) {
                    throw new UnsupportedOperationException("Not supported union " + schema);
                }
                if (avro == null) {
                    return null;
                }
                return IndexedRecords.fromAvroToCalcite(avro, nSchema);
            }
        }
        throw new UnsupportedOperationException("Not supported schema " + schema);
    }

    @Nullable
    public static Object fromCalciteToAvro(Schema schema, @Nullable Object calc) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType != null) {
            switch (logicalType.getName()) {
                case "date": {
                    return LocalDate.ofEpochDay(((Integer)calc).intValue());
                }
                case "instant": {
                    return Instant.ofEpochMilli((Long)calc);
                }
                case "decimal": {
                    return BigDecimal.valueOf(((Number)calc).doubleValue());
                }
            }
            return calc;
        }
        switch (schema.getType()) {
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case ENUM: 
            case FIXED: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                return calc;
            }
            case ARRAY: {
                Schema elType = schema.getElementType();
                Collection col = (Collection)calc;
                return col.stream().map(x -> IndexedRecords.fromCalciteToAvro(elType, x)).collect(Collectors.toCollection(() -> new ArrayList(col.size())));
            }
            case MAP: {
                Schema valueType = schema.getValueType();
                Map map = (Map)calc;
                return map.entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), x -> IndexedRecords.fromCalciteToAvro(valueType, x.getValue()), (u, v) -> {
                    throw new IllegalStateException(String.format("Duplicate key %s", u));
                }, () -> Maps.newHashMapWithExpectedSize((int)map.size())));
            }
            case RECORD: {
                return IndexedRecords.fromRecord(schema, (Object[])calc);
            }
            case UNION: {
                Schema nSchema = Schemas.nullableUnionSchema(schema);
                if (nSchema == null) {
                    throw new UnsupportedOperationException("Not supported union " + schema);
                }
                if (calc == null) {
                    return null;
                }
                return IndexedRecords.fromCalciteToAvro(nSchema, calc);
            }
        }
        throw new UnsupportedOperationException("Not supported schema " + schema);
    }

    public static GenericRecord fromRecord(Schema schema, Object[] from) {
        GenericData.Record record = new GenericData.Record(schema);
        for (Schema.Field field : schema.getFields()) {
            int pos = field.pos();
            Schema fs = field.schema();
            record.put(pos, IndexedRecords.fromCalciteToAvro(fs, from[pos]));
        }
        return record;
    }
}

