/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificRecord;
import org.spf4j.avro.SqlPredicate;
import org.spf4j.base.CloseableIterable;
import org.spf4j.base.Reflections;
import org.spf4j.security.AbacSecurityContext;

@ParametersAreNonnullByDefault
public interface AvroDataSet<T extends IndexedRecord> {
    default public Schema getElementSchema() {
        List intfs = Reflections.getImplementedGenericInterfaces(this.getClass());
        for (Type type : intfs) {
            TypeToken tt = TypeToken.of((Type)type);
            if (!AvroDataSet.class.isAssignableFrom(tt.getRawType())) continue;
            if (type instanceof ParameterizedType) {
                Class srClasz = TypeToken.of((Type)((ParameterizedType)type).getActualTypeArguments()[0]).getRawType();
                if (!SpecificRecord.class.isAssignableFrom(srClasz)) continue;
                try {
                    return ((SpecificRecord)srClasz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getSchema();
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    throw new IllegalStateException("Invalid specific record " + srClasz, ex);
                }
            }
            throw new IllegalStateException("Resource " + this + " must overwrite default implementation of getSchema()");
        }
        throw new IllegalStateException("Resource " + this + " must overwrite default implementation of getSchema()");
    }

    default public String getName() {
        return this.getElementSchema().getName();
    }

    default public Set<Feature> getFeatures() {
        return Collections.EMPTY_SET;
    }

    default public long getRowCountStatistic() {
        return -1L;
    }

    public CloseableIterable<? extends IndexedRecord> getData(@Nullable SqlPredicate<T> var1, @Nullable List<String> var2, AbacSecurityContext var3, long var4, TimeUnit var6);

    public static enum Feature {
        FILTERABLE,
        PROJECTABLE;

    }
}

