/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;

@Immutable
public final class ImmutableSchema
extends Schema {
    private static final long serialVersionUID = 1L;
    private final Schema wrapped;

    private ImmutableSchema(Schema schema) {
        super(schema.getType());
        this.wrapped = schema;
    }

    public static ImmutableSchema create(Schema schema) {
        if (schema instanceof ImmutableSchema) {
            return (ImmutableSchema)schema;
        }
        return new ImmutableSchema(schema);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ImmutableSchema other = (ImmutableSchema)((Object)obj);
        return Objects.equals(this.wrapped, other.wrapped);
    }

    int computeHash() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public int getFixedSize() {
        return this.wrapped.getFixedSize();
    }

    public Integer getIndexNamed(String name) {
        return this.wrapped.getIndexNamed(name);
    }

    public List<Schema> getTypes() {
        return this.wrapped.getTypes();
    }

    public Schema getValueType() {
        return this.wrapped.getValueType();
    }

    public Schema getElementType() {
        return this.wrapped.getElementType();
    }

    public boolean isError() {
        return this.wrapped.isError();
    }

    public Set<String> getAliases() {
        return this.wrapped.getAliases();
    }

    public void addAlias(String alias, String space) {
        throw new UnsupportedOperationException();
    }

    public void addAlias(String alias) {
        throw new UnsupportedOperationException();
    }

    public String getFullName() {
        return this.wrapped.getFullName();
    }

    public String getNamespace() {
        return this.wrapped.getNamespace();
    }

    @Nullable
    public String getDoc() {
        return this.wrapped.getDoc();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public boolean hasEnumSymbol(String symbol) {
        return this.wrapped.hasEnumSymbol(symbol);
    }

    public int getEnumOrdinal(String symbol) {
        return this.wrapped.getEnumOrdinal(symbol);
    }

    public List<String> getEnumSymbols() {
        return super.getEnumSymbols();
    }

    public void setFields(List<Schema.Field> fields) {
        try {
            this.wrapped.setFields(fields);
        }
        catch (AvroRuntimeException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public List<Schema.Field> getFields() {
        return this.wrapped.getFields();
    }

    public Schema.Field getField(String fieldname) {
        return this.wrapped.getField(fieldname);
    }

    public LogicalType getLogicalType() {
        return this.wrapped.getLogicalType();
    }

    public void addProp(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void addProp(String name, JsonNode value) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getObjectProps() {
        return this.wrapped.getObjectProps();
    }

    public Map<String, JsonNode> getJsonProps() {
        return this.wrapped.getJsonProps();
    }

    public Map<String, String> getProps() {
        return this.wrapped.getProps();
    }

    public void addProp(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public Object getObjectProp(String name) {
        return this.wrapped.getObjectProp(name);
    }

    public JsonNode getJsonProp(String name) {
        return this.wrapped.getJsonProp(name);
    }

    @Nullable
    public String getProp(String name) {
        return this.wrapped.getProp(name);
    }

    public void fieldsToJson(Schema.Names names, JsonGenerator gen) throws IOException {
        this.wrapped.fieldsToJson(names, gen);
    }

    public void toJson(Schema.Names names, JsonGenerator gen) throws IOException {
        this.wrapped.toJson(names, gen);
    }

    public String toString(boolean pretty) {
        return this.wrapped.toString(pretty);
    }

    public void setLogicalType(LogicalType logicalType) {
        throw new UnsupportedOperationException();
    }

    void writeProps(JsonGenerator gen) throws IOException {
        this.wrapped.writeProps(gen);
    }

    Map<String, JsonNode> jsonProps(Map<String, String> stringProps) {
        throw new UnsupportedOperationException();
    }
}

