/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.Beta;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;

@Beta
@Immutable
public final class ImmutableField
extends Schema.Field {
    private final Schema.Field wrapped;

    private ImmutableField(Schema.Field field) {
        super(field.name(), field.schema(), field.doc(), field.defaultVal(), field.order());
        this.wrapped = field;
    }

    public static ImmutableField create(Schema.Field field) {
        return new ImmutableField(field);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public Set<String> aliases() {
        return this.wrapped.aliases();
    }

    public void addAlias(String alias) {
        throw new UnsupportedOperationException();
    }

    public int pos() {
        return this.wrapped.pos();
    }

    public void writeProps(JsonGenerator gen) throws IOException {
        this.wrapped.writeProps(gen);
    }

    public Map<String, Object> getObjectProps() {
        return this.wrapped.getObjectProps();
    }

    public Map<String, JsonNode> getJsonProps() {
        return this.wrapped.getJsonProps();
    }

    Map<String, JsonNode> jsonProps(Map<String, String> stringProps) {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getProps() {
        return this.wrapped.getProps();
    }

    public void addProp(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void addProp(String name, JsonNode value) {
        throw new UnsupportedOperationException();
    }

    public void addProp(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public Object getObjectProp(String name) {
        return this.wrapped.getObjectProp(name);
    }

    public JsonNode getJsonProp(String name) {
        return this.wrapped.getJsonProp(name);
    }

    @Nullable
    public String getProp(String name) {
        return this.wrapped.getProp(name);
    }

    public int hashCode() {
        return Objects.hashCode(this.wrapped);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ImmutableField other = (ImmutableField)((Object)obj);
        return Objects.equals(this.wrapped, other.wrapped);
    }
}

