/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.aspects;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.OutputStream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.impl.RecorderFactory;
import org.spf4j.perf.io.MeasuredInputStream;
import org.spf4j.perf.io.MeasuredOutputStream;

@Aspect
@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
public final class NetworkMonitorAspect {
    public static final int SAMPLE_TIME = Integer.getInteger("spf4j.perf.network.sampleTimeMillis", 300000);
    private static final MeasurementRecorderSource RECORDER_READ = RecorderFactory.createScalableCountingRecorderSource((Object)"network-read", (String)"bytes", (int)SAMPLE_TIME);
    private static final MeasurementRecorderSource RECORDER_WRITE = RecorderFactory.createScalableCountingRecorderSource((Object)"network-write", (String)"bytes", (int)SAMPLE_TIME);

    @Around(value="call(long java.nio.channels.SocketChannel.read(..))")
    public Object nioReadLong(ProceedingJoinPoint pjp) throws Throwable {
        Long result = (Long)pjp.proceed();
        if (result >= 0L) {
            RECORDER_READ.getRecorder((Object)pjp.getSourceLocation().getWithinType()).record(result.longValue());
        }
        return result;
    }

    @Around(value="call(int java.nio.channels.SocketChannel.read(..))")
    public Object nioReadInt(ProceedingJoinPoint pjp) throws Throwable {
        Integer result = (Integer)pjp.proceed();
        if (result >= 0) {
            RECORDER_READ.getRecorder((Object)pjp.getSourceLocation().getWithinType()).record((long)result.intValue());
        }
        return result;
    }

    @Around(value="call(long java.nio.channels.SocketChannel.write(..))")
    public Object nioWriteLong(ProceedingJoinPoint pjp) throws Throwable {
        Long result = (Long)pjp.proceed();
        if (result >= 0L) {
            RECORDER_WRITE.getRecorder((Object)pjp.getSourceLocation().getWithinType()).record(result.longValue());
        }
        return result;
    }

    @Around(value="call(int java.nio.channels.SocketChannel.write(..))")
    public Object nioWriteInt(ProceedingJoinPoint pjp) throws Throwable {
        Integer result = (Integer)pjp.proceed();
        if (result >= 0) {
            RECORDER_WRITE.getRecorder((Object)pjp.getSourceLocation().getWithinType()).record((long)result.intValue());
        }
        return result;
    }

    @Around(value="call(* java.net.Socket.getInputStream())")
    public Object socketIS(ProceedingJoinPoint pjp) throws Throwable {
        InputStream result = (InputStream)pjp.proceed();
        return new MeasuredInputStream(result, pjp.getSourceLocation().getWithinType().getName(), RECORDER_READ);
    }

    @Around(value="call(* java.net.Socket.getOutputStream())")
    public Object socketOS(ProceedingJoinPoint pjp) throws Throwable {
        OutputStream result = (OutputStream)pjp.proceed();
        return new MeasuredOutputStream(result, pjp.getSourceLocation().getWithinType().getName(), RECORDER_WRITE);
    }
}

