/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.aspects;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.OutputStream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.impl.RecorderFactory;
import org.spf4j.perf.io.MeasuredInputStream;
import org.spf4j.perf.io.MeasuredOutputStream;

@Aspect
@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
public final class FileMonitorAspect {
    public static final int SAMPLE_TIME = Integer.getInteger("spf4j.perf.file.sampleTimeMillis", 300000);
    public static final boolean ADD_FILE_DETAIL = Boolean.getBoolean("spf4j.perf.file.addFileDetail");
    private static final MeasurementRecorderSource RECORDER_READ = RecorderFactory.createScalableCountingRecorderSource((Object)"file-read", (String)"bytes", (int)SAMPLE_TIME);
    private static final MeasurementRecorderSource RECORDER_WRITE = RecorderFactory.createScalableCountingRecorderSource((Object)"file-write", (String)"bytes", (int)SAMPLE_TIME);

    @Around(value="call(long java.nio.channels.FileChannel.read(..))")
    public Object nioReadLong(ProceedingJoinPoint pjp) throws Throwable {
        Long result = (Long)pjp.proceed();
        if (result >= 0L) {
            RECORDER_READ.getRecorder((Object)pjp.getSourceLocation().getWithinType()).record(result.longValue());
        }
        return result;
    }

    @Around(value="call(int java.nio.channels.FileChannel.read(..))")
    public Object nioReadInt(ProceedingJoinPoint pjp) throws Throwable {
        Integer result = (Integer)pjp.proceed();
        if (result >= 0) {
            RECORDER_READ.getRecorder((Object)pjp.getSourceLocation().getWithinType()).record((long)result.intValue());
        }
        return result;
    }

    @Around(value="call(long java.nio.channels.FileChannel.write(..))")
    public Object nioWriteLong(ProceedingJoinPoint pjp) throws Throwable {
        Long result = (Long)pjp.proceed();
        if (result >= 0L) {
            RECORDER_WRITE.getRecorder((Object)pjp.getSourceLocation().getWithinType()).record(result.longValue());
        }
        return result;
    }

    @Around(value="call(int java.nio.channels.FileChannel.write(..))")
    public Object nioWriteInt(ProceedingJoinPoint pjp) throws Throwable {
        Integer result = (Integer)pjp.proceed();
        RECORDER_WRITE.getRecorder((Object)pjp.getSourceLocation().getWithinType()).record((long)result.intValue());
        return result;
    }

    @SuppressFBWarnings(value={"ISB_TOSTRING_APPENDING"})
    private static String getLogInfo(ProceedingJoinPoint pjp) {
        String logInfo = pjp.getSourceLocation().getWithinType().getName();
        if (ADD_FILE_DETAIL) {
            logInfo = logInfo + ':' + pjp.getArgs()[0].toString();
        }
        return logInfo;
    }

    @Around(value="call(java.io.FileInputStream.new(java.io.File))")
    public Object fileIS(ProceedingJoinPoint pjp) throws Throwable {
        return new MeasuredInputStream((InputStream)pjp.proceed(), FileMonitorAspect.getLogInfo(pjp), RECORDER_READ);
    }

    @Around(value="call(java.io.InputStream java.nio.file.Files.newInputStream(..))")
    public Object filesIS(ProceedingJoinPoint pjp) throws Throwable {
        return new MeasuredInputStream((InputStream)pjp.proceed(), FileMonitorAspect.getLogInfo(pjp), RECORDER_READ);
    }

    @Around(value="call(java.io.FileOutputStream.new(java.io.File))")
    public Object fileOS(ProceedingJoinPoint pjp) throws Throwable {
        return new MeasuredOutputStream((OutputStream)pjp.proceed(), FileMonitorAspect.getLogInfo(pjp), RECORDER_WRITE);
    }

    @Around(value="call(java.io.OutputStream java.nio.file.Files.newOutputStream(..))")
    public Object filesOS(ProceedingJoinPoint pjp) throws Throwable {
        return new MeasuredOutputStream((OutputStream)pjp.proceed(), FileMonitorAspect.getLogInfo(pjp), RECORDER_WRITE);
    }
}

