/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.specs2.control.Exceptions$;
import org.specs2.io.FileReader;
import org.specs2.io.Paths$;
import org.specs2.text.MD5$;
import org.specs2.xml.Nodex$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.XML$;
import scala.xml.parsing.MarkupParser;
import scala.xml.parsing.XhtmlParser;
import scala.xml.parsing.XhtmlParser$;

public abstract class FileReader$class {
    public static IndexedSeq readLines(FileReader $this, String path) {
        return FileReader$class.hasContents($this, path) ? Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec()).getLines().toIndexedSeq() : (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(FileReader $this, String path) {
        byte[] byArray;
        if (!FileReader$class.hasContents($this, path)) {
            byArray = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
            return byArray;
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(path));
        try {
            byArray = (byte[])((TraversableOnce)package$.MODULE$.Stream().continually((Function0)new Serializable($this, stream){
                public static final long serialVersionUID = 0L;
                private final BufferedInputStream stream$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.stream$1.read();
                }
                {
                    this.stream$1 = stream$1;
                }
            }).takeWhile((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(int x) {
                    return this.apply$mcZI$sp(x);
                }

                public boolean apply$mcZI$sp(int x) {
                    return -1 != x;
                }
            }).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final byte apply(int x$1) {
                    return (byte)x$1;
                }
            }, Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        stream.close();
        return byArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFile(FileReader $this, String path) {
        String string;
        if (!FileReader$class.hasContents($this, path)) return "";
        BufferedReader in2 = new BufferedReader(new java.io.FileReader(path));
        try {
            StringBuffer result2 = new StringBuffer();
            FileReader$class.appendLines$1($this, result2, in2, in2.readLine());
            string = result2.toString();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        in2.close();
        return string;
    }

    private static boolean hasContents(FileReader $this, String path) {
        return new File(path).exists() && !new File(path).isDirectory();
    }

    public static InputStream inputStream(FileReader $this, String filePath) {
        return new FileInputStream(filePath);
    }

    public static String md5(FileReader $this, File f) {
        return MD5$.MODULE$.md5Hex($this.readBytes(f.getPath()));
    }

    public static Function1 fromBaseFile(FileReader $this, File base) {
        return new Serializable($this, base){
            public static final long serialVersionUID = 0L;
            private final File base$1;

            public final String apply(File aFile) {
                return (String)Paths$.MODULE$.from(this.base$1.getPath()).apply((Object)aFile.getPath());
            }
            {
                this.base$1 = base$1;
            }
        };
    }

    public static NodeSeq loadXmlFile(FileReader $this, String filePath, Function1 report) {
        return (NodeSeq)Exceptions$.MODULE$.tryo(new Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final String filePath$1;

            public final Elem apply() {
                return (Elem)XML$.MODULE$.load(this.filePath$1);
            }
            {
                this.filePath$1 = filePath$1;
            }
        }, (Function1<Exception, BoxedUnit>)report).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NodeSeq apply() {
                return NodeSeq$.MODULE$.Empty();
            }
        });
    }

    public static Function1 loadXmlFile$default$2(FileReader $this, String filePath) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Exception e) {
                e.printStackTrace();
            }
        };
    }

    public static NodeSeq loadXhtmlFile(FileReader $this, String filePath, Function2 report, boolean sourceErrors) {
        return (NodeSeq)Exceptions$.MODULE$.tryo(new Serializable($this, filePath, sourceErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileReader $outer;
            private final String filePath$2;
            private final boolean sourceErrors$1;

            /*
             * WARNING - void declaration
             */
            public final NodeSeq apply() {
                void var3_3;
                String fileContent = this.$outer.readFile(this.filePath$2);
                Source xhtml = Source$.MODULE$.fromString(new StringBuilder().append((Object)"<e>").append((Object)fileContent).append((Object)"</e>").toString());
                NodeSeq result2 = Nodex$.MODULE$.reducable((Seq<Node>)FileReader$class.org$specs2$io$FileReader$$parse(this.$outer, xhtml, this.sourceErrors$1).$bslash$bslash("e").apply(0).child()).reduceNodes();
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.filePath$2 = filePath$2;
                this.sourceErrors$1 = sourceErrors$1;
            }
        }, (Function1<Exception, BoxedUnit>)new Serializable($this, filePath, report){
            public static final long serialVersionUID = 0L;
            private final String filePath$2;
            private final Function2 report$1;

            public final void apply(Exception e) {
                this.report$1.apply((Object)e, (Object)this.filePath$2);
            }
            {
                this.filePath$2 = filePath$2;
                this.report$1 = report$1;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NodeSeq apply() {
                return NodeSeq$.MODULE$.Empty();
            }
        });
    }

    public static Function2 loadXhtmlFile$default$2(FileReader $this) {
        return FileReader$class.org$specs2$io$FileReader$$defaultLoadXhtmlFileReport($this);
    }

    public static boolean loadXhtmlFile$default$3(FileReader $this) {
        return true;
    }

    public static NodeSeq org$specs2$io$FileReader$$parse(FileReader $this, Source source, boolean sourceErrors) {
        return sourceErrors ? XhtmlParser$.MODULE$.apply(source) : ((MarkupParser)new XhtmlParser($this, source){

            public void reportSyntaxError(int pos, String str) {
            }
        }.initialize()).document();
    }

    private static boolean parse$default$2(FileReader $this) {
        return true;
    }

    public static Function2 silentLoadXhtmlFileReport(FileReader $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Exception e, String filePath) {
            }
        };
    }

    public static Function2 org$specs2$io$FileReader$$defaultLoadXhtmlFileReport(FileReader $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Exception e, String filePath) {
                Console$.MODULE$.println((Object)new StringBuilder().append((Object)"trying to load: ").append((Object)filePath).append((Object)"\n").toString());
                e.printStackTrace();
            }
        };
    }

    private static final void appendLines$1(FileReader $this, StringBuffer result2, BufferedReader in2, String line) {
        while (true) {
            if (line == null) {
                return;
            }
            result2.append(line);
            result2.append("\n");
            line = in2.readLine();
        }
    }

    public static void $init$(FileReader $this) {
    }
}

