/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.concurrent;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.specs2.concurrent.ExecutorServices;
import org.specs2.concurrent.Scheduler;
import org.specs2.concurrent.Schedulers$;
import org.specs2.control.NamedThreadFactory;
import org.specs2.control.NamedThreadFactory$;
import org.specs2.control.eff.ConsoleEffect$;
import org.specs2.control.eff.Evaluated;
import org.specs2.control.eff.Member$;
import org.specs2.control.eff.MemberIn$;
import org.specs2.control.eff.Memoized$;
import org.specs2.main.Arguments;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple5;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class ExecutorServices$
implements Serializable {
    public static final ExecutorServices$ MODULE$ = new ExecutorServices$();
    private static int threadsNb;
    private static int specs2ThreadsNb;
    private static volatile byte bitmap$0;

    private int threadsNb$lzycompute() {
        ExecutorServices$ executorServices$ = this;
        synchronized (executorServices$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                threadsNb = package$.MODULE$.max(Runtime.getRuntime().availableProcessors(), 4);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return threadsNb;
    }

    public int threadsNb() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.threadsNb$lzycompute();
        }
        return threadsNb;
    }

    private int specs2ThreadsNb$lzycompute() {
        ExecutorServices$ executorServices$ = this;
        synchronized (executorServices$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                specs2ThreadsNb = package$.MODULE$.max(Runtime.getRuntime().availableProcessors(), 4);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return specs2ThreadsNb;
    }

    public int specs2ThreadsNb() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.specs2ThreadsNb$lzycompute();
        }
        return specs2ThreadsNb;
    }

    public ExecutorServices create(Arguments arguments2, Function1<String, BoxedUnit> systemLogger, Option<String> tag) {
        return this.createExecutorServices(arguments2, systemLogger, tag, false);
    }

    public Option<String> create$default$3() {
        return None$.MODULE$;
    }

    public ExecutorServices createSpecs2(Arguments arguments2, Function1<String, BoxedUnit> systemLogger, Option<String> tag) {
        return this.createExecutorServices(arguments2, systemLogger, tag, true);
    }

    public Option<String> createSpecs2$default$3() {
        return None$.MODULE$;
    }

    private ExecutorServices createExecutorServices(Arguments arguments2, Function1<String, BoxedUnit> systemLogger, Option<String> tag, boolean isSpecs2) {
        LazyRef executorService$lzy = new LazyRef();
        LazyRef scheduledExecutorService$lzy = new LazyRef();
        LazyRef executionContext$lzy = new LazyRef();
        String threadFactoryName = isSpecs2 ? new StringBuilder(6).append("specs2").append(tag.map((Function1 & Serializable)x$2 -> new StringBuilder(1).append("-").append((String)x$2).toString()).getOrElse((Function0 & Serializable)() -> "")).toString() : new StringBuilder(11).append("specs2.user").append(tag.map((Function1 & Serializable)x$3 -> new StringBuilder(1).append("-").append((String)x$3).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
        return new ExecutorServices(Memoized$.MODULE$.apply((Function0 & Serializable)() -> this.executorService$1(executorService$lzy, isSpecs2, arguments2, threadFactoryName)), Memoized$.MODULE$.apply((Function0 & Serializable)() -> this.executionContext$1(executionContext$lzy, arguments2, systemLogger, executorService$lzy, isSpecs2, threadFactoryName)), Memoized$.MODULE$.apply((Function0 & Serializable)() -> this.scheduledExecutorService$1(scheduledExecutorService$lzy, arguments2, threadFactoryName)), Memoized$.MODULE$.apply((Function0 & Serializable)() -> Schedulers$.MODULE$.schedulerFromScheduledExecutorService(this.scheduledExecutorService$1(scheduledExecutorService$lzy, arguments2, threadFactoryName))), Memoized$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> {
            try {
                this.executorService$1(executorService$lzy, isSpecs2, arguments2, threadFactoryName).shutdown();
            }
            finally {
                this.scheduledExecutorService$1(scheduledExecutorService$lzy, arguments2, threadFactoryName).shutdown();
            }
        }));
    }

    public ExecutorServices fromExecutionContext(ExecutionContext ec) {
        return new ExecutorServices(Memoized$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.fixedExecutor(1, "unused")), Memoized$.MODULE$.apply((Function0 & Serializable)() -> ec), Memoized$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.scheduledExecutor(1, "unused")), Memoized$.MODULE$.apply((Function0 & Serializable)() -> Schedulers$.MODULE$.default()), Memoized$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> {}));
    }

    public ExecutorServices fromGlobalExecutionContext() {
        return this.fromExecutionContext((ExecutionContext)ExecutionContext$.MODULE$.global());
    }

    public ExecutionContextExecutorService createExecutionContext(ExecutorService executorService, boolean verbose, Function1<String, BoxedUnit> systemLogger) {
        return ExecutionContext$.MODULE$.fromExecutorService(executorService, (Function1 & Serializable)t -> {
            ConsoleEffect$.MODULE$.runConsoleToPrinter((Function1<String, BoxedUnit>)systemLogger, ConsoleEffect$.MODULE$.logThrowable(t, verbose, MemberIn$.MODULE$.MemberIn1()), Member$.MODULE$.Member1());
            return BoxedUnit.UNIT;
        });
    }

    public ExecutorService fixedExecutor(int threadsNb, String name) {
        return Executors.newFixedThreadPool(threadsNb, new NamedThreadFactory(name, NamedThreadFactory$.MODULE$.apply$default$2(), NamedThreadFactory$.MODULE$.apply$default$3()));
    }

    public ScheduledExecutorService scheduledExecutor(int scheduledThreadsNb, String name) {
        return Executors.newScheduledThreadPool(scheduledThreadsNb, new NamedThreadFactory(new StringBuilder(17).append("specs2.scheduled.").append(name).toString(), NamedThreadFactory$.MODULE$.apply$default$2(), NamedThreadFactory$.MODULE$.apply$default$3()));
    }

    public ExecutorServices apply(Evaluated<ExecutorService> executorServiceEval, Evaluated<ExecutionContext> executionContextEval, Evaluated<ScheduledExecutorService> scheduledExecutorServiceEval, Evaluated<Scheduler> schedulerEval, Evaluated<BoxedUnit> shutdown) {
        return new ExecutorServices(executorServiceEval, executionContextEval, scheduledExecutorServiceEval, schedulerEval, shutdown);
    }

    public Option<Tuple5<Evaluated<ExecutorService>, Evaluated<ExecutionContext>, Evaluated<ScheduledExecutorService>, Evaluated<Scheduler>, Evaluated<BoxedUnit>>> unapply(ExecutorServices x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5(x$0.executorServiceEval(), x$0.executionContextEval(), x$0.scheduledExecutorServiceEval(), x$0.schedulerEval(), x$0.shutdown()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExecutorServices$.class);
    }

    private final /* synthetic */ ExecutorService executorService$lzycompute$1(LazyRef executorService$lzy$1, boolean isSpecs2$1, Arguments arguments$1, String threadFactoryName$1) {
        ExecutorService executorService;
        LazyRef lazyRef = executorService$lzy$1;
        synchronized (lazyRef) {
            executorService = executorService$lzy$1.initialized() ? (ExecutorService)executorService$lzy$1.value() : (ExecutorService)executorService$lzy$1.initialize((Object)(isSpecs2$1 ? this.fixedExecutor(arguments$1.specs2ThreadsNb(), threadFactoryName$1) : this.fixedExecutor(arguments$1.threadsNb(), threadFactoryName$1)));
        }
        return executorService;
    }

    private final ExecutorService executorService$1(LazyRef executorService$lzy$1, boolean isSpecs2$1, Arguments arguments$1, String threadFactoryName$1) {
        if (executorService$lzy$1.initialized()) {
            return (ExecutorService)executorService$lzy$1.value();
        }
        return this.executorService$lzycompute$1(executorService$lzy$1, isSpecs2$1, arguments$1, threadFactoryName$1);
    }

    private final /* synthetic */ ScheduledExecutorService scheduledExecutorService$lzycompute$1(LazyRef scheduledExecutorService$lzy$1, Arguments arguments$1, String threadFactoryName$1) {
        ScheduledExecutorService scheduledExecutorService;
        LazyRef lazyRef = scheduledExecutorService$lzy$1;
        synchronized (lazyRef) {
            scheduledExecutorService = scheduledExecutorService$lzy$1.initialized() ? (ScheduledExecutorService)scheduledExecutorService$lzy$1.value() : (ScheduledExecutorService)scheduledExecutorService$lzy$1.initialize((Object)this.scheduledExecutor(arguments$1.scheduledThreadsNb(), threadFactoryName$1));
        }
        return scheduledExecutorService;
    }

    private final ScheduledExecutorService scheduledExecutorService$1(LazyRef scheduledExecutorService$lzy$1, Arguments arguments$1, String threadFactoryName$1) {
        if (scheduledExecutorService$lzy$1.initialized()) {
            return (ScheduledExecutorService)scheduledExecutorService$lzy$1.value();
        }
        return this.scheduledExecutorService$lzycompute$1(scheduledExecutorService$lzy$1, arguments$1, threadFactoryName$1);
    }

    private final /* synthetic */ ExecutionContextExecutorService executionContext$lzycompute$1(LazyRef executionContext$lzy$1, Arguments arguments$1, Function1 systemLogger$1, LazyRef executorService$lzy$1, boolean isSpecs2$1, String threadFactoryName$1) {
        ExecutionContextExecutorService executionContextExecutorService;
        LazyRef lazyRef = executionContext$lzy$1;
        synchronized (lazyRef) {
            executionContextExecutorService = executionContext$lzy$1.initialized() ? (ExecutionContextExecutorService)executionContext$lzy$1.value() : (ExecutionContextExecutorService)executionContext$lzy$1.initialize((Object)this.createExecutionContext(this.executorService$1(executorService$lzy$1, isSpecs2$1, arguments$1, threadFactoryName$1), arguments$1.verbose(), (Function1<String, BoxedUnit>)systemLogger$1));
        }
        return executionContextExecutorService;
    }

    private final ExecutionContextExecutorService executionContext$1(LazyRef executionContext$lzy$1, Arguments arguments$1, Function1 systemLogger$1, LazyRef executorService$lzy$1, boolean isSpecs2$1, String threadFactoryName$1) {
        if (executionContext$lzy$1.initialized()) {
            return (ExecutionContextExecutorService)executionContext$lzy$1.value();
        }
        return this.executionContext$lzycompute$1(executionContext$lzy$1, arguments$1, systemLogger$1, executorService$lzy$1, isSpecs2$1, threadFactoryName$1);
    }

    private ExecutorServices$() {
    }
}

