/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.License;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxCoreConstants;
import org.spdx.core.SpdxInvalidIdException;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.conversion.Spdx2to3Converter;
import org.spdx.library.model.v2.Annotation;
import org.spdx.library.model.v2.ExternalRef;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxPackageVerificationCode;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.AnnotationType;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalElement;
import org.spdx.library.model.v3_0_1.core.ExternalMap;
import org.spdx.library.model.v3_0_1.core.Hash;
import org.spdx.library.model.v3_0_1.core.HashAlgorithm;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.LifecycleScopeType;
import org.spdx.library.model.v3_0_1.core.Relationship;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.expandedlicensing.NoAssertionLicense;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.library.model.v3_0_1.simplelicensing.LicenseExpression;
import org.spdx.library.model.v3_0_1.software.Sbom;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.library.model.v3_0_1.software.SpdxFile;
import org.spdx.library.model.v3_0_1.software.SpdxPackage;
import org.spdx.maven.Checksum;
import org.spdx.maven.LicenseOverwrite;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.utils.AbstractDependencyBuilder;
import org.spdx.maven.utils.AbstractFileCollector;
import org.spdx.maven.utils.IdGenerator;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.MavenToSpdxLicenseMapper;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxExternalIdBuilder;
import org.spdx.maven.utils.SpdxExternalRefBuilder;
import org.spdx.maven.utils.SpdxV2DependencyBuilder;
import org.spdx.maven.utils.SpdxV3DocumentBuilder;
import org.spdx.maven.utils.SpdxV3LicenseManager;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.v3jsonldstore.JsonLDStore;

public class SpdxV3DependencyBuilder
extends AbstractDependencyBuilder {
    private final org.spdx.library.model.v3_0_1.core.SpdxDocument spdxDoc;
    private final SpdxV3LicenseManager licenseManager;
    private final Map<LicenseOverwrite, AnyLicenseInfo> licenseOverwrites = new HashMap<LicenseOverwrite, AnyLicenseInfo>();

    public SpdxV3DependencyBuilder(SpdxV3DocumentBuilder builder, boolean createExternalRefs, boolean generatePurls, boolean useArtifactID, boolean includeTransitiveDependencies) {
        super(createExternalRefs, generatePurls, useArtifactID, includeTransitiveDependencies);
        this.spdxDoc = builder.getSpdxDoc();
        this.licenseManager = builder.getLicenseManager();
    }

    @Override
    protected void addMavenDependency(CoreModelObject parentPackage, DependencyNode dependencyNode, ProjectBuilder mavenProjectBuilder, MavenSession session, MavenProject mavenProject) throws LicenseMapperException, InvalidSPDXAnalysisException {
        if (!(parentPackage instanceof SpdxPackage)) {
            LOG.error("Invalid type for parent package.  Expected 'SpdxPackage', found {}", (Object)parentPackage.getClass().getName());
            return;
        }
        Artifact dependency = dependencyNode.getArtifact();
        String scope = dependency.getScope();
        RelationshipType relType = this.scopeToRelationshipType(scope, dependency.isOptional());
        if (relType == RelationshipType.OTHER) {
            LOG.warn("Could not determine the SPDX relationship type for dependency artifact ID {} scope {}", (Object)dependency.getArtifactId(), (Object)scope);
        }
        Element dependencyPackage = this.createSpdxPackage(dependency, mavenProjectBuilder, session, mavenProject, this.useArtifactID);
        this.spdxDoc.createLifecycleScopedRelationship(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(dependencyPackage.getId() + parentPackage.getId() + relType)).setRelationshipType(relType).setCompleteness(RelationshipCompleteness.COMPLETE).setFrom((Element)((SpdxPackage)parentPackage)).addTo(dependencyPackage).setScope(this.scopeToLifecycleScope(scope)).setComment("Relationship created based on Maven POM information").build();
        LOG.debug("Added relationship of type {} for {}", (Object)relType, (Object)dependencyPackage.getName());
        if (this.includeTransitiveDependencies) {
            this.addMavenDependencies(mavenProjectBuilder, session, mavenProject, dependencyNode, (CoreModelObject)dependencyPackage);
        }
    }

    private RelationshipType scopeToRelationshipType(String scope, boolean optional) {
        if (scope == null) {
            return RelationshipType.OTHER;
        }
        if (optional) {
            return RelationshipType.HAS_OPTIONAL_COMPONENT;
        }
        if (scope.equals("compile") || scope.equals("runtime")) {
            return RelationshipType.HAS_DYNAMIC_LINK;
        }
        if (scope.equals("test")) {
            return RelationshipType.DEPENDS_ON;
        }
        return RelationshipType.OTHER;
    }

    private LifecycleScopeType scopeToLifecycleScope(String scope) {
        if (scope == null) {
            return LifecycleScopeType.OTHER;
        }
        if (scope.equals("compile") || scope.equals("runtime")) {
            return LifecycleScopeType.RUNTIME;
        }
        if (scope.equals("test")) {
            return LifecycleScopeType.TEST;
        }
        return LifecycleScopeType.OTHER;
    }

    private SpdxPackage createSpdxPackage(MavenProject project, boolean useArtifactID) throws SpdxCollectionException, NoSuchAlgorithmException, LicenseMapperException, InvalidSPDXAnalysisException {
        SpdxDefaultFileInformation fileInfo = new SpdxDefaultFileInformation();
        Object packageName = project.getName();
        if (packageName == null || ((String)packageName).isEmpty() || useArtifactID) {
            packageName = project.getGroupId() + ":" + project.getArtifactId();
        }
        List contributors = project.getContributors();
        ArrayList<String> fileContributorList = new ArrayList<String>();
        if (contributors != null) {
            for (Contributor contributor : contributors) {
                fileContributorList.add(contributor.getName());
            }
        }
        String copyright = "UNSPECIFIED";
        String notice = "UNSPECIFIED";
        String downloadLocation = "NOASSERTION";
        Optional<AnyLicenseInfo> declaredLicenseOverwrite = this.applyLicenseOverwrites(project, "declared");
        AnyLicenseInfo originalDeclaredLicense = this.mavenLicensesToSpdxLicense(project.getLicenses());
        AnyLicenseInfo declaredLicense = declaredLicenseOverwrite.orElse(originalDeclaredLicense);
        fileInfo.setComment("");
        Optional<AnyLicenseInfo> concludedLicenseOverwrite = this.applyLicenseOverwrites(project, "concluded");
        NoAssertionLicense originalConcludedLicense = new NoAssertionLicense();
        AnyLicenseInfo concludedLicense = concludedLicenseOverwrite.orElse((AnyLicenseInfo)originalConcludedLicense);
        fileInfo.setConcludedLicense(concludedLicense.toString());
        fileInfo.setContributors(fileContributorList.toArray(new String[0]));
        fileInfo.setCopyright(copyright);
        fileInfo.setDeclaredLicense(declaredLicense.toString());
        ArrayList<CallSite> comment = new ArrayList<CallSite>();
        if (declaredLicenseOverwrite.isPresent()) {
            comment.add((CallSite)((Object)("Declared license has been overwritten, original value: " + originalDeclaredLicense)));
        }
        if (concludedLicenseOverwrite.isPresent()) {
            comment.add((CallSite)((Object)("Concluded license has been overwritten, original value: " + (AnyLicenseInfo)originalConcludedLicense)));
        }
        fileInfo.setLicenseComment(String.join((CharSequence)"\n", comment));
        fileInfo.setNotice(notice);
        SpdxPackage retval = this.spdxDoc.createSpdxPackage(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion())).setName((String)packageName).setCopyrightText(copyright).setDownloadLocation(downloadLocation).addAllExternalIdentifier(SpdxExternalIdBuilder.getDefaultExternalIdentifiers(this.spdxDoc, this.generatePurls, project)).build();
        if (this.generatePurls) {
            retval.setPackageUrl(SpdxExternalRefBuilder.generatePurl(project));
        }
        Relationship.RelationshipBuilder declaredLicenseRelationship = this.spdxDoc.createRelationship(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(retval.getId() + declaredLicense.getId() + RelationshipType.HAS_DECLARED_LICENSE)).setFrom((Element)retval).addTo((Element)declaredLicense).setRelationshipType(RelationshipType.HAS_DECLARED_LICENSE);
        if (declaredLicenseOverwrite.isPresent()) {
            declaredLicenseRelationship.setComment("Declared license has been overwritten, original value: " + originalDeclaredLicense);
        }
        declaredLicenseRelationship.build();
        Relationship.RelationshipBuilder concludedLicenseRelationship = this.spdxDoc.createRelationship(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(retval.getId() + "NOASSERTION" + RelationshipType.HAS_CONCLUDED_LICENSE)).setFrom((Element)retval).addTo((Element)concludedLicense).setRelationshipType(RelationshipType.HAS_CONCLUDED_LICENSE);
        if (concludedLicenseOverwrite.isPresent()) {
            concludedLicenseRelationship.setComment("Concluded license has been overwritten, original value: " + (AnyLicenseInfo)originalConcludedLicense);
        }
        concludedLicenseRelationship.build();
        if (project.getVersion() != null) {
            retval.setPackageVersion(project.getVersion());
        }
        if (project.getDescription() != null) {
            retval.setDescription(project.getDescription());
            retval.setSummary(project.getDescription());
        }
        if (project.getOrganization() != null) {
            retval.getOriginatedBys().add(this.spdxDoc.createOrganization(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId("ORGANIZATION: " + project.getOrganization().getName())).setName(project.getOrganization().getName()).build());
        }
        if (project.getUrl() != null) {
            try {
                retval.setHomePage(project.getUrl());
            }
            catch (InvalidSPDXAnalysisException e) {
                LOG.warn("Invalid homepage for dependency {}: {}", (Object)project.getArtifactId(), (Object)project.getUrl());
            }
        }
        return retval;
    }

    private Element createSpdxPackage(Artifact artifact, ProjectBuilder mavenProjectBuilder, MavenSession session, MavenProject mavenProject, boolean useArtifactID) throws LicenseMapperException, InvalidSPDXAnalysisException {
        LOG.debug("Creating SPDX package for artifact {}", (Object)artifact.getArtifactId());
        if (artifact.getFile() == null) {
            LOG.debug("Artifact file is null");
        } else {
            LOG.debug("Artifact file name = {}", (Object)artifact.getFile().getName());
        }
        File spdxFile = null;
        if (artifact.getFile() != null) {
            spdxFile = this.artifactFileToSpdxFile(artifact.getFile(), SpdxCoreConstants.SpdxMajorVersion.VERSION_3);
        }
        Object retval = null;
        if (spdxFile != null && spdxFile.exists()) {
            LOG.debug("Dependency {}Looking for SPDX file {}", (Object)artifact.getArtifactId(), (Object)spdxFile.getAbsolutePath());
            try {
                LOG.debug("Dependency {}Dependency information collected from SPDX spec version 3 file {}", (Object)artifact.getArtifactId(), (Object)spdxFile.getAbsolutePath());
                org.spdx.library.model.v3_0_1.core.SpdxDocument externalSpdxDoc = this.spdxDocumentFromFile(spdxFile.getPath());
                retval = this.createExternalRefs ? this.createExternalSpdxPackage(externalSpdxDoc, spdxFile, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()) : this.copyPackageInfoFromExternalDoc(externalSpdxDoc, artifact.getArtifactId());
            }
            catch (IOException e) {
                LOG.warn("IO error reading SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (SpdxInvalidIdException e) {
                LOG.warn("Invalid SPDX ID exception reading SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (InvalidSPDXAnalysisException e) {
                LOG.warn("Invalid SPDX analysis exception reading SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (SpdxCollectionException e) {
                LOG.warn("Unable to create file checksum for external SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (Exception e) {
                LOG.warn("Unknown error processing SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
        }
        if (retval != null) {
            return retval;
        }
        spdxFile = this.artifactFileToSpdxFile(artifact.getFile(), SpdxCoreConstants.SpdxMajorVersion.VERSION_2);
        if (spdxFile != null && spdxFile.exists()) {
            LOG.debug("Dependency {}Looking for SPDX spec version 2 file {}", (Object)artifact.getArtifactId(), (Object)spdxFile.getAbsolutePath());
            try {
                LOG.debug("Dependency {}Dependency information collected from SPDX spec version 2 file {}", (Object)artifact.getArtifactId(), (Object)spdxFile.getAbsolutePath());
                retval = this.copyPackageInfoFromV2File(spdxFile.getPath(), artifact.getArtifactId());
            }
            catch (IOException e) {
                LOG.warn("IO error reading SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (SpdxInvalidIdException e) {
                LOG.warn("Invalid SPDX ID exception reading SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (InvalidSPDXAnalysisException e) {
                LOG.warn("Invalid SPDX analysis exception reading SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
            catch (Exception e) {
                LOG.warn("Unknown error processing SPDX document for dependency artifact ID {}:{}.  Using POM file information for creating SPDX package data.", (Object)artifact.getArtifactId(), (Object)e.getMessage());
            }
        }
        if (retval != null) {
            return retval;
        }
        try {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
            request.setProcessPlugins(false);
            request.setRemoteRepositories(mavenProject.getRemoteArtifactRepositories());
            for (ArtifactRepository ar : request.getRemoteRepositories()) {
                LOG.debug("request Remote repository ID: {}", (Object)ar.getId());
            }
            for (ArtifactRepository ar : mavenProject.getRemoteArtifactRepositories()) {
                LOG.debug("Project Remote repository ID: {}", (Object)ar.getId());
            }
            ProjectBuildingResult build = mavenProjectBuilder.build(artifact, (ProjectBuildingRequest)request);
            MavenProject depProject = build.getProject();
            LOG.debug("Dependency {}Collecting information from project metadata for {}", (Object)artifact.getArtifactId(), (Object)depProject.getArtifactId());
            retval = this.createSpdxPackage(depProject, useArtifactID);
        }
        catch (SpdxCollectionException e) {
            LOG.error("SPDX File Collection Error creating SPDX package for dependency artifact ID {}:{}", (Object)artifact.getArtifactId(), (Object)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Verification Code Error creating SPDX package for dependency artifact ID {}:{}", (Object)artifact.getArtifactId(), (Object)e.getMessage());
        }
        catch (ProjectBuildingException e) {
            LOG.error("Maven Project Build Error creating SPDX package for dependency artifact ID {}:{}", (Object)artifact.getArtifactId(), (Object)e.getMessage());
        }
        if (retval != null) {
            return retval;
        }
        LOG.warn("Error creating SPDX package for dependency artifact ID {}.  A minimal SPDX package will be created.", (Object)artifact.getArtifactId());
        LOG.debug("Dependency {}Using only artifact information to create dependent package", (Object)artifact.getArtifactId());
        SpdxPackage pkg = this.spdxDoc.createSpdxPackage(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion())).setName(artifact.getArtifactId()).setComment("This package was created for a Maven dependency.  No SPDX or license information could be found in the Maven POM file.").setPackageVersion(artifact.getBaseVersion()).addAllExternalIdentifier(SpdxExternalIdBuilder.getDefaultExternalIdentifiers(this.spdxDoc, this.generatePurls, mavenProject)).build();
        this.spdxDoc.createRelationship(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(pkg.getId() + "NOASSERTION" + RelationshipType.HAS_DECLARED_LICENSE)).setFrom((Element)pkg).addTo((Element)new NoAssertionLicense()).setRelationshipType(RelationshipType.HAS_DECLARED_LICENSE).build();
        this.spdxDoc.createRelationship(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(pkg.getId() + "NOASSERTION" + RelationshipType.HAS_CONCLUDED_LICENSE)).setFrom((Element)pkg).addTo((Element)new NoAssertionLicense()).setRelationshipType(RelationshipType.HAS_CONCLUDED_LICENSE).build();
        return pkg;
    }

    private Element copyPackageInfoFromV2File(String path, String artifactId) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        Optional versionInfo;
        Optional validUntil;
        Optional supplier;
        Optional summary;
        Optional sourceInfo;
        Optional releaseDate;
        Optional primaryPurpose;
        Optional pkgFileName;
        Optional originator;
        Optional homePage;
        Optional licenseListVersion;
        SpdxDocument v2Doc = SpdxV2DependencyBuilder.spdxDocumentFromFile(path);
        org.spdx.library.model.v2.SpdxPackage source = SpdxV2DependencyBuilder.findMatchingDescribedPackage(v2Doc, artifactId);
        Optional downloadLocation = source.getDownloadLocation();
        Optional name = source.getName();
        SpdxPackage dest = this.spdxDoc.createSpdxPackage(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(path + artifactId)).setName(name.orElse("NONE")).setCopyrightText(source.getCopyrightText() != null ? source.getCopyrightText() : "NOASSERTION").setDownloadLocation(downloadLocation.orElse("NOASSERTION")).build();
        Optional pvc = source.getPackageVerificationCode();
        if (pvc.isPresent()) {
            dest.getVerifiedUsings().add(dest.createPackageVerificationCode(dest.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setAlgorithm(HashAlgorithm.SHA1).setHashValue(((SpdxPackageVerificationCode)pvc.get()).getValue()).addAllPackageVerificationCodeExcludedFile(((SpdxPackageVerificationCode)pvc.get()).getExcludedFileNames()).build());
        }
        for (ExternalRef fromRef : source.getExternalRefs()) {
            Spdx2to3Converter.addExternalRefToArtifact((ExternalRef)fromRef, (SoftwareArtifact)dest, (IModelStore)dest.getModelStore());
        }
        for (Annotation fromAnnotation : source.getAnnotations()) {
            CreationInfo creationInfo = new CreationInfo.CreationInfoBuilder(dest.getModelStore(), dest.getModelStore().getNextId(IModelStore.IdType.Anonymous), null).setCreated(fromAnnotation.getAnnotationDate()).setSpecVersion("3.0.1").build();
            creationInfo.getCreatedBys().add(Spdx2to3Converter.stringToAgent((String)fromAnnotation.getAnnotator(), (CreationInfo)creationInfo));
            AnnotationType annotationType = (AnnotationType)Spdx2to3Converter.ANNOTATION_TYPE_MAP.get(fromAnnotation.getAnnotationType());
            dest.createAnnotation(dest.getIdPrefix() + dest.getId() + annotationType + fromAnnotation.getComment()).setAnnotationType(annotationType).setStatement(fromAnnotation.getComment()).setSubject((Element)dest).setCreationInfo(creationInfo).build();
        }
        org.spdx.library.model.v2.license.AnyLicenseInfo v2Declared = source.getLicenseDeclared();
        String declaredExpression = v2Declared == null ? "NOASSERTION" : v2Declared.toString();
        LicenseExpression declaredLicense = dest.createLicenseExpression(dest.getIdPrefix() + IdGenerator.getIdGenerator().generateId(path + artifactId + "DECLARED" + declaredExpression)).setLicenseExpression(declaredExpression).build();
        Optional optional = licenseListVersion = v2Doc.getCreationInfo() == null ? Optional.empty() : v2Doc.getCreationInfo().getLicenseListVersion();
        if (licenseListVersion.isPresent()) {
            declaredLicense.setLicenseListVersion((String)licenseListVersion.get());
        }
        dest.createRelationship(dest.getIdPrefix() + IdGenerator.getIdGenerator().generateId(dest.getId() + declaredLicense.getId() + RelationshipType.HAS_DECLARED_LICENSE)).setRelationshipType(RelationshipType.HAS_DECLARED_LICENSE).setFrom((Element)dest).addTo((Element)declaredLicense).build();
        String concludedExpression = source.getLicenseConcluded().toString();
        LicenseExpression concludedLicense = dest.createLicenseExpression(dest.getIdPrefix() + IdGenerator.getIdGenerator().generateId(path + artifactId + "DECLARED" + concludedExpression)).setLicenseExpression(concludedExpression).build();
        if (licenseListVersion.isPresent()) {
            concludedLicense.setLicenseListVersion((String)licenseListVersion.get());
        }
        dest.createRelationship(dest.getIdPrefix() + IdGenerator.getIdGenerator().generateId(dest.getId() + concludedLicense.getId() + RelationshipType.HAS_CONCLUDED_LICENSE)).setRelationshipType(RelationshipType.HAS_CONCLUDED_LICENSE).setFrom((Element)dest).addTo((Element)concludedLicense).build();
        Optional builtDate = source.getBuiltDate();
        if (builtDate.isPresent()) {
            dest.setBuiltTime((String)builtDate.get());
        }
        Optional comment = source.getComment();
        Optional licenseComments = source.getLicenseComments();
        if (comment.isPresent()) {
            if (licenseComments.isPresent()) {
                dest.setComment((String)comment.get() + "; License Comments: " + (String)licenseComments.get());
            } else {
                dest.setComment((String)comment.get());
            }
        } else if (licenseComments.isPresent()) {
            dest.setComment("License Comments: " + (String)licenseComments.get());
        }
        Optional desc = source.getDescription();
        if (desc.isPresent()) {
            dest.setDescription((String)desc.get());
        }
        if ((homePage = source.getHomepage()).isPresent()) {
            dest.setHomePage((String)homePage.get());
        }
        if ((originator = source.getOriginator()).isPresent()) {
            dest.getOriginatedBys().add(Spdx2to3Converter.stringToAgent((String)((String)originator.get()), (CreationInfo)dest.getCreationInfo()));
        }
        if ((pkgFileName = source.getPackageFileName()).isPresent()) {
            SpdxFile packageFile = dest.createSpdxFile(dest.getIdPrefix() + IdGenerator.getIdGenerator().generateId(path + artifactId + (String)pkgFileName.get())).setName((String)pkgFileName.get()).build();
            for (org.spdx.library.model.v2.Checksum fromChecksum : source.getChecksums()) {
                packageFile.getVerifiedUsings().add(dest.createHash(dest.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setAlgorithm((HashAlgorithm)Spdx2to3Converter.HASH_ALGORITH_MAP.get(fromChecksum.getAlgorithm())).setHashValue(fromChecksum.getValue()).build());
            }
            dest.createRelationship(dest.getIdPrefix() + IdGenerator.getIdGenerator().generateId(dest.getId() + packageFile.getId() + RelationshipType.HAS_DISTRIBUTION_ARTIFACT)).setFrom((Element)dest).addTo((Element)packageFile).setRelationshipType(RelationshipType.HAS_DISTRIBUTION_ARTIFACT).setCompleteness(RelationshipCompleteness.COMPLETE).build();
        }
        if ((primaryPurpose = source.getPrimaryPurpose()).isPresent()) {
            dest.setPrimaryPurpose((SoftwarePurpose)Spdx2to3Converter.PURPOSE_MAP.get(primaryPurpose.get()));
        }
        if ((releaseDate = source.getReleaseDate()).isPresent()) {
            dest.setReleaseTime((String)releaseDate.get());
        }
        if ((sourceInfo = source.getSourceInfo()).isPresent()) {
            dest.setSourceInfo((String)sourceInfo.get());
        }
        if ((summary = source.getSummary()).isPresent()) {
            dest.setSummary((String)summary.get());
        }
        if ((supplier = source.getSupplier()).isPresent()) {
            dest.setSuppliedBy(Spdx2to3Converter.stringToAgent((String)((String)supplier.get()), (CreationInfo)dest.getCreationInfo()));
        }
        if ((validUntil = source.getValidUntilDate()).isPresent()) {
            dest.setValidUntilTime((String)validUntil.get());
        }
        if ((versionInfo = source.getVersionInfo()).isPresent()) {
            dest.setPackageVersion((String)versionInfo.get());
        }
        return dest;
    }

    @Nullable
    private ExternalElement createExternalSpdxPackage(org.spdx.library.model.v3_0_1.core.SpdxDocument externalSpdxDoc, File spdxFile, String groupId, String artifactId, @Nullable String version) throws InvalidSPDXAnalysisException, SpdxCollectionException {
        SpdxPackage describedPackage = null;
        for (Object root : externalSpdxDoc.getRootElements()) {
            if (root instanceof SpdxPackage) {
                describedPackage = (SpdxPackage)root;
                break;
            }
            if (!(root instanceof Sbom)) continue;
            for (Element sbomRoot : ((Sbom)root).getRootElements()) {
                if (!(sbomRoot instanceof SpdxPackage)) continue;
                describedPackage = (SpdxPackage)sbomRoot;
                break;
            }
            if (describedPackage == null) continue;
            break;
        }
        if (describedPackage == null) {
            return null;
        }
        ExternalElement retval = new ExternalElement(this.spdxDoc.getModelStore(), describedPackage.getObjectUri(), this.spdxDoc.getCopyManager(), true, describedPackage.getIdPrefix());
        for (ExternalMap ext : this.spdxDoc.getSpdxImports()) {
            if (!describedPackage.getObjectUri().equals(ext.getExternalSpdxId())) continue;
            return retval;
        }
        Checksum checksum = AbstractFileCollector.generateSha1(spdxFile);
        HashAlgorithm algorithm = (HashAlgorithm)Spdx2to3Converter.HASH_ALGORITH_MAP.get(ChecksumAlgorithm.valueOf((String)checksum.getAlgorithm()));
        Hash hash = this.spdxDoc.createHash(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setAlgorithm(algorithm).setHashValue(checksum.getValue()).build();
        StringBuilder sb = new StringBuilder(groupId).append(artifactId);
        if (Objects.nonNull(version)) {
            sb.append(version);
        }
        String fullArtifactId = sb.toString();
        SpdxFile fileArtifact = this.spdxDoc.createSpdxFile(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(fullArtifactId)).setName(spdxFile.getName()).setDescription(String.format("SPDX File for %s", fullArtifactId)).addVerifiedUsing((IntegrityMethod)hash).build();
        this.spdxDoc.getSpdxImports().add(this.spdxDoc.createExternalMap(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.Anonymous)).addVerifiedUsing((IntegrityMethod)hash).setExternalSpdxId(describedPackage.getObjectUri()).setDefiningArtifact((org.spdx.library.model.v3_0_1.core.Artifact)fileArtifact).build());
        return retval;
    }

    private org.spdx.library.model.v3_0_1.core.SpdxDocument spdxDocumentFromFile(String path) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        OutputFormat of = OutputFormat.getOutputFormat(null, new File(path));
        if (!SpdxCoreConstants.SpdxMajorVersion.VERSION_3.equals((Object)of.getSpecVersion())) {
            throw new InvalidSPDXAnalysisException(String.format("Unsupported file type for SPDX Version 2 SPDX documents: %s", of.getSpecVersion().toString()));
        }
        JsonLDStore modelStore = new JsonLDStore((IModelStore)new InMemSpdxStore());
        try (FileInputStream inputStream = new FileInputStream(path);){
            CoreModelObject root = modelStore.deSerialize((InputStream)inputStream, false);
            if (root != null) {
                root.setCopyManager(this.spdxDoc.getCopyManager());
                org.spdx.library.model.v3_0_1.core.SpdxDocument spdxDocument = (org.spdx.library.model.v3_0_1.core.SpdxDocument)root;
                return spdxDocument;
            }
            throw new InvalidSPDXAnalysisException(String.format("Could not find an SPDX document for SPDX file name %s", path));
        }
        finally {
            try {
                modelStore.close();
            }
            catch (Exception e) {
                LOG.error("Error closing SPDX model store", (Throwable)e);
            }
        }
    }

    private SpdxPackage copyPackageInfoFromExternalDoc(org.spdx.library.model.v3_0_1.core.SpdxDocument externalSpdxDoc, String artifactId) throws InvalidSPDXAnalysisException {
        Optional versionInfo;
        Optional validUntil;
        Optional supplier;
        Optional summary;
        Optional sourceInfo;
        Optional releaseTime;
        Optional primaryPurpose;
        Optional homePage;
        Optional desc;
        Optional comment;
        SpdxPackage source = this.findMatchingDescribedPackage(externalSpdxDoc, artifactId);
        Optional downloadLocation = source.getDownloadLocation();
        Optional name = source.getName();
        SpdxPackage dest = this.spdxDoc.createSpdxPackage(this.spdxDoc.getIdPrefix() + IdGenerator.getIdGenerator().generateId(externalSpdxDoc.getId() + artifactId)).setName(name.orElse("NONE")).setCopyrightText(source.getCopyrightText().orElse("NOASSERTION")).addAllVerifiedUsing(source.getVerifiedUsings()).setDownloadLocation(downloadLocation.orElse("NOASSERTION")).addAllExternalIdentifier(source.getExternalIdentifiers()).addAllExternalRef(source.getExternalRefs()).addAllOriginatedBy(source.getOriginatedBys()).build();
        List sourceRelationships = SpdxModelFactory.getSpdxObjects((IModelStore)externalSpdxDoc.getModelStore(), (IModelCopyManager)externalSpdxDoc.getCopyManager(), (String)"Core.Relationship", null, null).filter(spdxObj -> {
            try {
                return source.equals((Object)((Relationship)spdxObj).getFrom());
            }
            catch (InvalidSPDXAnalysisException e) {
                LOG.error("Error copying relationships from SPDX file for artifact {}", (Object)artifactId, (Object)e);
                return false;
            }
        }).collect(Collectors.toList());
        for (Relationship rel : sourceRelationships) {
            dest.createRelationship(dest.getIdPrefix() + IdGenerator.getIdGenerator().generateId(dest.getId() + rel.getId())).setFrom((Element)dest).setCompleteness(rel.getCompleteness().orElse(RelationshipCompleteness.NO_ASSERTION)).setRelationshipType(rel.getRelationshipType()).addAllTo(rel.getTos()).build();
        }
        Optional builtTime = source.getBuiltTime();
        if (builtTime.isPresent()) {
            dest.setBuiltTime((String)builtTime.get());
        }
        if ((comment = source.getComment()).isPresent()) {
            dest.setComment((String)comment.get());
        }
        if ((desc = source.getDescription()).isPresent()) {
            dest.setDescription((String)desc.get());
        }
        if ((homePage = source.getHomePage()).isPresent()) {
            dest.setHomePage((String)homePage.get());
        }
        if ((primaryPurpose = source.getPrimaryPurpose()).isPresent()) {
            dest.setPrimaryPurpose((SoftwarePurpose)primaryPurpose.get());
        }
        if ((releaseTime = source.getReleaseTime()).isPresent()) {
            dest.setReleaseTime((String)releaseTime.get());
        }
        if ((sourceInfo = source.getSourceInfo()).isPresent()) {
            dest.setSourceInfo((String)sourceInfo.get());
        }
        if ((summary = source.getSummary()).isPresent()) {
            dest.setSummary((String)summary.get());
        }
        if ((supplier = source.getSuppliedBy()).isPresent()) {
            dest.setSuppliedBy((Agent)supplier.get());
        }
        if ((validUntil = source.getValidUntilTime()).isPresent()) {
            dest.setValidUntilTime((String)validUntil.get());
        }
        if ((versionInfo = source.getPackageVersion()).isPresent()) {
            dest.setPackageVersion((String)versionInfo.get());
        }
        return dest;
    }

    private SpdxPackage findMatchingDescribedPackage(org.spdx.library.model.v3_0_1.core.SpdxDocument externalSpdxDoc, String artifactId) throws InvalidSPDXAnalysisException {
        Sbom firstFoundSbom = null;
        SpdxPackage firstFoundPackage = null;
        for (Element root : externalSpdxDoc.getRootElements()) {
            if (root instanceof SpdxPackage) {
                if (root.getName().isPresent() && ((String)root.getName().get()).equals(artifactId)) {
                    return (SpdxPackage)root;
                }
                if (firstFoundPackage != null) continue;
                firstFoundPackage = (SpdxPackage)root;
                continue;
            }
            if (!(root instanceof Sbom)) continue;
            for (Element sRoot : ((Sbom)root).getRootElements()) {
                if (!(sRoot instanceof SpdxPackage) || !sRoot.getName().isPresent() || !((String)sRoot.getName().get()).equals(artifactId)) continue;
                return (SpdxPackage)sRoot;
            }
            if (firstFoundSbom != null) continue;
            firstFoundSbom = (Sbom)root;
        }
        if (firstFoundPackage != null) {
            LOG.warn("Could not find matching artifact ID in SPDX file for {}.  Using the first package found in SPDX file.", (Object)artifactId);
            return firstFoundPackage;
        }
        if (firstFoundSbom != null) {
            for (Element sRoot : firstFoundSbom.getRootElements()) {
                if (!(sRoot instanceof SpdxPackage)) continue;
                LOG.warn("Could not find matching artifact ID in SPDX file for {}.  Using the first package found in Sbom.", (Object)artifactId);
                return (SpdxPackage)sRoot;
            }
        }
        throw new InvalidSPDXAnalysisException("SPDX document does not contain any described items.");
    }

    private AnyLicenseInfo mavenLicensesToSpdxLicense(List<License> mavenLicenses) throws LicenseMapperException, InvalidSPDXAnalysisException {
        try {
            return this.licenseManager.mavenLicenseListToSpdxLicense(mavenLicenses);
        }
        catch (LicenseManagerException ex) {
            return MavenToSpdxLicenseMapper.getInstance().mavenLicenseListToSpdxV3License(mavenLicenses, (Element)this.spdxDoc);
        }
    }

    public void addLicenseOverwrite(LicenseOverwrite licenseOverwrite, AnyLicenseInfo parsedLicense) {
        this.licenseOverwrites.put(licenseOverwrite, parsedLicense);
    }

    Optional<AnyLicenseInfo> applyLicenseOverwrites(MavenProject mavenProject, String target) {
        return this.licenseOverwrites.entrySet().stream().filter(overwrite -> ((LicenseOverwrite)overwrite.getKey()).appliesTo(mavenProject, target)).reduce((a, b) -> {
            throw new IllegalStateException("multiple matching license overwrites: " + a.getKey() + " vs. " + b.getKey());
        }).map(Map.Entry::getValue);
    }
}

