/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.License;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.ListedLicenses;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.v2.ExternalRef;
import org.spdx.library.model.v2.ReferenceType;
import org.spdx.library.model.v2.Relationship;
import org.spdx.library.model.v2.SpdxCreatorInformation;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxModelFactoryCompatV2;
import org.spdx.library.model.v2.SpdxPackage;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.library.model.v2.enumerations.AnnotationType;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v2.enumerations.Purpose;
import org.spdx.library.model.v2.enumerations.ReferenceCategory;
import org.spdx.library.model.v2.enumerations.RelationshipType;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.referencetype.ListedReferenceTypes;
import org.spdx.maven.Annotation;
import org.spdx.maven.Checksum;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.Packaging;
import org.spdx.maven.utils.AbstractDocumentBuilder;
import org.spdx.maven.utils.IdGenerator;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.SpdxBuilderException;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxExternalRefBuilder;
import org.spdx.maven.utils.SpdxProjectInformation;
import org.spdx.maven.utils.SpdxV2FileCollector;
import org.spdx.maven.utils.SpdxV2LicenseManager;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class SpdxV2DocumentBuilder
extends AbstractDocumentBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SpdxV2DocumentBuilder.class);
    protected SpdxDocument spdxDoc;
    protected SpdxV2LicenseManager licenseManager;
    protected SpdxPackage projectPackage;

    public SpdxV2DocumentBuilder(MavenProject mavenProject, boolean generatePurls, File spdxFile, URI spdxDocumentNamespace, OutputFormat outputFormatEnum) throws SpdxBuilderException, LicenseMapperException {
        super(mavenProject, generatePurls, spdxFile, outputFormatEnum);
        if (spdxDocumentNamespace == null) {
            throw new SpdxBuilderException("Missing namespaceUri");
        }
        try {
            this.modelStore = outputFormatEnum == OutputFormat.RDF_XML ? new RdfStore(spdxDocumentNamespace.toString()) : new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY);
            this.copyManager = new ModelCopyManager();
            this.spdxDoc = SpdxModelFactoryCompatV2.createSpdxDocumentV2((IModelStore)this.modelStore, (String)spdxDocumentNamespace.toString(), (IModelCopyManager)this.copyManager);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error creating SPDX document", e);
        }
        this.licenseManager = new SpdxV2LicenseManager(this.spdxDoc);
    }

    public SpdxDocument getSpdxDoc() {
        return this.spdxDoc;
    }

    @Override
    public void fillSpdxDocumentInformation(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        try {
            if (projectInformation.getDocumentComment() != null && !projectInformation.getDocumentComment().isEmpty()) {
                this.spdxDoc.setComment(projectInformation.getDocumentComment());
            }
            this.fillCreatorInfo(projectInformation);
            SpdxListedLicense dataLicense = LicenseInfoFactory.getListedLicenseByIdCompatV2((String)"CC0-1.0");
            this.spdxDoc.setDataLicense((AnyLicenseInfo)dataLicense);
            if (projectInformation.getDocumentAnnotations() != null && projectInformation.getDocumentAnnotations().length > 0) {
                this.spdxDoc.setAnnotations(this.toSpdxAnnotations(projectInformation.getDocumentAnnotations()));
            }
            this.spdxDoc.setName(projectInformation.getName());
            this.projectPackage = this.createSpdxPackage(projectInformation);
            Relationship documentContainsRelationship = this.spdxDoc.createRelationship((SpdxElement)this.projectPackage, RelationshipType.DESCRIBES, "");
            this.spdxDoc.addRelationship(documentContainsRelationship);
        }
        catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error adding package information to SPDX document", e);
        }
    }

    private Collection<org.spdx.library.model.v2.Annotation> toSpdxAnnotations(Annotation[] annotations) throws MojoExecutionException {
        ArrayList<org.spdx.library.model.v2.Annotation> retval = new ArrayList<org.spdx.library.model.v2.Annotation>();
        for (Annotation annotation : annotations) {
            AnnotationType annotationType = AnnotationType.OTHER;
            try {
                annotationType = AnnotationType.valueOf((String)annotation.getAnnotationType());
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Invalid annotation type " + annotation.getAnnotationType());
            }
            try {
                retval.add(this.spdxDoc.createAnnotation(annotation.getAnnotator(), annotationType, annotation.getAnnotationDate(), annotation.getAnnotationComment()));
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new MojoExecutionException("Error creating annotation.", (Exception)((Object)e));
            }
        }
        return retval;
    }

    private void fillCreatorInfo(SpdxProjectInformation projectInformation) throws InvalidSPDXAnalysisException {
        String[] parameterCreators;
        ArrayList<String> creators = new ArrayList<String>();
        for (String parameterCreator : parameterCreators = projectInformation.getCreators()) {
            String verify = SpdxVerificationHelper.verifyCreator((String)parameterCreator);
            if (verify == null) {
                creators.add(parameterCreator);
                continue;
            }
            LOG.warn("Invalid creator string ( {} ), {} will be skipped.", (Object)verify, (Object)parameterCreator);
        }
        SpdxCreatorInformation spdxCreator = this.spdxDoc.createCreationInfo(creators, projectInformation.getCreated());
        spdxCreator.setComment(projectInformation.getCreatorComment());
        spdxCreator.setLicenseListVersion(ListedLicenses.getListedLicenses().getLicenseListVersion());
        this.spdxDoc.setCreationInfo(spdxCreator);
    }

    private SpdxPackage createSpdxPackage(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        ExternalReference[] externalRefs;
        SpdxPackage pkg;
        String copyrightText = projectInformation.getCopyrightText();
        if (copyrightText == null) {
            copyrightText = "UNSPECIFIED";
        }
        String downloadUrl = null;
        if (SpdxVerificationHelper.isValidUri((String)projectInformation.getDownloadUrl())) {
            downloadUrl = projectInformation.getDownloadUrl();
        } else {
            LOG.warn("Invalid download location in POM file: {}", (Object)projectInformation.getDownloadUrl());
        }
        if (downloadUrl == null) {
            downloadUrl = "UNSPECIFIED";
        }
        try {
            AnyLicenseInfo concludedLicense = LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)projectInformation.getConcludedLicense(), (IModelStore)this.spdxDoc.getModelStore(), (String)this.spdxDoc.getDocumentUri(), (IModelCopyManager)this.spdxDoc.getCopyManager());
            AnyLicenseInfo declaredLicense = LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)projectInformation.getDeclaredLicense(), (IModelStore)this.spdxDoc.getModelStore(), (String)this.spdxDoc.getDocumentUri(), (IModelCopyManager)this.spdxDoc.getCopyManager());
            Packaging packaging = Packaging.valueOfPackaging(this.project.getPackaging());
            Purpose primaryPurpose = packaging != null ? packaging.getV2Purpose() : Purpose.LIBRARY;
            pkg = this.spdxDoc.createPackage(IdGenerator.getIdGenerator().generateId("UNSPECIFIED".equals(downloadUrl) ? projectInformation.getName() : downloadUrl), projectInformation.getName(), concludedLicense, copyrightText, declaredLicense).setDownloadLocation(downloadUrl).setFilesAnalyzed(false).setPrimaryPurpose(primaryPurpose).setExternalRefs(SpdxExternalRefBuilder.getDefaultExternalRefs(this.spdxDoc, this.generatePurls, this.project)).build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error creating initial package", e);
        }
        if (projectInformation.getPackageAnnotations() != null && projectInformation.getPackageAnnotations().length > 0) {
            try {
                pkg.setAnnotations(this.toSpdxAnnotations(projectInformation.getPackageAnnotations()));
            }
            catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
                throw new SpdxBuilderException("Error adding package annotations to SPDX document", e);
            }
        }
        try {
            if (projectInformation.getDescription() != null) {
                pkg.setDescription(projectInformation.getDescription());
            }
            if (projectInformation.getDownloadUrl() != null) {
                pkg.setDownloadLocation(projectInformation.getDownloadUrl());
            }
            if (projectInformation.getPackageArchiveFileName() != null) {
                pkg.setPackageFileName(projectInformation.getPackageArchiveFileName());
            }
            if (projectInformation.getHomePage() != null) {
                try {
                    pkg.setHomepage(projectInformation.getHomePage());
                }
                catch (InvalidSPDXAnalysisException ex) {
                    LOG.warn("Invalid URL in project POM file: {}", (Object)projectInformation.getHomePage());
                }
            }
            if (projectInformation.getSourceInfo() != null) {
                pkg.setSourceInfo(projectInformation.getSourceInfo());
            }
            if (projectInformation.getLicenseComment() != null) {
                pkg.setLicenseComments(projectInformation.getLicenseComment());
            }
            if (projectInformation.getOriginator() != null) {
                pkg.setOriginator(projectInformation.getOriginator());
            }
            if (projectInformation.getShortDescription() != null) {
                pkg.setSummary(projectInformation.getShortDescription());
            }
            if (projectInformation.getSupplier() != null) {
                pkg.setSupplier(projectInformation.getSupplier());
            }
            if (projectInformation.getVersionInfo() != null) {
                pkg.setVersionInfo(projectInformation.getVersionInfo());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error adding package properties", e);
        }
        if (projectInformation.getChecksums() != null) {
            try {
                for (Checksum checksum : projectInformation.getChecksums()) {
                    try {
                        ChecksumAlgorithm algorithm = ChecksumAlgorithm.valueOf((String)checksum.getAlgorithm());
                        pkg.getChecksums().add(this.spdxDoc.createChecksum(algorithm, checksum.getValue()));
                    }
                    catch (IllegalArgumentException | NullPointerException e1) {
                        LOG.error("Invalid checksum algorithm {}", (Object)checksum.getAlgorithm());
                    }
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid checksum provided", e);
            }
        }
        if ((externalRefs = projectInformation.getExternalRefs()) != null) {
            for (ExternalReference externalRef : externalRefs) {
                try {
                    pkg.getExternalRefs().add(this.convertExternalRef(externalRef));
                }
                catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
                    throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid external refs provided", e);
                }
            }
        }
        return pkg;
    }

    @Override
    public void collectSpdxFileInformation(List<FileSet> sources, String baseDir, SpdxDefaultFileInformation defaultFileInformation, HashMap<String, SpdxDefaultFileInformation> pathSpecificInformation, Set<String> checksumAlgorithms) throws SpdxBuilderException {
        SpdxV2FileCollector fileCollector = new SpdxV2FileCollector();
        try {
            fileCollector.collectFiles(sources, baseDir, defaultFileInformation, pathSpecificInformation, this.projectPackage, RelationshipType.GENERATES, this.spdxDoc, checksumAlgorithms);
            this.projectPackage.getFiles().addAll(fileCollector.getFiles());
            this.projectPackage.getLicenseInfoFromFiles().addAll(fileCollector.getLicenseInfoFromFiles());
        }
        catch (InvalidSPDXAnalysisException | SpdxCollectionException e) {
            throw new SpdxBuilderException("Error collecting SPDX file information", e);
        }
        try {
            String spdxFileName = this.spdxFile.getPath().replace("\\", "/");
            this.projectPackage.setPackageVerificationCode(fileCollector.getVerificationCode(spdxFileName, this.spdxDoc));
            this.projectPackage.setFilesAnalyzed(Boolean.valueOf(true));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SpdxBuilderException("Unable to calculate verification code", e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Unable to update verification code", e);
        }
    }

    @Override
    public void saveSpdxDocumentToFile() throws SpdxBuilderException {
        try (FileOutputStream spdxOut = new FileOutputStream(this.spdxFile);){
            this.modelStore.serialize((OutputStream)spdxOut);
        }
        catch (FileNotFoundException e) {
            throw new SpdxBuilderException("Error saving SPDX data to file", e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxBuilderException("Error collecting SPDX file data", e);
        }
        catch (IOException e) {
            throw new SpdxBuilderException("I/O Error saving SPDX data to file", e);
        }
    }

    @Override
    public void addNonStandardLicenses(NonStandardLicense[] nonStandardLicenses) throws SpdxBuilderException {
        if (nonStandardLicenses != null) {
            for (NonStandardLicense nonStandardLicense : nonStandardLicenses) {
                try {
                    this.licenseManager.addExtractedLicense(nonStandardLicense);
                }
                catch (LicenseManagerException e) {
                    throw new SpdxBuilderException("Error adding non standard license", e);
                }
            }
        }
    }

    public ExternalRef convertExternalRef(ExternalReference externalReference) throws MojoExecutionException {
        ReferenceType refType;
        ReferenceCategory cat;
        try {
            cat = ReferenceCategory.valueOf((String)externalReference.getCategory().replaceAll("-", "_"));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("External reference category " + externalReference.getCategory() + " is not recognized as a valid, standard category.");
        }
        try {
            refType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(externalReference.getType());
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new MojoExecutionException("Error getting listed reference type for " + externalReference.getType(), (Exception)((Object)e));
        }
        if (refType == null) {
            throw new MojoExecutionException("Listed reference type not found for " + externalReference.getType());
        }
        try {
            return this.spdxDoc.createExternalRef(cat, refType, externalReference.getLocator(), externalReference.getComment());
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new MojoExecutionException("Error creating External Reference", (Exception)((Object)e));
        }
    }

    @Override
    public CoreModelObject getProjectPackage() {
        return this.projectPackage;
    }

    @Override
    public String mavenLicenseListToSpdxLicenseExpression(List<License> mavenLicenses) throws LicenseManagerException {
        return this.licenseManager.mavenLicenseListToSpdxLicense(mavenLicenses).toString();
    }

    @Override
    public List<String> verify() {
        return this.spdxDoc.verify();
    }

    public SpdxV2LicenseManager getLicenseManager() {
        return this.licenseManager;
    }
}

