/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxCoreConstants;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.utils.LicenseMapperException;

public abstract class AbstractDependencyBuilder {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractDependencyBuilder.class);
    protected boolean createExternalRefs;
    protected boolean generatePurls;
    protected boolean useArtifactID;
    protected boolean includeTransitiveDependencies;
    private final HashSet<String> usedDependencies = new HashSet();
    DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public AbstractDependencyBuilder(boolean createExternalRefs, boolean generatePurls, boolean useArtifactID, boolean includeTransitiveDependencies) {
        this.createExternalRefs = createExternalRefs;
        this.generatePurls = generatePurls;
        this.useArtifactID = useArtifactID;
        this.includeTransitiveDependencies = includeTransitiveDependencies;
    }

    public void addMavenDependencies(ProjectBuilder mavenProjectBuilder, MavenSession session, MavenProject mavenProject, DependencyNode node, CoreModelObject pkg) throws LicenseMapperException, InvalidSPDXAnalysisException {
        List children = node.getChildren();
        this.logDependencies(children);
        String name = "";
        for (DependencyNode childNode : children) {
            name = String.format("%s:%s:%s", childNode.getArtifact().getGroupId(), childNode.getArtifact().getArtifactId(), childNode.getArtifact().getVersion());
            if (this.usedDependencies.add(name)) {
                this.addMavenDependency(pkg, childNode, mavenProjectBuilder, session, mavenProject);
                continue;
            }
            LOG.info("Duplicate dependency occurred for " + name);
        }
    }

    abstract void addMavenDependency(CoreModelObject var1, DependencyNode var2, ProjectBuilder var3, MavenSession var4, MavenProject var5) throws LicenseMapperException, InvalidSPDXAnalysisException;

    @Nullable
    protected File artifactFileToSpdxFile(@Nullable File file, @Nullable SpdxCoreConstants.SpdxMajorVersion versionFilter) {
        if (Objects.isNull(file)) {
            return null;
        }
        for (OutputFormat of : OutputFormat.values()) {
            File retval;
            if (versionFilter != null && !versionFilter.equals((Object)of.getSpecVersion()) || !(retval = this.getFileWithDifferentType(file, of.getFileType())).exists()) continue;
            return retval;
        }
        return null;
    }

    private File getFileWithDifferentType(File file, String type) {
        Object filePath = file.getAbsolutePath();
        int indexOfDot = ((String)filePath).lastIndexOf(46);
        if (indexOfDot > 0) {
            filePath = ((String)filePath).substring(0, indexOfDot + 1);
        }
        filePath = (String)filePath + type;
        return new File((String)filePath);
    }

    private void logDependencies(List<DependencyNode> dependencies) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Dependencies:");
        if (dependencies == null) {
            LOG.debug("\tNull dependencies");
            return;
        }
        if (dependencies.isEmpty()) {
            LOG.debug("\tZero dependencies");
            return;
        }
        for (DependencyNode node : dependencies) {
            Artifact dependency = node.getArtifact();
            String filePath = dependency.getFile() != null ? dependency.getFile().getAbsolutePath() : "[NONE]";
            String scope = dependency.getScope() != null ? dependency.getScope() : "[NONE]";
            LOG.debug("ArtifactId: {}, file path: {}, Scope: {}", new Object[]{dependency.getArtifactId(), filePath, scope});
        }
    }

    protected String fixExternalRefId(String externalRefId) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < externalRefId.length(); ++i) {
            if (this.validExternalRefIdChar(externalRefId.charAt(i))) {
                sb.append(externalRefId.charAt(i));
                continue;
            }
            sb.append("-");
        }
        return sb.toString();
    }

    private boolean validExternalRefIdChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '-';
    }
}

