/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import org.apache.maven.project.MavenProject;

public class LicenseOverwrite {
    private String target;
    private String groupId;
    private String artifactId;
    private String version;
    private String licenseString;

    public String getTarget() {
        return this.target;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public void setTarget(String target) throws IllegalArgumentException {
        if (!(target.equals("both") || target.equals("concluded") || target.equals("declared"))) {
            throw new IllegalArgumentException("license overwrite target is none of: both, concluded, declared");
        }
        this.target = target;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    public boolean appliesTo(MavenProject mavenProject, String target) {
        if (!target.equals("concluded") && !target.equals("declared")) {
            throw new IllegalArgumentException("license overwrite target is none of: concluded, declared");
        }
        if (!mavenProject.getGroupId().equals(this.groupId)) {
            return false;
        }
        if (!mavenProject.getArtifactId().equals(this.artifactId)) {
            return false;
        }
        if (this.version != null && !mavenProject.getVersion().equals(this.version)) {
            return false;
        }
        return "both".equals(this.target) || target.equals(this.target);
    }

    public String toString() {
        return "LicenseOverwrite{target=" + this.target + ", groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", licenseString=" + this.licenseString + "}";
    }
}

