/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.License;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.DefaultStoreNotInitializedException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.model.v2.license.InvalidLicenseStringException;
import org.spdx.library.model.v3_0_1.core.SpdxDocument;
import org.spdx.library.model.v3_0_1.expandedlicensing.CustomLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.NoAssertionLicense;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.MavenToSpdxLicenseMapper;
import org.spdx.storage.IModelStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseModelStore;

public class SpdxV3LicenseManager {
    private static final Logger LOG = LoggerFactory.getLogger(SpdxV3LicenseManager.class);
    SpdxDocument spdxDoc;
    Map<String, String> urlStringToSpdxLicenseId = new HashMap<String, String>();
    Map<String, CustomLicense> extractedLicenses = new HashMap<String, CustomLicense>();

    public SpdxV3LicenseManager(SpdxDocument spdxDoc) throws LicenseMapperException {
        this.spdxDoc = spdxDoc;
        this.initializeUrlMap();
    }

    private void initializeUrlMap() throws LicenseMapperException {
        this.urlStringToSpdxLicenseId.putAll(MavenToSpdxLicenseMapper.getInstance().getMap());
    }

    public void addExtractedLicense(NonStandardLicense license) throws LicenseManagerException {
        CustomLicense spdxLicense;
        try {
            spdxLicense = this.spdxDoc.createCustomLicense(this.spdxDoc.getIdPrefix() + license.getLicenseId()).setLicenseText(license.getExtractedText()).setName(license.getName()).setComment(license.getComment()).build();
            for (String crossRef : license.getCrossReference()) {
                spdxLicense.getSeeAlsos().add(crossRef);
            }
            this.spdxDoc.getElements().add(spdxLicense);
        }
        catch (InvalidSPDXAnalysisException e) {
            String licenseId = license.getLicenseId();
            if (licenseId == null) {
                licenseId = "[NullLicenseId]";
            }
            throw new LicenseManagerException("Unable to add non listed license " + licenseId, e);
        }
        String[] urls = license.getCrossReference();
        if (urls != null) {
            for (String url : urls) {
                if (this.urlStringToSpdxLicenseId.containsKey(url)) {
                    String oldLicenseId = this.urlStringToSpdxLicenseId.get(url);
                    LOG.warn("Duplicate URL for SPDX extracted license.  Replacing {} with {} for {}", new Object[]{oldLicenseId, license.getLicenseId(), url});
                }
                LOG.debug("Adding URL mapping for non-standard license {}", (Object)license.getLicenseId());
                this.urlStringToSpdxLicenseId.put(url, license.getLicenseId());
            }
        }
        this.extractedLicenses.put(license.getLicenseId(), spdxLicense);
    }

    public AnyLicenseInfo mavenLicenseListToSpdxLicense(List<License> licenseList) throws LicenseManagerException {
        try {
            if (licenseList == null || licenseList.isEmpty()) {
                return new NoAssertionLicense();
            }
            if (licenseList.size() == 1) {
                return this.mavenLicenseToSpdxLicense(licenseList.get(0));
            }
            HashSet<AnyLicenseInfo> spdxLicenses = new HashSet<AnyLicenseInfo>();
            for (License license : licenseList) {
                spdxLicenses.add(this.mavenLicenseToSpdxLicense(license));
            }
            return this.spdxDoc.createConjunctiveLicenseSet(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.Anonymous)).addAllMember(spdxLicenses).build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseManagerException("Error converting Maven license to SPDX license", e);
        }
    }

    public AnyLicenseInfo mavenLicenseToSpdxLicense(License mavenLicense) throws LicenseManagerException {
        if (mavenLicense.getUrl() == null) {
            throw new LicenseManagerException("Can not map maven license " + mavenLicense.getName() + "  No URL exists to provide a mapping");
        }
        String licenseId = this.urlStringToSpdxLicenseId.get(mavenLicense.getUrl().replaceAll("https:", "http:"));
        if (licenseId == null) {
            throw new LicenseManagerException("Can not map maven license " + mavenLicense.getName() + "  No listed or extracted license matches the URL " + mavenLicense.getUrl());
        }
        AnyLicenseInfo retval = (AnyLicenseInfo)this.extractedLicenses.get(licenseId);
        if (retval == null) {
            try {
                retval = LicenseInfoFactory.parseSPDXLicenseString((String)licenseId, (IModelStore)this.spdxDoc.getModelStore(), (String)this.spdxDoc.getIdPrefix(), (IModelCopyManager)this.spdxDoc.getCopyManager(), null);
            }
            catch (InvalidLicenseStringException e) {
                throw new LicenseManagerException("Can not map maven license " + mavenLicense.getName() + "  Invalid listed or extracted license id matching the URL " + mavenLicense.getUrl());
            }
            catch (DefaultStoreNotInitializedException e) {
                throw new LicenseManagerException("Default model store not initialized");
            }
        }
        return retval;
    }

    public License spdxLicenseToMavenLicense(AnyLicenseInfo spdxLicense) throws LicenseManagerException {
        if (spdxLicense instanceof CustomLicense) {
            return this.spdxNonStdLicenseToMavenLicense((CustomLicense)spdxLicense);
        }
        if (spdxLicense instanceof ListedLicense) {
            return this.spdxStdLicenseToMavenLicense((ListedLicense)spdxLicense);
        }
        throw new LicenseManagerException("Can not create a Maven license from this SPDX license type.  Must be an ExtractedLicenseInfo or an SpdxListedLicense ");
    }

    private License spdxStdLicenseToMavenLicense(ListedLicense spdxLicense) throws LicenseManagerException {
        try {
            License retval = new License();
            if (spdxLicense.getName().isPresent() && !((String)spdxLicense.getName().get()).isEmpty()) {
                retval.setName((String)spdxLicense.getName().get());
            } else {
                retval.setName(SpdxListedLicenseModelStore.objectUriToLicenseOrExceptionId((String)spdxLicense.getObjectUri()));
            }
            if (spdxLicense.getComment().isPresent() && !((String)spdxLicense.getComment().get()).isEmpty()) {
                retval.setComments((String)spdxLicense.getComment().get());
            }
            for (String url : spdxLicense.getSeeAlsos()) {
                retval.setUrl(url);
            }
            if (spdxLicense.getSeeAlsos().size() > 1) {
                LOG.warn("SPDX license {} contains multiple URLs.  Only the first URL will be preserved in the Maven license created.", (Object)SpdxListedLicenseModelStore.objectUriToLicenseOrExceptionId((String)spdxLicense.getObjectUri()));
            }
            return retval;
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseManagerException("Error converting SPDX Listed License to Maven license", e);
        }
    }

    private License spdxNonStdLicenseToMavenLicense(CustomLicense spdxLicense) throws LicenseManagerException {
        try {
            License retval = new License();
            int prefixLen = spdxLicense.getIdPrefix() == null ? 0 : spdxLicense.getIdPrefix().length();
            String licenseId = spdxLicense.getObjectUri().substring(prefixLen);
            if (spdxLicense.getName().isPresent() && !((String)spdxLicense.getName().get()).isEmpty()) {
                retval.setName((String)spdxLicense.getName().get());
            } else {
                retval.setName(licenseId);
            }
            if (spdxLicense.getComment().isPresent() && !((String)spdxLicense.getComment().get()).isEmpty()) {
                retval.setComments((String)spdxLicense.getComment().get());
            }
            for (String url : spdxLicense.getSeeAlsos()) {
                retval.setUrl(url);
            }
            if (spdxLicense.getSeeAlsos().size() > 1) {
                LOG.warn("SPDX license {} contains multiple URLs.  Only the first URL will be preserved in the Maven license created.", (Object)licenseId);
            }
            return retval;
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseManagerException("Error converting SPDX non-standard license to Maven license", e);
        }
    }
}

