/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import org.spdx.library.model.v2.enumerations.Purpose;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;

public enum Packaging {
    POM("pom", Purpose.INSTALL, SoftwarePurpose.INSTALL),
    EJB("ejb", Purpose.LIBRARY, SoftwarePurpose.LIBRARY),
    JAR("jar", Purpose.LIBRARY, SoftwarePurpose.LIBRARY),
    MAVEN_PLUGIN("maven-plugin", Purpose.LIBRARY, SoftwarePurpose.LIBRARY),
    WAR("war", Purpose.APPLICATION, SoftwarePurpose.APPLICATION),
    EAR("ear", Purpose.APPLICATION, SoftwarePurpose.APPLICATION),
    RAR("rar", Purpose.OTHER, SoftwarePurpose.ARCHIVE);

    private final String name;
    private final Purpose v2Purpose;
    private final SoftwarePurpose softwarePurpose;

    private Packaging(String name, Purpose v2purpose, SoftwarePurpose v3softwarePurpose) {
        this.name = name;
        this.v2Purpose = v2purpose;
        this.softwarePurpose = v3softwarePurpose;
    }

    public static Packaging valueOfPackaging(String packagingValue) {
        packagingValue = packagingValue.toLowerCase();
        for (Packaging packaging : Packaging.values()) {
            if (!packaging.name.equals(packagingValue)) continue;
            return packaging;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Purpose getV2Purpose() {
        return this.v2Purpose;
    }

    public SoftwarePurpose getSoftwarePurpose() {
        return this.softwarePurpose;
    }
}

