/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.maven.CreateSpdxMojo;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.utils.AbstractDependencyBuilder;
import org.spdx.maven.utils.AbstractDocumentBuilder;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.SpdxV2DependencyBuilder;
import org.spdx.maven.utils.SpdxV2DocumentBuilder;
import org.spdx.maven.utils.SpdxV3DependencyBuilder;
import org.spdx.maven.utils.SpdxV3DocumentBuilder;

@Mojo(name="aggregateSPDX", defaultPhase=LifecyclePhase.VERIFY, requiresOnline=true, threadSafe=true)
public class AggregateSpdxMojo
extends CreateSpdxMojo {
    @Override
    protected void buildSpdxDependencyInformation(AbstractDocumentBuilder builder, OutputFormat outputFormatEnum) throws DependencyGraphBuilderException, LicenseMapperException, InvalidSPDXAnalysisException {
        List projects;
        AbstractDependencyBuilder dependencyBuilder = builder instanceof SpdxV3DocumentBuilder ? new SpdxV3DependencyBuilder((SpdxV3DocumentBuilder)builder, this.createExternalRefs, this.generatePurls, this.useArtifactID, this.includeTransitiveDependencies) : new SpdxV2DependencyBuilder((SpdxV2DocumentBuilder)builder, this.createExternalRefs, this.generatePurls, this.useArtifactID, this.includeTransitiveDependencies);
        if (this.session != null && !(projects = this.session.getAllProjects()).isEmpty()) {
            this.getLog().info((CharSequence)("List of projects that will be aggregated into one file: " + Arrays.toString(projects.toArray())));
            for (MavenProject project : projects) {
                DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                request.setProject(project);
                DependencyNode parentNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)request, null);
                dependencyBuilder.addMavenDependencies(this.mavenProjectBuilder, this.session, project, parentNode, builder.getProjectPackage());
            }
        }
    }
}

