/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.software;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.PositiveIntegerRange;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.software.ContentIdentifier;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.library.model.v3_0_1.software.SpdxFile;
import org.spdx.storage.IModelStore;

public class Snippet
extends SoftwareArtifact {
    public Snippet() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public Snippet(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public Snippet(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected Snippet(SnippetBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setLineRange(builder.lineRange);
        this.setByteRange(builder.byteRange);
        if (Objects.nonNull((Object)builder.snippetFromFile)) {
            this.setSnippetFromFile(builder.snippetFromFile);
        }
    }

    @Override
    public String getType() {
        return "Software.Snippet";
    }

    @Override
    public Snippet setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public Snippet setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    public Optional<PositiveIntegerRange> getLineRange() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_LINE_RANGE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof PositiveIntegerRange)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for lineRange");
            }
            return retval;
        }
        return Optional.empty();
    }

    public Snippet setLineRange(@Nullable PositiveIntegerRange lineRange) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_LINE_RANGE, (Object)lineRange);
        return this;
    }

    public Optional<PositiveIntegerRange> getByteRange() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_BYTE_RANGE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof PositiveIntegerRange)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for byteRange");
            }
            return retval;
        }
        return Optional.empty();
    }

    public Snippet setByteRange(@Nullable PositiveIntegerRange byteRange) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_BYTE_RANGE, (Object)byteRange);
        return this;
    }

    @Nullable
    public SpdxFile getSnippetFromFile() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_SNIPPET_FROM_FILE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof SpdxFile)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for snippetFromFile");
            }
            return (SpdxFile)((Object)retval.get());
        }
        return null;
    }

    public Snippet setSnippetFromFile(@Nullable SpdxFile snippetFromFile) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)snippetFromFile)) {
            throw new InvalidSPDXAnalysisException("snippetFromFile is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_SNIPPET_FROM_FILE, (Object)snippetFromFile);
        return this;
    }

    @Override
    public Snippet setPrimaryPurpose(@Nullable SoftwarePurpose primaryPurpose) throws InvalidSPDXAnalysisException {
        super.setPrimaryPurpose(primaryPurpose);
        return this;
    }

    @Override
    public Snippet setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
        super.setValidUntilTime(validUntilTime);
        return this;
    }

    @Override
    public Snippet setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
        super.setBuiltTime(builtTime);
        return this;
    }

    @Override
    public Snippet setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public Snippet setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
        super.setReleaseTime(releaseTime);
        return this;
    }

    @Override
    public Snippet setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
        super.setCopyrightText(copyrightText);
        return this;
    }

    @Override
    public Snippet setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public Snippet setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public Snippet setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<PositiveIntegerRange> lineRange = this.getLineRange();
            if (lineRange.isPresent()) {
                retval.addAll(lineRange.get().verify(verifiedIds, specVersionForVerify, profiles));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting lineRange for Snippet: " + e.getMessage());
        }
        try {
            Optional<PositiveIntegerRange> byteRange = this.getByteRange();
            if (byteRange.isPresent()) {
                retval.addAll(byteRange.get().verify(verifiedIds, specVersionForVerify, profiles));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting byteRange for Snippet: " + e.getMessage());
        }
        try {
            SpdxFile snippetFromFile = this.getSnippetFromFile();
            if (Objects.nonNull((Object)snippetFromFile)) {
                retval.addAll(snippetFromFile.verify(verifiedIds, specVersionForVerify, profiles));
            } else if (!Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SOFTWARE))) {
                retval.add("Missing snippetFromFile in Snippet");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting snippetFromFile for Snippet: " + e.getMessage());
        }
        return retval;
    }

    public static class SnippetBuilder
    extends SoftwareArtifact.SoftwareArtifactBuilder {
        protected PositiveIntegerRange lineRange = null;
        protected PositiveIntegerRange byteRange = null;
        protected SpdxFile snippetFromFile = null;

        public SnippetBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public SnippetBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public SnippetBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public SnippetBuilder addContentIdentifier(ContentIdentifier contentIdentifier) {
            if (Objects.nonNull((Object)contentIdentifier)) {
                this.contentIdentifiers.add(contentIdentifier);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllContentIdentifier(Collection<ContentIdentifier> contentIdentifierCollection) {
            if (Objects.nonNull(contentIdentifierCollection)) {
                this.contentIdentifiers.addAll(contentIdentifierCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder addOriginatedBy(Agent originatedBy) {
            if (Objects.nonNull((Object)originatedBy)) {
                this.originatedBys.add(originatedBy);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
            if (Objects.nonNull(originatedByCollection)) {
                this.originatedBys.addAll(originatedByCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder addSupportLevel(SupportType supportLevel) {
            if (Objects.nonNull((Object)supportLevel)) {
                this.supportLevels.add(supportLevel);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
            if (Objects.nonNull(supportLevelCollection)) {
                this.supportLevels.addAll(supportLevelCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAdditionalPurpose(SoftwarePurpose additionalPurpose) {
            if (Objects.nonNull((Object)additionalPurpose)) {
                this.additionalPurposes.add(additionalPurpose);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllAdditionalPurpose(Collection<SoftwarePurpose> additionalPurposeCollection) {
            if (Objects.nonNull(additionalPurposeCollection)) {
                this.additionalPurposes.addAll(additionalPurposeCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAttributionText(String attributionText) {
            if (Objects.nonNull(attributionText)) {
                this.attributionTexts.add(attributionText);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllAttributionText(Collection<String> attributionTextCollection) {
            if (Objects.nonNull(attributionTextCollection)) {
                this.attributionTexts.addAll(attributionTextCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder addStandardName(String standardName) {
            if (Objects.nonNull(standardName)) {
                this.standardNames.add(standardName);
            }
            return this;
        }

        @Override
        public SnippetBuilder addAllStandardName(Collection<String> standardNameCollection) {
            if (Objects.nonNull(standardNameCollection)) {
                this.standardNames.addAll(standardNameCollection);
            }
            return this;
        }

        @Override
        public SnippetBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public SnippetBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        public SnippetBuilder setLineRange(PositiveIntegerRange lineRange) {
            this.lineRange = lineRange;
            return this;
        }

        public SnippetBuilder setByteRange(PositiveIntegerRange byteRange) {
            this.byteRange = byteRange;
            return this;
        }

        public SnippetBuilder setSnippetFromFile(SpdxFile snippetFromFile) {
            this.snippetFromFile = snippetFromFile;
            return this;
        }

        @Override
        public SnippetBuilder setPrimaryPurpose(SoftwarePurpose primaryPurpose) {
            this.primaryPurpose = primaryPurpose;
            return this;
        }

        @Override
        public SnippetBuilder setValidUntilTime(String validUntilTime) {
            this.validUntilTime = validUntilTime;
            return this;
        }

        @Override
        public SnippetBuilder setBuiltTime(String builtTime) {
            this.builtTime = builtTime;
            return this;
        }

        @Override
        public SnippetBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public SnippetBuilder setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
            return this;
        }

        @Override
        public SnippetBuilder setCopyrightText(String copyrightText) {
            this.copyrightText = copyrightText;
            return this;
        }

        @Override
        public SnippetBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public SnippetBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SnippetBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Snippet build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                Snippet snippet = new Snippet(this);
                return snippet;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

