/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.software;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Bom;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.software.SbomType;
import org.spdx.storage.IModelStore;

public class Sbom
extends Bom {
    Collection<SbomType> sbomTypes = Collections.emptyList();

    public Sbom() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public Sbom(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public Sbom(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.sbomTypes = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SBOM_TYPE, SbomType.class);
        }
    }

    protected Sbom(SbomBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.sbomTypes = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SBOM_TYPE, SbomType.class);
        this.getSbomTypes().addAll(builder.sbomTypes);
    }

    @Override
    public String getType() {
        return "Software.Sbom";
    }

    public Collection<SbomType> getSbomTypes() {
        return this.sbomTypes;
    }

    @Override
    public Sbom setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public Sbom setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public Sbom setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public Sbom setContext(@Nullable String context) throws InvalidSPDXAnalysisException {
        super.setContext(context);
        return this;
    }

    @Override
    public Sbom setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public Sbom setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        return retval;
    }

    public static class SbomBuilder
    extends Bom.BomBuilder {
        protected Collection<SbomType> sbomTypes = new ArrayList<SbomType>();

        public SbomBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public SbomBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public SbomBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public SbomBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public SbomBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public SbomBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public SbomBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public SbomBuilder addRootElement(Element rootElement) {
            if (Objects.nonNull((Object)rootElement)) {
                this.rootElements.add(rootElement);
            }
            return this;
        }

        @Override
        public SbomBuilder addAllRootElement(Collection<Element> rootElementCollection) {
            if (Objects.nonNull(rootElementCollection)) {
                this.rootElements.addAll(rootElementCollection);
            }
            return this;
        }

        @Override
        public SbomBuilder addElement(Element element) {
            if (Objects.nonNull((Object)element)) {
                this.elements.add(element);
            }
            return this;
        }

        @Override
        public SbomBuilder addAllElement(Collection<Element> elementCollection) {
            if (Objects.nonNull(elementCollection)) {
                this.elements.addAll(elementCollection);
            }
            return this;
        }

        @Override
        public SbomBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public SbomBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public SbomBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public SbomBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public SbomBuilder addProfileConformance(ProfileIdentifierType profileConformance) {
            if (Objects.nonNull((Object)profileConformance)) {
                this.profileConformances.add(profileConformance);
            }
            return this;
        }

        @Override
        public SbomBuilder addAllProfileConformance(Collection<ProfileIdentifierType> profileConformanceCollection) {
            if (Objects.nonNull(profileConformanceCollection)) {
                this.profileConformances.addAll(profileConformanceCollection);
            }
            return this;
        }

        public SbomBuilder addSbomType(SbomType sbomType) {
            if (Objects.nonNull((Object)sbomType)) {
                this.sbomTypes.add(sbomType);
            }
            return this;
        }

        public SbomBuilder addAllSbomType(Collection<SbomType> sbomTypeCollection) {
            if (Objects.nonNull(sbomTypeCollection)) {
                this.sbomTypes.addAll(sbomTypeCollection);
            }
            return this;
        }

        @Override
        public SbomBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public SbomBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public SbomBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SbomBuilder setContext(String context) {
            this.context = context;
            return this;
        }

        @Override
        public SbomBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public SbomBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Sbom build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                Sbom sbom = new Sbom(this);
                return sbom;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

