/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.software;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.software.ContentIdentifierType;
import org.spdx.storage.IModelStore;

public class ContentIdentifier
extends IntegrityMethod {
    public ContentIdentifier() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public ContentIdentifier(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public ContentIdentifier(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected ContentIdentifier(ContentIdentifierBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull((Object)builder.contentIdentifierType)) {
            this.setContentIdentifierType(builder.contentIdentifierType);
        }
        if (Objects.nonNull(builder.contentIdentifierValue)) {
            this.setContentIdentifierValue(builder.contentIdentifierValue);
        }
    }

    @Override
    public String getType() {
        return "Software.ContentIdentifier";
    }

    @Nullable
    public ContentIdentifierType getContentIdentifierType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_CONTENT_IDENTIFIER_TYPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof ContentIdentifierType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for contentIdentifierType");
            }
            return (ContentIdentifierType)((Object)retval.get());
        }
        return null;
    }

    public ContentIdentifier setContentIdentifierType(@Nullable ContentIdentifierType contentIdentifierType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)contentIdentifierType)) {
            throw new InvalidSPDXAnalysisException("contentIdentifierType is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_CONTENT_IDENTIFIER_TYPE, (Object)contentIdentifierType);
        return this;
    }

    @Override
    public ContentIdentifier setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Nullable
    public String getContentIdentifierValue() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_CONTENT_IDENTIFIER_VALUE);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public ContentIdentifier setContentIdentifierValue(@Nullable String contentIdentifierValue) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(contentIdentifierValue)) {
            throw new InvalidSPDXAnalysisException("contentIdentifierValue is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_CONTENT_IDENTIFIER_VALUE, contentIdentifierValue);
        return this;
    }

    @Override
    public String toString() {
        return "ContentIdentifier: " + this.getObjectUri();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            ContentIdentifierType contentIdentifierType = this.getContentIdentifierType();
            if (Objects.isNull((Object)contentIdentifierType) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SOFTWARE))) {
                retval.add("Missing contentIdentifierType in ContentIdentifier");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting contentIdentifierType for ContentIdentifier: " + e.getMessage());
        }
        try {
            String contentIdentifierValue = this.getContentIdentifierValue();
            if (Objects.isNull(contentIdentifierValue) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SOFTWARE))) {
                retval.add("Missing contentIdentifierValue in ContentIdentifier");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting contentIdentifierValue for ContentIdentifier: " + e.getMessage());
        }
        return retval;
    }

    public static class ContentIdentifierBuilder
    extends IntegrityMethod.IntegrityMethodBuilder {
        protected ContentIdentifierType contentIdentifierType = null;
        protected String contentIdentifierValue = null;

        public ContentIdentifierBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ContentIdentifierBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public ContentIdentifierBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public ContentIdentifierBuilder setContentIdentifierType(ContentIdentifierType contentIdentifierType) {
            this.contentIdentifierType = contentIdentifierType;
            return this;
        }

        @Override
        public ContentIdentifierBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public ContentIdentifierBuilder setContentIdentifierValue(String contentIdentifierValue) {
            this.contentIdentifierValue = contentIdentifierValue;
            return this;
        }

        @Override
        public ContentIdentifier build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                ContentIdentifier contentIdentifier = new ContentIdentifier(this);
                return contentIdentifier;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

