/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.security.VexVulnAssessmentRelationship;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.storage.IModelStore;

public class VexAffectedVulnAssessmentRelationship
extends VexVulnAssessmentRelationship {
    public VexAffectedVulnAssessmentRelationship() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public VexAffectedVulnAssessmentRelationship(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public VexAffectedVulnAssessmentRelationship(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected VexAffectedVulnAssessmentRelationship(VexAffectedVulnAssessmentRelationshipBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setActionStatementTime(builder.actionStatementTime);
        if (Objects.nonNull(builder.actionStatement)) {
            this.setActionStatement(builder.actionStatement);
        }
    }

    @Override
    public String getType() {
        return "Security.VexAffectedVulnAssessmentRelationship";
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setFrom(@Nullable Element from) throws InvalidSPDXAnalysisException {
        super.setFrom(from);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setAssessedElement(@Nullable SoftwareArtifact assessedElement) throws InvalidSPDXAnalysisException {
        super.setAssessedElement(assessedElement);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setRelationshipType(@Nullable RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        super.setRelationshipType(relationshipType);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setCompleteness(@Nullable RelationshipCompleteness completeness) throws InvalidSPDXAnalysisException {
        super.setCompleteness(completeness);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    public Optional<String> getActionStatementTime() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_ACTION_STATEMENT_TIME);
    }

    public VexAffectedVulnAssessmentRelationship setActionStatementTime(@Nullable String actionStatementTime) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(actionStatementTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", actionStatementTime)) {
            throw new InvalidSPDXAnalysisException("actionStatementTime value '" + actionStatementTime + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_ACTION_STATEMENT_TIME, actionStatementTime);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setWithdrawnTime(@Nullable String withdrawnTime) throws InvalidSPDXAnalysisException {
        super.setWithdrawnTime(withdrawnTime);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setModifiedTime(@Nullable String modifiedTime) throws InvalidSPDXAnalysisException {
        super.setModifiedTime(modifiedTime);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setPublishedTime(@Nullable String publishedTime) throws InvalidSPDXAnalysisException {
        super.setPublishedTime(publishedTime);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setVexVersion(@Nullable String vexVersion) throws InvalidSPDXAnalysisException {
        super.setVexVersion(vexVersion);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Nullable
    public String getActionStatement() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_ACTION_STATEMENT);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public VexAffectedVulnAssessmentRelationship setActionStatement(@Nullable String actionStatement) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(actionStatement)) {
            throw new InvalidSPDXAnalysisException("actionStatement is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_ACTION_STATEMENT, actionStatement);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setEndTime(@Nullable String endTime) throws InvalidSPDXAnalysisException {
        super.setEndTime(endTime);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setStatusNotes(@Nullable String statusNotes) throws InvalidSPDXAnalysisException {
        super.setStatusNotes(statusNotes);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setStartTime(@Nullable String startTime) throws InvalidSPDXAnalysisException {
        super.setStartTime(startTime);
        return this;
    }

    @Override
    public VexAffectedVulnAssessmentRelationship setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<String> actionStatementTime = this.getActionStatementTime();
            if (actionStatementTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", actionStatementTime.get())) {
                retval.add("actionStatementTime value '" + actionStatementTime.get() + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting actionStatementTime for VexAffectedVulnAssessmentRelationship: " + e.getMessage());
        }
        try {
            String actionStatement = this.getActionStatement();
            if (Objects.isNull(actionStatement) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing actionStatement in VexAffectedVulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting actionStatement for VexAffectedVulnAssessmentRelationship: " + e.getMessage());
        }
        return retval;
    }

    public static class VexAffectedVulnAssessmentRelationshipBuilder
    extends VexVulnAssessmentRelationship.VexVulnAssessmentRelationshipBuilder {
        protected String actionStatementTime = null;
        protected String actionStatement = null;

        public VexAffectedVulnAssessmentRelationshipBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public VexAffectedVulnAssessmentRelationshipBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public VexAffectedVulnAssessmentRelationshipBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addTo(Element to) {
            if (Objects.nonNull((Object)to)) {
                this.tos.add(to);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addAllTo(Collection<Element> toCollection) {
            if (Objects.nonNull(toCollection)) {
                this.tos.addAll(toCollection);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setFrom(Element from) {
            this.from = from;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setAssessedElement(SoftwareArtifact assessedElement) {
            this.assessedElement = assessedElement;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setRelationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setCompleteness(RelationshipCompleteness completeness) {
            this.completeness = completeness;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public VexAffectedVulnAssessmentRelationshipBuilder setActionStatementTime(String actionStatementTime) {
            this.actionStatementTime = actionStatementTime;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setWithdrawnTime(String withdrawnTime) {
            this.withdrawnTime = withdrawnTime;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setPublishedTime(String publishedTime) {
            this.publishedTime = publishedTime;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setVexVersion(String vexVersion) {
            this.vexVersion = vexVersion;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public VexAffectedVulnAssessmentRelationshipBuilder setActionStatement(String actionStatement) {
            this.actionStatement = actionStatement;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setStatusNotes(String statusNotes) {
            this.statusNotes = statusNotes;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationshipBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public VexAffectedVulnAssessmentRelationship build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                VexAffectedVulnAssessmentRelationship vexAffectedVulnAssessmentRelationship = new VexAffectedVulnAssessmentRelationship(this);
                return vexAffectedVulnAssessmentRelationship;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

