/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.security.SsvcDecisionType;
import org.spdx.library.model.v3_0_1.security.VulnAssessmentRelationship;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.storage.IModelStore;

public class SsvcVulnAssessmentRelationship
extends VulnAssessmentRelationship {
    public SsvcVulnAssessmentRelationship() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public SsvcVulnAssessmentRelationship(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public SsvcVulnAssessmentRelationship(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected SsvcVulnAssessmentRelationship(SsvcVulnAssessmentRelationshipBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull((Object)builder.decisionType)) {
            this.setDecisionType(builder.decisionType);
        }
    }

    @Override
    public String getType() {
        return "Security.SsvcVulnAssessmentRelationship";
    }

    @Override
    public SsvcVulnAssessmentRelationship setFrom(@Nullable Element from) throws InvalidSPDXAnalysisException {
        super.setFrom(from);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setAssessedElement(@Nullable SoftwareArtifact assessedElement) throws InvalidSPDXAnalysisException {
        super.setAssessedElement(assessedElement);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setCompleteness(@Nullable RelationshipCompleteness completeness) throws InvalidSPDXAnalysisException {
        super.setCompleteness(completeness);
        return this;
    }

    @Nullable
    public SsvcDecisionType getDecisionType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_DECISION_TYPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof SsvcDecisionType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for decisionType");
            }
            return (SsvcDecisionType)((Object)retval.get());
        }
        return null;
    }

    public SsvcVulnAssessmentRelationship setDecisionType(@Nullable SsvcDecisionType decisionType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)decisionType)) {
            throw new InvalidSPDXAnalysisException("decisionType is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_DECISION_TYPE, (Object)decisionType);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setRelationshipType(@Nullable RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        super.setRelationshipType(relationshipType);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setPublishedTime(@Nullable String publishedTime) throws InvalidSPDXAnalysisException {
        super.setPublishedTime(publishedTime);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setEndTime(@Nullable String endTime) throws InvalidSPDXAnalysisException {
        super.setEndTime(endTime);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setStartTime(@Nullable String startTime) throws InvalidSPDXAnalysisException {
        super.setStartTime(startTime);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setWithdrawnTime(@Nullable String withdrawnTime) throws InvalidSPDXAnalysisException {
        super.setWithdrawnTime(withdrawnTime);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public SsvcVulnAssessmentRelationship setModifiedTime(@Nullable String modifiedTime) throws InvalidSPDXAnalysisException {
        super.setModifiedTime(modifiedTime);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            SsvcDecisionType decisionType = this.getDecisionType();
            if (Objects.isNull((Object)decisionType) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing decisionType in SsvcVulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting decisionType for SsvcVulnAssessmentRelationship: " + e.getMessage());
        }
        return retval;
    }

    public static class SsvcVulnAssessmentRelationshipBuilder
    extends VulnAssessmentRelationship.VulnAssessmentRelationshipBuilder {
        protected SsvcDecisionType decisionType = null;

        public SsvcVulnAssessmentRelationshipBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public SsvcVulnAssessmentRelationshipBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public SsvcVulnAssessmentRelationshipBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addTo(Element to) {
            if (Objects.nonNull((Object)to)) {
                this.tos.add(to);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addAllTo(Collection<Element> toCollection) {
            if (Objects.nonNull(toCollection)) {
                this.tos.addAll(toCollection);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setFrom(Element from) {
            this.from = from;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setAssessedElement(SoftwareArtifact assessedElement) {
            this.assessedElement = assessedElement;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setCompleteness(RelationshipCompleteness completeness) {
            this.completeness = completeness;
            return this;
        }

        public SsvcVulnAssessmentRelationshipBuilder setDecisionType(SsvcDecisionType decisionType) {
            this.decisionType = decisionType;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setRelationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setPublishedTime(String publishedTime) {
            this.publishedTime = publishedTime;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setWithdrawnTime(String withdrawnTime) {
            this.withdrawnTime = withdrawnTime;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationshipBuilder setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        @Override
        public SsvcVulnAssessmentRelationship build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                SsvcVulnAssessmentRelationship ssvcVulnAssessmentRelationship = new SsvcVulnAssessmentRelationship(this);
                return ssvcVulnAssessmentRelationship;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

