/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.security.CvssSeverityType;
import org.spdx.library.model.v3_0_1.security.VulnAssessmentRelationship;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.storage.IModelStore;

public class CvssV4VulnAssessmentRelationship
extends VulnAssessmentRelationship {
    public CvssV4VulnAssessmentRelationship() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public CvssV4VulnAssessmentRelationship(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public CvssV4VulnAssessmentRelationship(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected CvssV4VulnAssessmentRelationship(CvssV4VulnAssessmentRelationshipBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull((Object)builder.severity)) {
            this.setSeverity(builder.severity);
        }
        if (Objects.nonNull(builder.score)) {
            this.setScore(builder.score);
        }
        if (Objects.nonNull(builder.vectorString)) {
            this.setVectorString(builder.vectorString);
        }
    }

    @Override
    public String getType() {
        return "Security.CvssV4VulnAssessmentRelationship";
    }

    @Override
    public CvssV4VulnAssessmentRelationship setFrom(@Nullable Element from) throws InvalidSPDXAnalysisException {
        super.setFrom(from);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setAssessedElement(@Nullable SoftwareArtifact assessedElement) throws InvalidSPDXAnalysisException {
        super.setAssessedElement(assessedElement);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    @Nullable
    public CvssSeverityType getSeverity() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_SEVERITY);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof CvssSeverityType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for severity");
            }
            return (CvssSeverityType)((Object)retval.get());
        }
        return null;
    }

    public CvssV4VulnAssessmentRelationship setSeverity(@Nullable CvssSeverityType severity) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)severity)) {
            throw new InvalidSPDXAnalysisException("severity is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_SEVERITY, (Object)severity);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setCompleteness(@Nullable RelationshipCompleteness completeness) throws InvalidSPDXAnalysisException {
        super.setCompleteness(completeness);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setRelationshipType(@Nullable RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        super.setRelationshipType(relationshipType);
        return this;
    }

    @Nullable
    public Double getScore() throws InvalidSPDXAnalysisException {
        Optional retval = this.getDoublePropertyValue(SpdxConstantsV3.PROP_SCORE);
        return retval.isPresent() ? (Double)retval.get() : null;
    }

    public CvssV4VulnAssessmentRelationship setScore(@Nullable Double score) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(score)) {
            throw new InvalidSPDXAnalysisException("score is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_SCORE, score);
        return this;
    }

    @Nullable
    public String getVectorString() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_VECTOR_STRING);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public CvssV4VulnAssessmentRelationship setVectorString(@Nullable String vectorString) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(vectorString)) {
            throw new InvalidSPDXAnalysisException("vectorString is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_VECTOR_STRING, vectorString);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setPublishedTime(@Nullable String publishedTime) throws InvalidSPDXAnalysisException {
        super.setPublishedTime(publishedTime);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setEndTime(@Nullable String endTime) throws InvalidSPDXAnalysisException {
        super.setEndTime(endTime);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setStartTime(@Nullable String startTime) throws InvalidSPDXAnalysisException {
        super.setStartTime(startTime);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setWithdrawnTime(@Nullable String withdrawnTime) throws InvalidSPDXAnalysisException {
        super.setWithdrawnTime(withdrawnTime);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public CvssV4VulnAssessmentRelationship setModifiedTime(@Nullable String modifiedTime) throws InvalidSPDXAnalysisException {
        super.setModifiedTime(modifiedTime);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            CvssSeverityType severity = this.getSeverity();
            if (Objects.isNull((Object)severity) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing severity in CvssV4VulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting severity for CvssV4VulnAssessmentRelationship: " + e.getMessage());
        }
        try {
            Double score = this.getScore();
            if (Objects.isNull(score) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing score in CvssV4VulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting score for CvssV4VulnAssessmentRelationship: " + e.getMessage());
        }
        try {
            String vectorString = this.getVectorString();
            if (Objects.isNull(vectorString) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing vectorString in CvssV4VulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting vectorString for CvssV4VulnAssessmentRelationship: " + e.getMessage());
        }
        return retval;
    }

    public static class CvssV4VulnAssessmentRelationshipBuilder
    extends VulnAssessmentRelationship.VulnAssessmentRelationshipBuilder {
        protected CvssSeverityType severity = null;
        protected Double score = null;
        protected String vectorString = null;

        public CvssV4VulnAssessmentRelationshipBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public CvssV4VulnAssessmentRelationshipBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public CvssV4VulnAssessmentRelationshipBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addTo(Element to) {
            if (Objects.nonNull((Object)to)) {
                this.tos.add(to);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addAllTo(Collection<Element> toCollection) {
            if (Objects.nonNull(toCollection)) {
                this.tos.addAll(toCollection);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setFrom(Element from) {
            this.from = from;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setAssessedElement(SoftwareArtifact assessedElement) {
            this.assessedElement = assessedElement;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        public CvssV4VulnAssessmentRelationshipBuilder setSeverity(CvssSeverityType severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setCompleteness(RelationshipCompleteness completeness) {
            this.completeness = completeness;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setRelationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        public CvssV4VulnAssessmentRelationshipBuilder setScore(Double score) {
            this.score = score;
            return this;
        }

        public CvssV4VulnAssessmentRelationshipBuilder setVectorString(String vectorString) {
            this.vectorString = vectorString;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setPublishedTime(String publishedTime) {
            this.publishedTime = publishedTime;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setWithdrawnTime(String withdrawnTime) {
            this.withdrawnTime = withdrawnTime;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationshipBuilder setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        @Override
        public CvssV4VulnAssessmentRelationship build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                CvssV4VulnAssessmentRelationship cvssV4VulnAssessmentRelationship = new CvssV4VulnAssessmentRelationship(this);
                return cvssV4VulnAssessmentRelationship;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

