/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.expandedlicensing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.expandedlicensing.License;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public class ListedLicense
extends License {
    public ListedLicense() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public ListedLicense(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public ListedLicense(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected ListedLicense(ListedLicenseBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setListVersionAdded(builder.listVersionAdded);
        this.setDeprecatedVersion(builder.deprecatedVersion);
    }

    @Override
    public String getType() {
        return "ExpandedLicensing.ListedLicense";
    }

    @Override
    public ListedLicense setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public ListedLicense setIsFsfLibre(@Nullable Boolean isFsfLibre) throws InvalidSPDXAnalysisException {
        super.setIsFsfLibre(isFsfLibre);
        return this;
    }

    @Override
    public ListedLicense setIsDeprecatedLicenseId(@Nullable Boolean isDeprecatedLicenseId) throws InvalidSPDXAnalysisException {
        super.setIsDeprecatedLicenseId(isDeprecatedLicenseId);
        return this;
    }

    @Override
    public ListedLicense setIsOsiApproved(@Nullable Boolean isOsiApproved) throws InvalidSPDXAnalysisException {
        super.setIsOsiApproved(isOsiApproved);
        return this;
    }

    @Override
    public ListedLicense setLicenseText(@Nullable String licenseText) throws InvalidSPDXAnalysisException {
        super.setLicenseText(licenseText);
        return this;
    }

    @Override
    public ListedLicense setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public ListedLicense setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public ListedLicense setStandardLicenseTemplate(@Nullable String standardLicenseTemplate) throws InvalidSPDXAnalysisException {
        super.setStandardLicenseTemplate(standardLicenseTemplate);
        return this;
    }

    @Override
    public ListedLicense setObsoletedBy(@Nullable String obsoletedBy) throws InvalidSPDXAnalysisException {
        super.setObsoletedBy(obsoletedBy);
        return this;
    }

    public Optional<String> getListVersionAdded() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_LIST_VERSION_ADDED);
    }

    public ListedLicense setListVersionAdded(@Nullable String listVersionAdded) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_LIST_VERSION_ADDED, listVersionAdded);
        return this;
    }

    @Override
    public ListedLicense setLicenseXml(@Nullable String licenseXml) throws InvalidSPDXAnalysisException {
        super.setLicenseXml(licenseXml);
        return this;
    }

    @Override
    public ListedLicense setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public ListedLicense setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    public Optional<String> getDeprecatedVersion() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_DEPRECATED_VERSION);
    }

    public ListedLicense setDeprecatedVersion(@Nullable String deprecatedVersion) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_DEPRECATED_VERSION, deprecatedVersion);
        return this;
    }

    @Override
    public ListedLicense setStandardLicenseHeader(@Nullable String standardLicenseHeader) throws InvalidSPDXAnalysisException {
        super.setStandardLicenseHeader(standardLicenseHeader);
        return this;
    }

    @Override
    public String toString() {
        return this.getObjectUri().substring("http://spdx.org/licenses/".length());
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<String> optional = this.getListVersionAdded();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting listVersionAdded for ListedLicense: " + e.getMessage());
        }
        try {
            Optional<String> e = this.getDeprecatedVersion();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting deprecatedVersion for ListedLicense: " + e.getMessage());
        }
        return retval;
    }

    public static class ListedLicenseBuilder
    extends License.LicenseBuilder {
        protected String listVersionAdded = null;
        protected String deprecatedVersion = null;

        public ListedLicenseBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ListedLicenseBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public ListedLicenseBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public ListedLicenseBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder addSeeAlso(String seeAlso) {
            if (Objects.nonNull(seeAlso)) {
                this.seeAlsos.add(seeAlso);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder addAllSeeAlso(Collection<String> seeAlsoCollection) {
            if (Objects.nonNull(seeAlsoCollection)) {
                this.seeAlsos.addAll(seeAlsoCollection);
            }
            return this;
        }

        @Override
        public ListedLicenseBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public ListedLicenseBuilder setIsFsfLibre(Boolean isFsfLibre) {
            this.isFsfLibre = isFsfLibre;
            return this;
        }

        @Override
        public ListedLicenseBuilder setIsDeprecatedLicenseId(Boolean isDeprecatedLicenseId) {
            this.isDeprecatedLicenseId = isDeprecatedLicenseId;
            return this;
        }

        @Override
        public ListedLicenseBuilder setIsOsiApproved(Boolean isOsiApproved) {
            this.isOsiApproved = isOsiApproved;
            return this;
        }

        @Override
        public ListedLicenseBuilder setLicenseText(String licenseText) {
            this.licenseText = licenseText;
            return this;
        }

        @Override
        public ListedLicenseBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public ListedLicenseBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ListedLicenseBuilder setStandardLicenseTemplate(String standardLicenseTemplate) {
            this.standardLicenseTemplate = standardLicenseTemplate;
            return this;
        }

        @Override
        public ListedLicenseBuilder setObsoletedBy(String obsoletedBy) {
            this.obsoletedBy = obsoletedBy;
            return this;
        }

        public ListedLicenseBuilder setListVersionAdded(String listVersionAdded) {
            this.listVersionAdded = listVersionAdded;
            return this;
        }

        @Override
        public ListedLicenseBuilder setLicenseXml(String licenseXml) {
            this.licenseXml = licenseXml;
            return this;
        }

        @Override
        public ListedLicenseBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public ListedLicenseBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public ListedLicenseBuilder setDeprecatedVersion(String deprecatedVersion) {
            this.deprecatedVersion = deprecatedVersion;
            return this;
        }

        @Override
        public ListedLicenseBuilder setStandardLicenseHeader(String standardLicenseHeader) {
            this.standardLicenseHeader = standardLicenseHeader;
            return this;
        }

        @Override
        public ListedLicense build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                ListedLicense listedLicense = new ListedLicense(this);
                return listedLicense;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

