/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.expandedlicensing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public abstract class LicenseAddition
extends Element {
    Collection<String> seeAlsos = Collections.emptyList();

    public LicenseAddition() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public LicenseAddition(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public LicenseAddition(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.seeAlsos = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SEE_ALSO, String.class);
        }
    }

    protected LicenseAddition(LicenseAdditionBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.seeAlsos = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SEE_ALSO, String.class);
        this.getSeeAlsos().addAll(builder.seeAlsos);
        this.setIsDeprecatedAdditionId(builder.isDeprecatedAdditionId);
        this.setObsoletedBy(builder.obsoletedBy);
        if (Objects.nonNull(builder.additionText)) {
            this.setAdditionText(builder.additionText);
        }
        this.setLicenseXml(builder.licenseXml);
        this.setStandardAdditionTemplate(builder.standardAdditionTemplate);
    }

    @Override
    public String getType() {
        return "ExpandedLicensing.LicenseAddition";
    }

    public Collection<String> getSeeAlsos() {
        return this.seeAlsos;
    }

    @Override
    public LicenseAddition setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    public Optional<Boolean> getIsDeprecatedAdditionId() throws InvalidSPDXAnalysisException {
        return this.getBooleanPropertyValue(SpdxConstantsV3.PROP_IS_DEPRECATED_ADDITION_ID);
    }

    public LicenseAddition setIsDeprecatedAdditionId(@Nullable Boolean isDeprecatedAdditionId) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_IS_DEPRECATED_ADDITION_ID, isDeprecatedAdditionId);
        return this;
    }

    @Override
    public LicenseAddition setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public LicenseAddition setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    public Optional<String> getObsoletedBy() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_OBSOLETED_BY);
    }

    public LicenseAddition setObsoletedBy(@Nullable String obsoletedBy) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_OBSOLETED_BY, obsoletedBy);
        return this;
    }

    @Nullable
    public String getAdditionText() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_ADDITION_TEXT);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public LicenseAddition setAdditionText(@Nullable String additionText) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(additionText)) {
            throw new InvalidSPDXAnalysisException("additionText is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_ADDITION_TEXT, additionText);
        return this;
    }

    public Optional<String> getLicenseXml() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_XML);
    }

    public LicenseAddition setLicenseXml(@Nullable String licenseXml) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_LICENSE_XML, licenseXml);
        return this;
    }

    @Override
    public LicenseAddition setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public LicenseAddition setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    public Optional<String> getStandardAdditionTemplate() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_STANDARD_ADDITION_TEMPLATE);
    }

    public LicenseAddition setStandardAdditionTemplate(@Nullable String standardAdditionTemplate) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_STANDARD_ADDITION_TEMPLATE, standardAdditionTemplate);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        Optional<String> e2;
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<Boolean> optional = this.getIsDeprecatedAdditionId();
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting isDeprecatedAdditionId for LicenseAddition: " + e2.getMessage());
        }
        try {
            e2 = this.getObsoletedBy();
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting obsoletedBy for LicenseAddition: " + e3.getMessage());
        }
        try {
            String additionText = this.getAdditionText();
            if (Objects.isNull(additionText) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.EXPANDED_LICENSING))) {
                retval.add("Missing additionText in LicenseAddition");
            }
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting additionText for LicenseAddition: " + e4.getMessage());
        }
        try {
            e2 = this.getLicenseXml();
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Error getting licenseXml for LicenseAddition: " + e5.getMessage());
        }
        try {
            e2 = this.getStandardAdditionTemplate();
        }
        catch (InvalidSPDXAnalysisException e6) {
            retval.add("Error getting standardAdditionTemplate for LicenseAddition: " + e6.getMessage());
        }
        return retval;
    }

    public static abstract class LicenseAdditionBuilder
    extends Element.ElementBuilder {
        protected Collection<String> seeAlsos = new ArrayList<String>();
        protected Boolean isDeprecatedAdditionId = null;
        protected String obsoletedBy = null;
        protected String additionText = null;
        protected String licenseXml = null;
        protected String standardAdditionTemplate = null;

        public LicenseAdditionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public LicenseAdditionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public LicenseAdditionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public LicenseAdditionBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public LicenseAdditionBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public LicenseAdditionBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public LicenseAdditionBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public LicenseAdditionBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public LicenseAdditionBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public LicenseAdditionBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public LicenseAdditionBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public LicenseAdditionBuilder addSeeAlso(String seeAlso) {
            if (Objects.nonNull(seeAlso)) {
                this.seeAlsos.add(seeAlso);
            }
            return this;
        }

        public LicenseAdditionBuilder addAllSeeAlso(Collection<String> seeAlsoCollection) {
            if (Objects.nonNull(seeAlsoCollection)) {
                this.seeAlsos.addAll(seeAlsoCollection);
            }
            return this;
        }

        @Override
        public LicenseAdditionBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public LicenseAdditionBuilder setIsDeprecatedAdditionId(Boolean isDeprecatedAdditionId) {
            this.isDeprecatedAdditionId = isDeprecatedAdditionId;
            return this;
        }

        @Override
        public LicenseAdditionBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public LicenseAdditionBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public LicenseAdditionBuilder setObsoletedBy(String obsoletedBy) {
            this.obsoletedBy = obsoletedBy;
            return this;
        }

        public LicenseAdditionBuilder setAdditionText(String additionText) {
            this.additionText = additionText;
            return this;
        }

        public LicenseAdditionBuilder setLicenseXml(String licenseXml) {
            this.licenseXml = licenseXml;
            return this;
        }

        @Override
        public LicenseAdditionBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public LicenseAdditionBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public LicenseAdditionBuilder setStandardAdditionTemplate(String standardAdditionTemplate) {
            this.standardAdditionTemplate = standardAdditionTemplate;
            return this;
        }

        @Override
        public abstract LicenseAddition build() throws InvalidSPDXAnalysisException;
    }
}

