/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.HashAlgorithm;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.storage.IModelStore;

public class PackageVerificationCode
extends IntegrityMethod {
    Collection<String> packageVerificationCodeExcludedFiles = Collections.emptyList();

    public PackageVerificationCode() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public PackageVerificationCode(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public PackageVerificationCode(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.packageVerificationCodeExcludedFiles = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PACKAGE_VERIFICATION_CODE_EXCLUDED_FILE, String.class);
        }
    }

    protected PackageVerificationCode(PackageVerificationCodeBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.packageVerificationCodeExcludedFiles = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PACKAGE_VERIFICATION_CODE_EXCLUDED_FILE, String.class);
        this.getPackageVerificationCodeExcludedFiles().addAll(builder.packageVerificationCodeExcludedFiles);
        if (Objects.nonNull((Object)builder.algorithm)) {
            this.setAlgorithm(builder.algorithm);
        }
        if (Objects.nonNull(builder.hashValue)) {
            this.setHashValue(builder.hashValue);
        }
    }

    @Override
    public String getType() {
        return "Core.PackageVerificationCode";
    }

    public Collection<String> getPackageVerificationCodeExcludedFiles() {
        return this.packageVerificationCodeExcludedFiles;
    }

    @Nullable
    public HashAlgorithm getAlgorithm() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_ALGORITHM);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof HashAlgorithm)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for algorithm");
            }
            return (HashAlgorithm)((Object)retval.get());
        }
        return null;
    }

    public PackageVerificationCode setAlgorithm(@Nullable HashAlgorithm algorithm) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)algorithm)) {
            throw new InvalidSPDXAnalysisException("algorithm is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_ALGORITHM, (Object)algorithm);
        return this;
    }

    @Nullable
    public String getHashValue() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_HASH_VALUE);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public PackageVerificationCode setHashValue(@Nullable String hashValue) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(hashValue)) {
            throw new InvalidSPDXAnalysisException("hashValue is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_HASH_VALUE, hashValue);
        return this;
    }

    @Override
    public PackageVerificationCode setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public String toString() {
        return "PackageVerificationCode: " + this.getObjectUri();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            HashAlgorithm algorithm = this.getAlgorithm();
            if (Objects.isNull((Object)algorithm) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing algorithm in PackageVerificationCode");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting algorithm for PackageVerificationCode: " + e.getMessage());
        }
        try {
            String hashValue = this.getHashValue();
            if (Objects.isNull(hashValue) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing hashValue in PackageVerificationCode");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting hashValue for PackageVerificationCode: " + e.getMessage());
        }
        return retval;
    }

    public static class PackageVerificationCodeBuilder
    extends IntegrityMethod.IntegrityMethodBuilder {
        protected Collection<String> packageVerificationCodeExcludedFiles = new ArrayList<String>();
        protected HashAlgorithm algorithm = null;
        protected String hashValue = null;

        public PackageVerificationCodeBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public PackageVerificationCodeBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public PackageVerificationCodeBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public PackageVerificationCodeBuilder addPackageVerificationCodeExcludedFile(String packageVerificationCodeExcludedFile) {
            if (Objects.nonNull(packageVerificationCodeExcludedFile)) {
                this.packageVerificationCodeExcludedFiles.add(packageVerificationCodeExcludedFile);
            }
            return this;
        }

        public PackageVerificationCodeBuilder addAllPackageVerificationCodeExcludedFile(Collection<String> packageVerificationCodeExcludedFileCollection) {
            if (Objects.nonNull(packageVerificationCodeExcludedFileCollection)) {
                this.packageVerificationCodeExcludedFiles.addAll(packageVerificationCodeExcludedFileCollection);
            }
            return this;
        }

        public PackageVerificationCodeBuilder setAlgorithm(HashAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public PackageVerificationCodeBuilder setHashValue(String hashValue) {
            this.hashValue = hashValue;
            return this;
        }

        @Override
        public PackageVerificationCodeBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public PackageVerificationCode build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                PackageVerificationCode packageVerificationCode = new PackageVerificationCode(this);
                return packageVerificationCode;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

