/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.storage.IModelStore;

public class NamespaceMap
extends ModelObjectV3 {
    public NamespaceMap() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public NamespaceMap(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public NamespaceMap(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected NamespaceMap(NamespaceMapBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull(builder.prefix)) {
            this.setPrefix(builder.prefix);
        }
        if (Objects.nonNull(builder.namespace)) {
            this.setNamespace(builder.namespace);
        }
    }

    public String getType() {
        return "Core.NamespaceMap";
    }

    @Nullable
    public String getPrefix() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_PREFIX);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public NamespaceMap setPrefix(@Nullable String prefix) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(prefix)) {
            throw new InvalidSPDXAnalysisException("prefix is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_PREFIX, prefix);
        return this;
    }

    @Nullable
    public String getNamespace() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_NAMESPACE);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public NamespaceMap setNamespace(@Nullable String namespace) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(namespace)) {
            throw new InvalidSPDXAnalysisException("namespace is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_NAMESPACE, namespace);
        return this;
    }

    public String toString() {
        return "NamespaceMap: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            String prefix = this.getPrefix();
            if (Objects.isNull(prefix) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing prefix in NamespaceMap");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting prefix for NamespaceMap: " + e.getMessage());
        }
        try {
            String namespace = this.getNamespace();
            if (Objects.isNull(namespace) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing namespace in NamespaceMap");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting namespace for NamespaceMap: " + e.getMessage());
        }
        return retval;
    }

    public static class NamespaceMapBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected String prefix = null;
        protected String namespace = null;

        public NamespaceMapBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public NamespaceMapBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public NamespaceMapBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public NamespaceMapBuilder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public NamespaceMapBuilder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public NamespaceMap build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                NamespaceMap namespaceMap = new NamespaceMap(this);
                return namespaceMap;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

