/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Artifact;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.storage.IModelStore;

public class ExternalMap
extends ModelObjectV3 {
    Collection<IntegrityMethod> verifiedUsings = Collections.emptyList();

    public ExternalMap() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public ExternalMap(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public ExternalMap(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.verifiedUsings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_VERIFIED_USING, IntegrityMethod.class);
        }
    }

    protected ExternalMap(ExternalMapBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.verifiedUsings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_VERIFIED_USING, IntegrityMethod.class);
        this.getVerifiedUsings().addAll(builder.verifiedUsings);
        this.setDefiningArtifact(builder.definingArtifact);
        if (Objects.nonNull(builder.externalSpdxId)) {
            this.setExternalSpdxId(builder.externalSpdxId);
        }
        this.setLocationHint(builder.locationHint);
    }

    public String getType() {
        return "Core.ExternalMap";
    }

    public Collection<IntegrityMethod> getVerifiedUsings() {
        return this.verifiedUsings;
    }

    public Optional<Artifact> getDefiningArtifact() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_DEFINING_ARTIFACT);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof Artifact)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for definingArtifact");
            }
            return retval;
        }
        return Optional.empty();
    }

    public ExternalMap setDefiningArtifact(@Nullable Artifact definingArtifact) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_DEFINING_ARTIFACT, (Object)definingArtifact);
        return this;
    }

    @Nullable
    public String getExternalSpdxId() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_SPDX_ID);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public ExternalMap setExternalSpdxId(@Nullable String externalSpdxId) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(externalSpdxId)) {
            throw new InvalidSPDXAnalysisException("externalSpdxId is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_SPDX_ID, externalSpdxId);
        return this;
    }

    public Optional<String> getLocationHint() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_LOCATION_HINT);
    }

    public ExternalMap setLocationHint(@Nullable String locationHint) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_LOCATION_HINT, locationHint);
        return this;
    }

    public String toString() {
        return "ExternalMap: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Optional<Artifact> definingArtifact = this.getDefiningArtifact();
            if (definingArtifact.isPresent()) {
                retval.addAll(definingArtifact.get().verify(verifiedIds, specVersionForVerify, profiles));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting definingArtifact for ExternalMap: " + e.getMessage());
        }
        try {
            String externalSpdxId = this.getExternalSpdxId();
            if (Objects.isNull(externalSpdxId) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing externalSpdxId in ExternalMap");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting externalSpdxId for ExternalMap: " + e.getMessage());
        }
        try {
            Optional<String> e = this.getLocationHint();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting locationHint for ExternalMap: " + e.getMessage());
        }
        for (IntegrityMethod verifiedUsing : this.verifiedUsings) {
            retval.addAll(verifiedUsing.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class ExternalMapBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected Collection<IntegrityMethod> verifiedUsings = new ArrayList<IntegrityMethod>();
        protected Artifact definingArtifact = null;
        protected String externalSpdxId = null;
        protected String locationHint = null;

        public ExternalMapBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ExternalMapBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public ExternalMapBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public ExternalMapBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        public ExternalMapBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        public ExternalMapBuilder setDefiningArtifact(Artifact definingArtifact) {
            this.definingArtifact = definingArtifact;
            return this;
        }

        public ExternalMapBuilder setExternalSpdxId(String externalSpdxId) {
            this.externalSpdxId = externalSpdxId;
            return this;
        }

        public ExternalMapBuilder setLocationHint(String locationHint) {
            this.locationHint = locationHint;
            return this;
        }

        public ExternalMap build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                ExternalMap externalMap = new ExternalMap(this);
                return externalMap;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

