/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.Tool;
import org.spdx.storage.IModelStore;

public class CreationInfo
extends ModelObjectV3 {
    Collection<Agent> createdBys = Collections.emptyList();
    Collection<Tool> createdUsings = Collections.emptyList();

    public CreationInfo() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public CreationInfo(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public CreationInfo(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.createdBys = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CREATED_BY, Agent.class);
        }
        if (!this.isExternal()) {
            this.createdUsings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CREATED_USING, Tool.class);
        }
    }

    protected CreationInfo(CreationInfoBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.createdBys = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CREATED_BY, Agent.class);
        this.createdUsings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CREATED_USING, Tool.class);
        this.getCreatedBys().addAll(builder.createdBys);
        this.getCreatedUsings().addAll(builder.createdUsings);
        if (Objects.nonNull(builder.created)) {
            this.setCreated(builder.created);
        }
        if (Objects.nonNull(builder.specVersion)) {
            this.setSpecVersion(builder.specVersion);
        }
        this.setComment(builder.comment);
    }

    public String getType() {
        return "Core.CreationInfo";
    }

    public Collection<Agent> getCreatedBys() {
        return this.createdBys;
    }

    public Collection<Tool> getCreatedUsings() {
        return this.createdUsings;
    }

    @Nullable
    public String getCreated() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_CREATED);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public CreationInfo setCreated(@Nullable String created) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(created)) {
            throw new InvalidSPDXAnalysisException("created is a required property");
        }
        if (this.isStrict() && Objects.nonNull(created) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", created)) {
            throw new InvalidSPDXAnalysisException("created value '" + created + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_CREATED, created);
        return this;
    }

    @Nullable
    public String getSpecVersion() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_SPEC_VERSION);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public CreationInfo setSpecVersion(@Nullable String specVersion) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(specVersion)) {
            throw new InvalidSPDXAnalysisException("specVersion is a required property");
        }
        if (this.isStrict() && Objects.nonNull(specVersion) && !Pattern.matches("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$", specVersion)) {
            throw new InvalidSPDXAnalysisException("specVersion value '" + specVersion + "' does not match the pattern '^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_SPEC_VERSION, specVersion);
        return this;
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_COMMENT);
    }

    public CreationInfo setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_COMMENT, comment);
        return this;
    }

    public String toString() {
        return "CreationInfo: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            String created = this.getCreated();
            if (Objects.isNull(created) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing created in CreationInfo");
            }
            if (Objects.nonNull(created) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", created)) {
                retval.add("created value '" + created + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting created for CreationInfo: " + e.getMessage());
        }
        try {
            String specVersion = this.getSpecVersion();
            if (Objects.isNull(specVersion) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing specVersion in CreationInfo");
            }
            if (Objects.nonNull(specVersion) && !Pattern.matches("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$", specVersion)) {
                retval.add("specVersion value '" + specVersion + "' does not match the pattern '^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting specVersion for CreationInfo: " + e.getMessage());
        }
        try {
            Optional<String> e = this.getComment();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting comment for CreationInfo: " + e.getMessage());
        }
        for (Agent createdBy : this.createdBys) {
            retval.addAll(createdBy.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (Tool createdUsing : this.createdUsings) {
            retval.addAll(createdUsing.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class CreationInfoBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected Collection<Agent> createdBys = new ArrayList<Agent>();
        protected Collection<Tool> createdUsings = new ArrayList<Tool>();
        protected String created = null;
        protected String specVersion = null;
        protected String comment = null;

        public CreationInfoBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public CreationInfoBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public CreationInfoBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public CreationInfoBuilder addCreatedBy(Agent createdBy) {
            if (Objects.nonNull((Object)createdBy)) {
                this.createdBys.add(createdBy);
            }
            return this;
        }

        public CreationInfoBuilder addAllCreatedBy(Collection<Agent> createdByCollection) {
            if (Objects.nonNull(createdByCollection)) {
                this.createdBys.addAll(createdByCollection);
            }
            return this;
        }

        public CreationInfoBuilder addCreatedUsing(Tool createdUsing) {
            if (Objects.nonNull((Object)createdUsing)) {
                this.createdUsings.add(createdUsing);
            }
            return this;
        }

        public CreationInfoBuilder addAllCreatedUsing(Collection<Tool> createdUsingCollection) {
            if (Objects.nonNull(createdUsingCollection)) {
                this.createdUsings.addAll(createdUsingCollection);
            }
            return this;
        }

        public CreationInfoBuilder setCreated(String created) {
            this.created = created;
            return this;
        }

        public CreationInfoBuilder setSpecVersion(String specVersion) {
            this.specVersion = specVersion;
            return this;
        }

        public CreationInfoBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public CreationInfo build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                CreationInfo creationInfo = new CreationInfo(this);
                return creationInfo;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

